/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.g2.engine.plugin;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ArraySet<T>
extends AbstractSet<T>
implements Set<T> {
    private ArrayList<T> list;

    public ArraySet() {
        this.list = new ArrayList();
    }

    public ArraySet(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public ArraySet(T[] elements) {
        this(elements.length);
        for (T elem : elements) {
            if (this.list.contains(elem)) continue;
            this.list.add(elem);
        }
    }

    public ArraySet(Collection<? extends T> elements) {
        this(elements.size());
        for (T elem : elements) {
            if (this.list.contains(elem)) continue;
            this.list.add(elem);
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean add(T elem) {
        if (this.list.contains(elem)) {
            return false;
        }
        return this.list.add(elem);
    }

    @Override
    public boolean contains(Object elem) {
        return this.list.contains(elem);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean remove(Object elem) {
        return this.list.remove(elem);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.list.toArray(array);
    }
}

