/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.webview.impl;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.webkit.WebView;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.jsbridge.AppWebViewInterface;
import java.lang.reflect.Method;
import org.json.JSONObject;

public class SAWebViewProtocolImpl {
    private static final String TAG = "SA.WebViewProtocolImpl";
    private final Context mContext;
    private final String JS_BRIDGE = "SensorsData_APP_JS_Bridge";

    public SAWebViewProtocolImpl(SAContextManager mContextManager) {
        this.mContext = mContextManager.getContext();
    }

    public <T> T invokeModuleFunction(String methodName, Object ... argv) {
        switch (methodName) {
            case "showUpWebView": {
                this.showUpWebView((WebView)argv[0], (JSONObject)argv[1], (Boolean)argv[2], (Boolean)argv[3]);
                break;
            }
            case "showUpX5WebView": {
                this.showUpX5WebView(argv[0], (JSONObject)argv[1], (Boolean)argv[2], (Boolean)argv[3]);
            }
        }
        return null;
    }

    private void showUpWebView(WebView webView, JSONObject properties, boolean isSupportJellyBean, boolean enableVerify) {
        if (Build.VERSION.SDK_INT < 17 && !isSupportJellyBean) {
            SALog.i((String)TAG, (String)"For applications targeted to API level JELLY_BEAN or below, this feature NOT SUPPORTED");
            return;
        }
        if (webView != null) {
            webView.getSettings().setJavaScriptEnabled(true);
            webView.addJavascriptInterface((Object)new AppWebViewInterface(this.mContext, properties, enableVerify, (View)webView), "SensorsData_APP_JS_Bridge");
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "addVisualJavascriptInterface", new Object[]{webView});
        }
    }

    private void showUpX5WebView(Object x5WebView, JSONObject properties, boolean isSupportJellyBean, boolean enableVerify) {
        try {
            if (Build.VERSION.SDK_INT < 17 && !isSupportJellyBean) {
                SALog.d((String)TAG, (String)"For applications targeted to API level JELLY_BEAN or below, this feature NOT SUPPORTED");
                return;
            }
            if (x5WebView == null) {
                return;
            }
            Class<?> clazz = x5WebView.getClass();
            Method addJavascriptInterface = clazz.getMethod("addJavascriptInterface", Object.class, String.class);
            if (addJavascriptInterface == null) {
                return;
            }
            addJavascriptInterface.invoke(x5WebView, new AppWebViewInterface(this.mContext, properties, enableVerify), "SensorsData_APP_JS_Bridge");
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "addVisualJavascriptInterface", new Object[]{x5WebView});
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

