/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.LruCache;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import com.sensorsdata.analytics.android.sdk.util.DeviceUtils;
import com.sensorsdata.analytics.android.sdk.util.Dispatcher;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.SnapCache;
import com.sensorsdata.analytics.android.sdk.util.WebUtils;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewUtil;
import com.sensorsdata.analytics.android.sdk.visual.NodesProcess;
import com.sensorsdata.analytics.android.sdk.visual.R;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackService;
import com.sensorsdata.analytics.android.sdk.visual.model.CommonNode;
import com.sensorsdata.analytics.android.sdk.visual.model.FlutterNode;
import com.sensorsdata.analytics.android.sdk.visual.model.FlutterNodeInfo;
import com.sensorsdata.analytics.android.sdk.visual.model.NodeInfo;
import com.sensorsdata.analytics.android.sdk.visual.model.SnapInfo;
import com.sensorsdata.analytics.android.sdk.visual.model.WebNode;
import com.sensorsdata.analytics.android.sdk.visual.model.WebNodeInfo;
import com.sensorsdata.analytics.android.sdk.visual.snap.PropertyDescription;
import com.sensorsdata.analytics.android.sdk.visual.snap.ResourceIds;
import com.sensorsdata.analytics.android.sdk.visual.snap.SoftWareCanvas;
import com.sensorsdata.analytics.android.sdk.visual.utils.AlertMessageUtils;
import com.sensorsdata.analytics.android.sdk.visual.utils.VisualUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONObject;

public class ViewSnapshot {
    private static final int MAX_CLASS_NAME_CACHE_SIZE = 255;
    private static final int JS_NOT_INTEGRATED_ALERT_TIME_OUT = 5000;
    private static final String TAG = "SA.ViewSnapshot";
    private final RootViewFinder mRootViewFinder;
    private final List<PropertyDescription> mProperties;
    private final ClassNameCache mClassnameCache;
    private final Handler mMainThreadHandler;
    private final ResourceIds mResourceIds;
    private SnapInfo mSnapInfo = new SnapInfo();

    public ViewSnapshot(List<PropertyDescription> properties, ResourceIds resourceIds, Handler mainThreadHandler) {
        this.mProperties = properties;
        this.mResourceIds = resourceIds;
        this.mMainThreadHandler = mainThreadHandler;
        this.mRootViewFinder = new RootViewFinder();
        this.mClassnameCache = new ClassNameCache(255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapInfo snapshots(OutputStream out, StringBuilder lastImageHash) throws IOException {
        long startSnapshot = System.currentTimeMillis();
        FutureTask<List<RootViewInfo>> infoFuture = new FutureTask<List<RootViewInfo>>(this.mRootViewFinder);
        this.mMainThreadHandler.post(infoFuture);
        BufferedOutputStream writer = new BufferedOutputStream(out);
        List<Object> infoList = Collections.emptyList();
        ((OutputStream)writer).write("[".getBytes());
        try {
            infoList = infoFuture.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            SALog.i((String)TAG, (String)"Screenshot interrupted, no screenshot will be sent.", (Throwable)e);
        }
        catch (TimeoutException e) {
            SALog.i((String)TAG, (String)"Screenshot took more than 2 second to be scheduled and executed. No screenshot will be sent.", (Throwable)e);
        }
        catch (ExecutionException e) {
            SALog.i((String)TAG, (String)"Exception thrown during screenshot attempt", (Throwable)e);
        }
        catch (Throwable e) {
            SALog.i((String)TAG, (String)"Throwable thrown during screenshot attempt", (Throwable)e);
        }
        finally {
            infoFuture.cancel(true);
            this.mMainThreadHandler.removeCallbacks(infoFuture);
        }
        String screenName = null;
        String activityTitle = null;
        int infoCount = infoList.size();
        SALog.i((String)TAG, (String)("infoCount:" + infoCount + ",time:" + (System.currentTimeMillis() - startSnapshot)));
        for (int i = 0; i < infoCount; ++i) {
            RootViewInfo info = (RootViewInfo)infoList.get(i);
            if (i > 0) {
                ((OutputStream)writer).write(",".getBytes());
            }
            if (info != null && info.screenshot != null && (this.isSnapShotUpdated(info.screenshot.getImageHash(), lastImageHash) || i > 0)) {
                ((OutputStream)writer).write("{".getBytes());
                ((OutputStream)writer).write("\"activity\":".getBytes());
                screenName = info.screenName;
                activityTitle = info.activityTitle;
                ((OutputStream)writer).write(JSONObject.quote((String)info.screenName).getBytes());
                ((OutputStream)writer).write(",".getBytes());
                ((OutputStream)writer).write("\"scale\":".getBytes());
                ((OutputStream)writer).write(String.format("%s", Float.valueOf(info.scale)).getBytes());
                ((OutputStream)writer).write(",".getBytes());
                ((OutputStream)writer).write("\"serialized_objects\":".getBytes());
                try {
                    JSONObject jsonRootObject = new JSONObject();
                    jsonRootObject.put("rootObject", info.rootView.hashCode());
                    JSONArray jsonObjects = new JSONArray();
                    this.snapshotViewHierarchy(jsonObjects, info.rootView);
                    jsonRootObject.put("objects", (Object)jsonObjects);
                    ((OutputStream)writer).write(jsonRootObject.toString().getBytes());
                    SALog.i((String)TAG, (String)("snapshotViewHierarchy:" + (System.currentTimeMillis() - startSnapshot)));
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
                ((OutputStream)writer).write(",".getBytes());
                ((OutputStream)writer).write("\"image_hash\":".getBytes());
                ((OutputStream)writer).write(JSONObject.quote((String)info.screenshot.getImageHash()).getBytes());
                ((OutputStream)writer).write(",".getBytes());
                ((OutputStream)writer).write("\"screenshot\":".getBytes());
                ((OutputStream)writer).flush();
                info.screenshot.writeBitmapJSON(Bitmap.CompressFormat.PNG, 70, out);
                ((OutputStream)writer).write("}".getBytes());
                continue;
            }
            ((OutputStream)writer).write("{}".getBytes());
        }
        ((OutputStream)writer).write("]".getBytes());
        ((OutputStream)writer).flush();
        this.mSnapInfo.screenName = screenName;
        this.mSnapInfo.activityTitle = activityTitle;
        Activity activity = AppStateTools.getInstance().getForegroundActivity();
        if (activity != null) {
            this.mSnapInfo.isFlutter = ViewUtil.instanceOfFlutterActivity((Object)activity);
            this.mSnapInfo.activityName = SnapCache.getInstance().getCanonicalName(activity.getClass());
        }
        return this.mSnapInfo;
    }

    private void getVisibleRect(View view, Rect rect, boolean fullscreen) {
        if (fullscreen) {
            view.getGlobalVisibleRect(rect);
            return;
        }
        int[] offset = new int[2];
        view.getLocationOnScreen(offset);
        view.getLocalVisibleRect(rect);
        rect.offset(offset[0], offset[1]);
    }

    private void snapshotViewHierarchy(JSONArray j, View rootView) throws Exception {
        this.reset();
        this.snapshotView(j, rootView, 0);
        NodesProcess.getInstance().getWebNodesManager().setHasThirdView(this.mSnapInfo.isWebView);
        NodesProcess.getInstance().getFlutterNodesManager().setHasThirdView(this.mSnapInfo.isFlutter);
    }

    private void reset() {
        this.mSnapInfo = new SnapInfo();
    }

    private void snapshotView(JSONArray j, final View view, int viewIndex) throws Exception {
        if (SAViewUtils.isViewSelfVisible((View)view)) {
            Object rules;
            ViewNode viewNode;
            ArrayList<String> webNodeIds = new ArrayList<String>();
            int webViewElementLevel = this.mSnapInfo.elementLevel;
            if (ViewUtil.instanceOfFlutterSurfaceView((Object)view)) {
                FlutterNodeInfo flutterNodeInfo;
                Activity activity;
                this.mSnapInfo.isFlutter = true;
                String activityName = this.mSnapInfo.activityName;
                if (TextUtils.isEmpty((CharSequence)activityName) && (activity = AppStateTools.getInstance().getForegroundActivity()) != null) {
                    this.mSnapInfo.activityName = activityName = SnapCache.getInstance().getCanonicalName(activity.getClass());
                }
                if ((flutterNodeInfo = (FlutterNodeInfo)NodesProcess.getInstance().getFlutterNodesManager().getPageInfo(this.mSnapInfo.activityName)) != null) {
                    this.mSnapInfo.flutterLibVersion = flutterNodeInfo.getFlutter_lib_version();
                }
                this.snapshotFlutterView(j, view, webNodeIds, this.mSnapInfo);
            }
            if (ViewUtil.instanceOfWebView((Object)view)) {
                this.mSnapInfo.isWebView = true;
                final CountDownLatch latch = new CountDownLatch(1);
                try {
                    view.post(new Runnable(){

                        @Override
                        public void run() {
                            String url = (String)ReflectUtil.callMethod((Object)view, (String)"getUrl", (Object[])new Object[0]);
                            if (!TextUtils.isEmpty((CharSequence)url)) {
                                ((ViewSnapshot)ViewSnapshot.this).mSnapInfo.webViewUrl = url;
                                Float scale = (Float)ReflectUtil.callMethod((Object)view, (String)"getScale", (Object[])new Object[0]);
                                if (scale != null) {
                                    ((ViewSnapshot)ViewSnapshot.this).mSnapInfo.webViewScale = scale.floatValue();
                                }
                                latch.countDown();
                                WebUtils.loadUrl((View)view, (String)"javascript:window.sensorsdata_app_call_js('visualized')");
                            } else {
                                latch.countDown();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
                try {
                    latch.await(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    SALog.printStackTrace((Exception)e);
                }
                SALog.i((String)TAG, (String)("WebView url: " + this.mSnapInfo.webViewUrl));
                if (!TextUtils.isEmpty((CharSequence)this.mSnapInfo.webViewUrl)) {
                    WebNodeInfo webNodeInfo = (WebNodeInfo)NodesProcess.getInstance().getWebNodesManager().getNodes(this.mSnapInfo.webViewUrl);
                    if (webNodeInfo != null) {
                        if (webNodeInfo.getStatus() == NodeInfo.Status.SUCCESS) {
                            List<? extends CommonNode> webNodes = webNodeInfo.getNodes();
                            if (webNodes != null && webNodes.size() > 0) {
                                webNodeIds = new ArrayList();
                                for (WebNode webNode : webNodes) {
                                    this.mergeThirdViewNodes(j, webNode, view, this.mSnapInfo.webViewScale);
                                    if (!webNode.isRootView()) continue;
                                    webNodeIds.add(webNode.getId() + view.hashCode());
                                }
                            }
                        } else if (webNodeInfo.getStatus() == NodeInfo.Status.FAILURE) {
                            this.mSnapInfo.alertInfos = webNodeInfo.getAlertInfos();
                        }
                    } else {
                        AlertMessageUtils.AlertRunnable alertRunnable = new AlertMessageUtils.AlertRunnable(AlertMessageUtils.AlertRunnable.AlertType.H5, this.mSnapInfo.webViewUrl);
                        Dispatcher.getInstance().postDelayed((Runnable)alertRunnable, 5000L);
                    }
                }
            }
            JSONObject jsonSnapObject = new JSONObject();
            jsonSnapObject.put("hashCode", view.hashCode());
            jsonSnapObject.put("id", view.getId());
            jsonSnapObject.put("index", SAViewUtils.getChildIndex((ViewParent)view.getParent(), (View)view));
            if (ViewUtil.instanceOfWebView((Object)view) || ViewUtil.instanceOfFlutterSurfaceView((Object)view)) {
                jsonSnapObject.put("element_level", webViewElementLevel);
            } else {
                jsonSnapObject.put("element_level", ++this.mSnapInfo.elementLevel);
            }
            jsonSnapObject.put("element_selector", (Object)SAViewUtils.getElementSelector((View)view));
            JSONObject object = VisualUtil.getScreenNameAndTitle(view, this.mSnapInfo);
            if (object != null) {
                String screenName = object.optString("$screen_name");
                String title = object.optString("$title");
                if (!TextUtils.isEmpty((CharSequence)screenName)) {
                    jsonSnapObject.put("screen_name", (Object)screenName);
                }
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    jsonSnapObject.put("title", (Object)title);
                }
            }
            if ((viewNode = ViewUtil.getViewNode((View)view, (int)viewIndex, (boolean)true)) != null) {
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPath())) {
                    jsonSnapObject.put("element_path", (Object)viewNode.getViewPath());
                }
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPosition())) {
                    jsonSnapObject.put("element_position", (Object)viewNode.getViewPosition());
                }
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewContent()) && VisualUtil.isSupportElementContent(view)) {
                    jsonSnapObject.put("element_content", (Object)viewNode.getViewContent());
                }
                jsonSnapObject.put("is_list_view", viewNode.isListView());
            }
            jsonSnapObject.put("element_platform", (Object)"android");
            jsonSnapObject.put("sa_id_name", (Object)this.getResName(view));
            try {
                String saId = (String)view.getTag(R.id.sensors_analytics_tag_view_id);
                if (!TextUtils.isEmpty((CharSequence)saId)) {
                    jsonSnapObject.put("sa_id_name", (Object)saId);
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            if (!WindowHelper.isMainWindow((View)view.getRootView())) {
                if (WindowHelper.isDecorView(view.getClass())) {
                    DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
                    int n = displayMetrics.widthPixels;
                    int screenHeight = displayMetrics.heightPixels;
                    jsonSnapObject.put("top", view.getTop());
                    jsonSnapObject.put("left", view.getLeft());
                    jsonSnapObject.put("width", n);
                    jsonSnapObject.put("height", screenHeight);
                } else {
                    ViewParent parent = view.getParent();
                    if (parent != null && WindowHelper.isDecorView(parent.getClass())) {
                        Rect rect = new Rect();
                        this.getVisibleRect(view, rect, false);
                        jsonSnapObject.put("top", rect.top);
                        jsonSnapObject.put("left", rect.left);
                        jsonSnapObject.put("width", rect.width());
                        jsonSnapObject.put("height", rect.height());
                    } else {
                        jsonSnapObject.put("top", view.getTop());
                        jsonSnapObject.put("left", view.getLeft());
                        jsonSnapObject.put("width", view.getWidth());
                        jsonSnapObject.put("height", view.getHeight());
                    }
                }
            } else {
                jsonSnapObject.put("top", view.getTop());
                jsonSnapObject.put("left", view.getLeft());
                jsonSnapObject.put("width", view.getWidth());
                jsonSnapObject.put("height", view.getHeight());
            }
            int scrollX = view.getScrollX();
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                if (Build.VERSION.SDK_INT >= 16 && textView.getMaxLines() == 1) {
                    scrollX = 0;
                }
            }
            if (ViewUtil.instanceOfX5WebView((Object)view)) {
                try {
                    jsonSnapObject.put("scrollX", ReflectUtil.callMethod((Object)view, (String)"getWebScrollX", (Object[])new Object[0]));
                    jsonSnapObject.put("scrollY", ReflectUtil.callMethod((Object)view, (String)"getWebScrollY", (Object[])new Object[0]));
                }
                catch (Exception exception) {
                    SALog.printStackTrace((Exception)exception);
                }
            } else {
                jsonSnapObject.put("scrollX", scrollX);
                jsonSnapObject.put("scrollY", view.getScrollY());
            }
            jsonSnapObject.put("visibility", VisualUtil.getVisibility(view));
            float f = view.getTranslationX();
            float translationY = view.getTranslationY();
            jsonSnapObject.put("translationX", (double)f);
            jsonSnapObject.put("translationY", (double)translationY);
            JSONArray classesArray = new JSONArray();
            Class<?> klass = view.getClass();
            do {
                classesArray.put(this.mClassnameCache.get(klass));
            } while ((klass = klass.getSuperclass()) != Object.class && klass != null);
            jsonSnapObject.put("classes", (Object)classesArray);
            this.addProperties(jsonSnapObject, view);
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams instanceof RelativeLayout.LayoutParams) {
                RelativeLayout.LayoutParams relativeLayoutParams = (RelativeLayout.LayoutParams)layoutParams;
                rules = relativeLayoutParams.getRules();
                JSONArray layoutArray = new JSONArray();
                for (int rule : rules) {
                    layoutArray.put(rule);
                }
                jsonSnapObject.put("layoutRules", (Object)layoutArray);
            }
            JSONArray subviewsArray = new JSONArray();
            if (webNodeIds != null && webNodeIds.size() > 0) {
                rules = webNodeIds.iterator();
                while (rules.hasNext()) {
                    String id2 = (String)rules.next();
                    subviewsArray.put((Object)id2);
                }
            } else if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int childCount = group.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    View child = group.getChildAt(i);
                    if (null == child) continue;
                    subviewsArray.put(child.hashCode());
                }
            }
            jsonSnapObject.put("subviews", (Object)subviewsArray);
            j.put((Object)jsonSnapObject);
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = group.getChildAt(i);
                if (null == child) continue;
                this.snapshotView(j, child, i);
            }
        }
    }

    private void snapshotFlutterView(JSONArray j, View view, List<String> flutterNodeIds, SnapInfo info) {
        String activityName = info.activityName;
        if (TextUtils.isEmpty((CharSequence)activityName)) {
            return;
        }
        FlutterNodeInfo flutterNodeInfo = (FlutterNodeInfo)NodesProcess.getInstance().getFlutterNodesManager().getNodes(activityName);
        if (flutterNodeInfo != null) {
            if (flutterNodeInfo.getStatus() == NodeInfo.Status.SUCCESS) {
                List<? extends CommonNode> flutterNodes = flutterNodeInfo.getNodes();
                if (flutterNodes != null && flutterNodes.size() > 0) {
                    for (FlutterNode flutterNode : flutterNodes) {
                        float scaledDensity = SensorsDataAPI.sharedInstance().getSAContextManager().getContext().getResources().getDisplayMetrics().scaledDensity;
                        this.mergeThirdViewNodes(j, flutterNode, view, scaledDensity);
                        if (!flutterNode.isRootView()) continue;
                        flutterNodeIds.add(flutterNode.getId() + view.hashCode());
                    }
                }
            } else if (flutterNodeInfo.getStatus() == NodeInfo.Status.FAILURE) {
                this.mSnapInfo.flutter_alertInfos = flutterNodeInfo.getAlertInfos();
            }
        } else {
            AlertMessageUtils.AlertRunnable alertRunnable = new AlertMessageUtils.AlertRunnable(AlertMessageUtils.AlertRunnable.AlertType.FLUTTER, activityName);
            Dispatcher.getInstance().postDelayed((Runnable)alertRunnable, 5000L);
        }
    }

    private void addProperties(JSONObject j, View v) throws Exception {
        j.put("importantForAccessibility", true);
        Class<?> viewClass = v.getClass();
        for (PropertyDescription desc : this.mProperties) {
            Object value;
            if (!desc.targetClass.isAssignableFrom(viewClass) || null == desc.accessor || null == (value = desc.accessor.applyMethod(v))) continue;
            if (value instanceof Number) {
                j.put(desc.name, value);
                continue;
            }
            if (value instanceof Boolean) {
                boolean clickable = (Boolean)value;
                if ("clickable".equals(desc.name)) {
                    if (VisualUtil.isSupportClick(v)) {
                        clickable = true;
                    } else if (VisualUtil.isForbiddenClick(v)) {
                        clickable = false;
                    }
                }
                j.put(desc.name, clickable);
                continue;
            }
            if (value instanceof ColorStateList) {
                j.put(desc.name, (Object)((ColorStateList)value).getDefaultColor());
                continue;
            }
            if (value instanceof Drawable) {
                Drawable drawable2 = (Drawable)value;
                Rect bounds = drawable2.getBounds();
                JSONObject json = new JSONObject();
                JSONArray classesArray = new JSONArray();
                for (Class<?> klass = drawable2.getClass(); klass != Object.class && klass != null; klass = klass.getSuperclass()) {
                    String canonicalName = SnapCache.getInstance().getCanonicalName(klass);
                    classesArray.put((Object)canonicalName);
                }
                json.put("classes", (Object)classesArray);
                JSONObject jsonDimensions = new JSONObject();
                jsonDimensions.put("left", bounds.left);
                jsonDimensions.put("right", bounds.right);
                jsonDimensions.put("top", bounds.top);
                jsonDimensions.put("bottom", bounds.bottom);
                json.put("dimensions", (Object)jsonDimensions);
                if (drawable2 instanceof ColorDrawable) {
                    ColorDrawable colorDrawable = (ColorDrawable)drawable2;
                    json.put("color", colorDrawable.getColor());
                }
                j.put(desc.name, (Object)json);
                continue;
            }
            j.put(desc.name, (Object)value.toString());
        }
    }

    private boolean isSnapShotUpdated(String newImageHash, StringBuilder lastImageHash) {
        boolean isUpdated = false;
        if (newImageHash != null && lastImageHash != null) {
            isUpdated = newImageHash.equals(lastImageHash.toString());
        }
        boolean bl = isUpdated = !isUpdated || NodesProcess.getInstance().getWebNodesManager().hasAlertInfo() || NodesProcess.getInstance().getFlutterNodesManager().hasAlertInfo();
        if (lastImageHash != null) {
            lastImageHash.delete(0, lastImageHash.length()).append(newImageHash);
        }
        return isUpdated;
    }

    private String getResName(View view) {
        int viewId = view.getId();
        if (-1 == viewId) {
            return null;
        }
        return this.mResourceIds.nameForId(viewId);
    }

    private void mergeThirdViewNodes(JSONArray j, CommonNode view, View webView, float webViewScale) {
        try {
            JSONObject jsonWebView = new JSONObject();
            jsonWebView.put("hashCode", (Object)(view.getId() + webView.hashCode()));
            jsonWebView.put("index", 0);
            if (!TextUtils.isEmpty((CharSequence)view.get$element_content())) {
                jsonWebView.put("element_content", (Object)view.get$element_content());
            }
            jsonWebView.put("element_level", ++this.mSnapInfo.elementLevel);
            if (webViewScale == 0.0f) {
                webViewScale = view.getScale();
            }
            float top = view.getTop() * webViewScale;
            float left = view.getLeft() * webViewScale;
            jsonWebView.put("left", (double)left);
            jsonWebView.put("top", (double)top);
            jsonWebView.put("width", (int)(view.getWidth() * webViewScale));
            jsonWebView.put("height", (int)(view.getHeight() * webViewScale));
            boolean insideWebView = view.getOriginTop() * webViewScale <= (float)webView.getHeight() && view.getOriginLeft() * webViewScale <= (float)webView.getWidth();
            jsonWebView.put("visibility", view.isVisibility() && insideWebView ? 0 : 8);
            jsonWebView.put("clickable", view.isEnable_click());
            jsonWebView.put("importantForAccessibility", true);
            jsonWebView.put("is_list_view", view.isIs_list_view());
            jsonWebView.put("element_path", (Object)view.get$element_path());
            if (!TextUtils.isEmpty((CharSequence)view.get$element_position())) {
                jsonWebView.put("element_position", (Object)view.get$element_position());
            }
            this.mSnapInfo.webLibVersion = view.getLib_version();
            jsonWebView.put("scrollX", 0);
            jsonWebView.put("scrollY", 0);
            if (view instanceof WebNode) {
                WebNode webNode = (WebNode)view;
                jsonWebView.put("h5_title", (Object)webNode.get$title());
                jsonWebView.put("tag_name", (Object)webNode.getTagName());
                jsonWebView.put("url", (Object)webNode.get$url());
                if (!TextUtils.isEmpty((CharSequence)webNode.get$element_selector())) {
                    jsonWebView.put("element_selector", (Object)webNode.get$element_selector());
                }
                jsonWebView.put("list_selector", (Object)webNode.getList_selector());
                jsonWebView.put("is_h5", true);
                jsonWebView.put("element_platform", (Object)"h5");
            }
            if (view instanceof FlutterNode) {
                FlutterNode flutterNode = (FlutterNode)view;
                jsonWebView.put("title", (Object)flutterNode.getTitle());
                jsonWebView.put("screen_name", (Object)flutterNode.getScreen_name());
                jsonWebView.put("element_platform", (Object)"flutter");
            }
            JSONArray classesArray = new JSONArray();
            if (view instanceof WebNode) {
                WebNode webNode = (WebNode)view;
                classesArray.put((Object)webNode.getTagName());
            }
            Class<?> klass = webView.getClass();
            do {
                String canonicalName = SnapCache.getInstance().getCanonicalName(klass);
                classesArray.put((Object)canonicalName);
            } while ((klass = klass.getSuperclass()) != Object.class && klass != null);
            jsonWebView.put("classes", (Object)classesArray);
            List<String> list = view.getSubelements();
            JSONArray subviewsArray = new JSONArray();
            if (list != null && list.size() > 0) {
                for (String id2 : list) {
                    subviewsArray.put((Object)(id2 + webView.hashCode()));
                }
            }
            jsonWebView.put("subviews", (Object)subviewsArray);
            j.put((Object)jsonWebView);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private static class RootViewInfo {
        final String screenName;
        final String activityTitle;
        final View rootView;
        CachedBitmap screenshot;
        float scale;

        RootViewInfo(String screenName, String activityTitle, View rootView) {
            this.screenName = screenName;
            this.activityTitle = activityTitle;
            this.rootView = rootView;
            this.screenshot = null;
            this.scale = 1.0f;
        }
    }

    private static class CachedBitmap {
        private final Paint mPaint = new Paint(2);
        private Bitmap mCached = null;
        private String mImageHash = "";

        public synchronized void recreate(int width, int height, int destDensity, Bitmap source) {
            if (null == this.mCached || this.mCached.getWidth() != width || this.mCached.getHeight() != height) {
                try {
                    this.mCached = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
                catch (Throwable e) {
                    this.mCached = null;
                }
                if (null != this.mCached) {
                    this.mCached.setDensity(destDensity);
                }
            }
            if (null != this.mCached) {
                Canvas scaledCanvas = new Canvas(this.mCached);
                scaledCanvas.drawBitmap(source, 0.0f, 0.0f, this.mPaint);
                try {
                    byte[] debugInfoBytes;
                    String debugInfo;
                    byte[] webNodesArray;
                    ByteArrayOutputStream imageByte = new ByteArrayOutputStream();
                    this.mCached.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)imageByte);
                    byte[] array = imageByte.toByteArray();
                    String msg = NodesProcess.getInstance().getWebNodesManager().getLastThirdMsg();
                    if (!TextUtils.isEmpty((CharSequence)msg) && (webNodesArray = msg.getBytes()) != null && webNodesArray.length > 0) {
                        array = CachedBitmap.concat(array, webNodesArray);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(msg = NodesProcess.getInstance().getFlutterNodesManager().getLastThirdMsg())) && (webNodesArray = msg.getBytes()) != null && webNodesArray.length > 0) {
                        array = CachedBitmap.concat(array, webNodesArray);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(debugInfo = VisualizedAutoTrackService.getInstance().getLastDebugInfo())) && (debugInfoBytes = debugInfo.getBytes()) != null && debugInfoBytes.length > 0) {
                        array = CachedBitmap.concat(array, debugInfoBytes);
                    }
                    byte[] md5 = MessageDigest.getInstance("MD5").digest(array);
                    this.mImageHash = this.toHex(md5);
                }
                catch (Exception e) {
                    SALog.i((String)ViewSnapshot.TAG, (String)("CachedBitmap.recreate;Create image_hash error=" + e));
                }
            }
        }

        private static byte[] concat(byte[] first, byte[] second) {
            byte[] result = new byte[first.length + second.length];
            System.arraycopy(first, 0, result, 0, first.length);
            System.arraycopy(second, 0, result, first.length, second.length);
            return result;
        }

        public synchronized void writeBitmapJSON(Bitmap.CompressFormat format, int quality, OutputStream out) throws IOException {
            if (null == this.mCached || this.mCached.getWidth() == 0 || this.mCached.getHeight() == 0) {
                out.write("null".getBytes());
            } else {
                out.write(34);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                this.mCached.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                stream.flush();
                String bitmapStr = new String(Base64Coder.encode((byte[])stream.toByteArray()));
                out.write(bitmapStr.getBytes());
                out.write(34);
            }
        }

        private String getImageHash() {
            return this.mImageHash;
        }

        private String toHex(byte[] ary) {
            String hex = "0123456789ABCDEF";
            String ret = "";
            for (int i = 0; i < ary.length; ++i) {
                ret = ret + "0123456789ABCDEF".charAt(ary[i] >> 4 & 0xF);
                ret = ret + "0123456789ABCDEF".charAt(ary[i] & 0xF);
            }
            return ret;
        }
    }

    private static class RootViewFinder
    implements Callable<List<RootViewInfo>> {
        private final List<RootViewInfo> mRootViews = new ArrayList<RootViewInfo>();
        private final CachedBitmap mCachedBitmap = new CachedBitmap();
        private final int mClientDensity = 160;

        @Override
        public List<RootViewInfo> call() throws Exception {
            this.mRootViews.clear();
            try {
                Activity activity = AppStateTools.getInstance().getForegroundActivity();
                if (activity != null) {
                    FlutterNodeInfo flutterNodeInfo;
                    JSONObject object = SAPageInfoUtils.getActivityPageInfo((Activity)activity);
                    JSONObject rnJson = SAPageInfoUtils.getRNPageInfo();
                    if (object == null) {
                        object = new JSONObject();
                    }
                    JSONUtils.mergeDuplicateProperty((JSONObject)rnJson, (JSONObject)object);
                    String screenName = object.optString("$screen_name");
                    String activityTitle = object.optString("$title");
                    boolean isFlutter = ViewUtil.instanceOfFlutterActivity((Object)activity);
                    if (isFlutter && (flutterNodeInfo = (FlutterNodeInfo)NodesProcess.getInstance().getFlutterNodesManager().getPageInfo(SnapCache.getInstance().getCanonicalName(activity.getClass()))) != null) {
                        String flutter_screenName = flutterNodeInfo.getScreen_name();
                        String flutter_title = flutterNodeInfo.getTitle();
                        if (!TextUtils.isEmpty((CharSequence)screenName)) {
                            screenName = flutter_screenName;
                        }
                        if (!TextUtils.isEmpty((CharSequence)flutter_title)) {
                            activityTitle = flutter_title;
                        }
                    }
                    View rootView = null;
                    Window window = activity.getWindow();
                    if (window != null && window.isActive()) {
                        rootView = window.getDecorView().getRootView();
                    }
                    if (rootView == null) {
                        return this.mRootViews;
                    }
                    RootViewInfo info = new RootViewInfo(screenName, activityTitle, rootView);
                    View[] views = WindowHelper.getSortedWindowViews();
                    if (isFlutter) {
                        Bitmap bitmap = RootViewFinder.getFlutterBitmap(activity);
                        this.scaleBitmap(info, bitmap);
                        this.mRootViews.add(info);
                    } else if (views != null && views.length > 0) {
                        Bitmap bitmap = this.mergeViewLayers(views, info);
                        for (View view : views) {
                            if (view.getWindowVisibility() != 0 || view.getVisibility() != 0 || view.getWidth() == 0 || view.getHeight() == 0 || TextUtils.equals((CharSequence)WindowHelper.getWindowPrefix((View)view), (CharSequence)WindowHelper.getMainWindowPrefix()) || WindowHelper.isCustomWindow((View)view)) continue;
                            RootViewInfo subInfo = new RootViewInfo(screenName, activityTitle, view.getRootView());
                            this.scaleBitmap(subInfo, bitmap);
                            this.mRootViews.add(subInfo);
                        }
                        if (this.mRootViews.size() == 0) {
                            this.scaleBitmap(info, bitmap);
                            this.mRootViews.add(info);
                        }
                    }
                }
            }
            catch (Throwable e) {
                SALog.d((String)ViewSnapshot.TAG, (String)("" + e));
            }
            return this.mRootViews;
        }

        private static Bitmap getFlutterBitmap(Activity activity) {
            Bitmap bitmap = null;
            try {
                Method method_flutterEngine = Class.forName("io.flutter.embedding.android.FlutterActivity").getDeclaredMethod("getFlutterEngine", new Class[0]);
                method_flutterEngine.setAccessible(true);
                Object flutterEngine = method_flutterEngine.invoke((Object)activity, new Object[0]);
                Method method_getRender = Class.forName("io.flutter.embedding.engine.FlutterEngine").getMethod("getRenderer", new Class[0]);
                method_getRender.setAccessible(true);
                Object flutterRenderer = method_getRender.invoke(flutterEngine, new Object[0]);
                Method method_bitmap = Class.forName("io.flutter.embedding.engine.renderer.FlutterRenderer").getMethod("getBitmap", new Class[0]);
                method_bitmap.setAccessible(true);
                bitmap = (Bitmap)method_bitmap.invoke(flutterRenderer, new Object[0]);
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            return bitmap;
        }

        Bitmap mergeViewLayers(View[] views, RootViewInfo info) {
            int width = info.rootView.getWidth();
            int height = info.rootView.getHeight();
            if (width == 0 || height == 0) {
                int[] screenSize = DeviceUtils.getDeviceSize((Context)SensorsDataAPI.sharedInstance().getSAContextManager().getContext());
                width = screenSize[0];
                height = screenSize[1];
                if (width == 0 || height == 0) {
                    return null;
                }
            }
            Bitmap fullScreenBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            SoftWareCanvas canvas = new SoftWareCanvas(fullScreenBitmap);
            int[] windowOffset = new int[2];
            boolean isDrawBackground = false;
            boolean skipOther = ViewUtil.getMainWindowCount((View[])views) > 1;
            WindowHelper.init();
            ViewUtil.invalidateLayerTypeView((View[])views);
            for (View view : views) {
                if (view.getVisibility() != 0 || view.getWidth() == 0 || view.getHeight() == 0 || !ViewUtil.isWindowNeedTraverse((View)view, (String)WindowHelper.getWindowPrefix((View)view), (boolean)skipOther)) continue;
                canvas.save();
                if (!WindowHelper.isMainWindow((View)view)) {
                    view.getLocationOnScreen(windowOffset);
                    canvas.translate(windowOffset[0], windowOffset[1]);
                    if (WindowHelper.isDialogOrPopupWindow((View)view) && !isDrawBackground) {
                        isDrawBackground = true;
                        Paint paint = new Paint();
                        paint.setColor(-1610612736);
                        canvas.drawRect(-((float)windowOffset[0]), -((float)windowOffset[1]), canvas.getWidth(), canvas.getHeight(), paint);
                    }
                }
                view.draw((Canvas)canvas);
                canvas.restoreToCount(1);
            }
            canvas.destroy();
            return fullScreenBitmap;
        }

        private void scaleBitmap(RootViewInfo info, Bitmap rawBitmap) {
            float scale = 1.0f;
            if (null != rawBitmap) {
                int rawDensity = rawBitmap.getDensity();
                if (rawDensity != 0) {
                    scale = 160.0f / (float)rawDensity;
                }
                int rawWidth = rawBitmap.getWidth();
                int rawHeight = rawBitmap.getHeight();
                int destWidth = (int)((double)((float)rawBitmap.getWidth() * scale) + 0.5);
                int destHeight = (int)((double)((float)rawBitmap.getHeight() * scale) + 0.5);
                if (rawWidth > 0 && rawHeight > 0 && destWidth > 0 && destHeight > 0) {
                    this.mCachedBitmap.recreate(destWidth, destHeight, 160, rawBitmap);
                }
            }
            info.scale = scale;
            info.screenshot = this.mCachedBitmap;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static class ClassNameCache
    extends LruCache<Class<?>, String> {
        public ClassNameCache(int maxSize) {
            super(maxSize);
        }

        protected String create(Class<?> klass) {
            return klass.getCanonicalName();
        }
    }
}

