/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.snap;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.sensorsdata.analytics.android.sdk.visual.snap.UIThreadSet;
import com.sensorsdata.analytics.android.sdk.visual.snap.ViewVisitor;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EditState
extends UIThreadSet<Activity> {
    private static final String TAG = "SA.EditState";
    private final Handler mUiThreadHandler = new Handler(Looper.getMainLooper());
    private final Map<String, List<ViewVisitor>> mIntendedEdits = new HashMap<String, List<ViewVisitor>>();
    private final Map<Activity, Set<EditBinding>> mCurrentEdits = new HashMap<Activity, Set<EditBinding>>();

    @Override
    public void add(Activity newOne) {
        super.add(newOne);
        this.applyEditsOnActivity(newOne);
    }

    @Override
    public void remove(Activity oldOne) {
        super.remove(oldOne);
        this.removeChangesOnActivity(oldOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyEditsOnActivity(Activity activity) {
        List<ViewVisitor> wildcardChanges;
        List<ViewVisitor> specificChanges;
        String activityName = activity.getClass().getCanonicalName();
        View rootView = null;
        Window window = activity.getWindow();
        if (window != null && window.isActive()) {
            rootView = window.getDecorView().getRootView();
        }
        if (rootView == null) {
            return;
        }
        Map<String, List<ViewVisitor>> map = this.mIntendedEdits;
        synchronized (map) {
            specificChanges = this.mIntendedEdits.get(activityName);
            wildcardChanges = this.mIntendedEdits.get(null);
        }
        if (null != specificChanges) {
            this.applyChangesFromList(activity, rootView, specificChanges);
        }
        if (null != wildcardChanges) {
            this.applyChangesFromList(activity, rootView, wildcardChanges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChangesFromList(Activity activity, View rootView, List<ViewVisitor> changes) {
        Map<Activity, Set<EditBinding>> map = this.mCurrentEdits;
        synchronized (map) {
            if (!this.mCurrentEdits.containsKey(activity)) {
                this.mCurrentEdits.put(activity, new HashSet());
            }
            int size = changes.size();
            for (int i = 0; i < size; ++i) {
                ViewVisitor visitor = changes.get(i);
                EditBinding binding = new EditBinding(rootView, visitor, this.mUiThreadHandler);
                this.mCurrentEdits.get(activity).add(binding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChangesOnActivity(Activity activity) {
        Map<Activity, Set<EditBinding>> map = this.mCurrentEdits;
        synchronized (map) {
            Set<EditBinding> bindingSet = this.mCurrentEdits.get(activity);
            if (bindingSet == null) {
                return;
            }
            for (EditBinding binding : bindingSet) {
                binding.kill();
            }
            this.mCurrentEdits.remove(activity);
        }
    }

    private static class EditBinding
    implements ViewTreeObserver.OnGlobalLayoutListener,
    Runnable {
        private final WeakReference<View> mViewRoot;
        private final ViewVisitor mEdit;
        private final Handler mHandler;
        private volatile boolean mDying;
        private boolean mAlive;

        public EditBinding(View viewRoot, ViewVisitor edit, Handler uiThreadHandler) {
            this.mEdit = edit;
            this.mViewRoot = new WeakReference<View>(viewRoot);
            this.mHandler = uiThreadHandler;
            this.mAlive = true;
            this.mDying = false;
            ViewTreeObserver observer = viewRoot.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            this.run();
        }

        public void onGlobalLayout() {
            this.run();
        }

        @Override
        public void run() {
            if (!this.mAlive) {
                return;
            }
            View viewRoot = (View)this.mViewRoot.get();
            if (null == viewRoot || this.mDying) {
                this.cleanUp();
                return;
            }
            this.mEdit.visit(viewRoot);
            this.mHandler.removeCallbacks((Runnable)this);
            this.mHandler.postDelayed((Runnable)this, 5000L);
        }

        public void kill() {
            this.mDying = true;
            this.mHandler.post((Runnable)this);
        }

        private void cleanUp() {
            if (this.mAlive) {
                ViewTreeObserver observer;
                View viewRoot = (View)this.mViewRoot.get();
                if (null != viewRoot && (observer = viewRoot.getViewTreeObserver()).isAlive()) {
                    if (Build.VERSION.SDK_INT < 16) {
                        observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
                this.mEdit.cleanup();
            }
            this.mAlive = false;
        }
    }
}

