/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual;

import android.text.TextUtils;
import android.util.LruCache;
import com.sensorsdata.analytics.android.sdk.visual.AbstractNodesManager;
import com.sensorsdata.analytics.android.sdk.visual.model.CommonNode;
import com.sensorsdata.analytics.android.sdk.visual.model.NodeInfo;
import com.sensorsdata.analytics.android.sdk.visual.model.WebNode;
import com.sensorsdata.analytics.android.sdk.visual.model.WebNodeInfo;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WebNodesManager
extends AbstractNodesManager {
    private static final String TAG = "SA.Visual.WebNodesManager";
    private String mWebViewUrl;

    @Override
    protected void handlerVisualizedTrack(List<? extends CommonNode> nodes) {
        if (!TextUtils.isEmpty((CharSequence)this.mWebViewUrl)) {
            sNodesCache.put((Object)this.mWebViewUrl, (Object)WebNodeInfo.createNodesInfo(nodes));
        }
    }

    @Override
    protected void handlerVisualizedPageInfo(String msg) {
        String url;
        WebNodeInfo pageInfo = this.parsePageInfo(msg);
        if (pageInfo == null) {
            return;
        }
        this.mWebViewUrl = pageInfo.getUrl();
        if (sPageInfoCache == null) {
            sPageInfoCache = new LruCache(10);
        }
        if (!TextUtils.isEmpty((CharSequence)(url = pageInfo.getUrl()))) {
            sPageInfoCache.put((Object)url, (Object)pageInfo);
        }
    }

    @Override
    protected void handlerVisualizedFailure(String url, List<NodeInfo.AlertInfo> list) {
        sNodesCache.put((Object)url, (Object)WebNodeInfo.createAlertInfo(list));
    }

    private WebNodeInfo parsePageInfo(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(msg);
            JSONObject data = jsonObject.getJSONObject("data");
            return WebNodeInfo.createPageInfo(data.optString("$title"), data.optString("$url"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected CommonNode parseExtraNodesInfo(JSONObject object) {
        WebNode webNode = new WebNode();
        webNode.set$element_selector(object.optString("$element_selector"));
        webNode.setTagName(object.optString("tagName"));
        webNode.set$url(object.optString("$url"));
        webNode.setzIndex(object.optInt("zIndex"));
        webNode.set$title(object.optString("$title"));
        webNode.setList_selector(object.optString("list_selector"));
        webNode.setScale((float)object.optDouble("scale"));
        webNode.setVisibility(object.optBoolean("visibility"));
        webNode.setLib_version(object.optString("lib_version"));
        return webNode;
    }
}

