/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import java.util.HashMap;

public class ExposureVisible {
    private final HashMap<String, Boolean> mVisible = new HashMap();

    public void cleanVisible() {
        this.mVisible.clear();
    }

    public boolean isVisible(View view, Rect rect) {
        if (!this.isViewSelfVisible(view, rect)) {
            return false;
        }
        if (!this.isParentVisible(view)) {
            return false;
        }
        return view.isShown();
    }

    private boolean isViewSelfVisible(View view, Rect rect) {
        boolean viewLocalVisible;
        if (view == null || view.getWindowVisibility() == 8) {
            SALog.i((String)"SA.ExposureVisible", (String)"view.getWindowVisibility() == View.GONE");
            return false;
        }
        Boolean localVisible = this.mVisible.get(view.hashCode() + "");
        if (localVisible == null) {
            viewLocalVisible = view.getLocalVisibleRect(rect);
            this.mVisible.put(view.hashCode() + "", viewLocalVisible);
        } else {
            viewLocalVisible = localVisible;
        }
        if (WindowHelper.isDecorView(view.getClass())) {
            return true;
        }
        if (view.getWidth() <= 0 || view.getHeight() <= 0 || view.getAlpha() <= 0.0f || !viewLocalVisible) {
            SALog.i((String)"SA.ExposureVisible", (String)("isViewSelfVisible\uff0cwidth = " + view.getWidth() + ",height = " + view.getHeight() + "\uff0calpha = " + view.getAlpha()));
            return false;
        }
        return view.getAnimation() != null && view.getAnimation().getFillAfter() || view.getVisibility() == 0;
    }

    private boolean isParentVisible(View view) {
        if (view == null) {
            return false;
        }
        ViewParent viewParent = view.getParent();
        do {
            if (!(viewParent instanceof View)) {
                return true;
            }
            if (this.isViewSelfVisible((View)viewParent, new Rect())) continue;
            return false;
        } while ((viewParent = viewParent.getParent()) != null);
        return false;
    }
}

