/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.encrypt.utils;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.encrypt.encryptor.SymmetricEncryptMode;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtils {
    private static final String TAG = "SensorsDataEncrypt";

    public static byte[] generateSymmetricKey(SymmetricEncryptMode mode) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(mode.algorithm);
        keyGen.init(128);
        SecretKey aesKey = keyGen.generateKey();
        return aesKey.getEncoded();
    }

    public static String encryptAESKey(String publicKey, byte[] aesKey, String type) {
        return EncryptUtils.publicKeyEncrypt(publicKey, type, aesKey);
    }

    private static String publicKeyEncrypt(String publicKey, String type, byte[] content) {
        if (TextUtils.isEmpty((CharSequence)publicKey)) {
            SALog.i((String)TAG, (String)"PublicKey is null.");
            return null;
        }
        try {
            Cipher cipher;
            KeyFactory keyFactory;
            byte[] keyBytes = Base64Coder.decode((String)publicKey);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            if ("EC".equals(type)) {
                keyFactory = KeyFactory.getInstance("EC", "SC");
                ECPublicKey ecPublicKey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
                cipher = Cipher.getInstance("ECIES", "SC");
                cipher.init(1, ecPublicKey);
            } else {
                keyFactory = KeyFactory.getInstance("RSA");
                PublicKey rsaPublicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
                cipher.init(1, rsaPublicKey);
            }
            int contentLen = content.length;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int offSet = 0;
            int MAX_ENCRYPT_BLOCK = 245;
            while (contentLen - offSet > 0) {
                byte[] cache = contentLen - offSet > MAX_ENCRYPT_BLOCK ? cipher.doFinal(content, offSet, MAX_ENCRYPT_BLOCK) : cipher.doFinal(content, offSet, contentLen - offSet);
                outputStream.write(cache, 0, cache.length);
                offSet += MAX_ENCRYPT_BLOCK;
            }
            byte[] encryptedData = outputStream.toByteArray();
            outputStream.close();
            return new String(Base64Coder.encode((byte[])encryptedData));
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
            return null;
        }
    }

    public static String symmetricEncrypt(byte[] key, byte[] contentBytes, SymmetricEncryptMode mode) {
        if (key == null || contentBytes == null) {
            return null;
        }
        try {
            SecureRandom random = new SecureRandom();
            byte[] ivBytes = new byte[16];
            random.nextBytes(ivBytes);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, mode.algorithm);
            Cipher cipher = Cipher.getInstance(mode.transformation);
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(ivBytes));
            byte[] encryptedBytes = cipher.doFinal(contentBytes);
            ByteBuffer byteBuffer = ByteBuffer.allocate(ivBytes.length + encryptedBytes.length);
            byteBuffer.put(ivBytes);
            byteBuffer.put(encryptedBytes);
            byte[] cipherMessage = byteBuffer.array();
            return new String(Base64Coder.encode((byte[])cipherMessage));
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
            return null;
        }
    }

    public static boolean isECEncrypt() {
        try {
            Class.forName("org.spongycastle.jce.provider.BouncyCastleProvider");
            return true;
        }
        catch (Exception e) {
            SALog.i((String)"SA.Encrypt", (String)"No integrated ECC encryption library");
            return false;
        }
    }
}

