/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util.visual;

import android.os.Build;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.SnapCache;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ViewUtil {
    private static boolean sHaveCustomRecyclerView = false;
    private static final boolean sHaveRecyclerView = ViewUtil.haveRecyclerView();
    private static Method sRecyclerViewGetChildAdapterPositionMethod;
    private static Class<?> sRecyclerViewClass;
    private static final SparseArray<String> sViewCache;

    private static boolean instanceOfSupportSwipeRefreshLayout(Object view) {
        return ReflectUtil.isInstance(view, "android.support.v4.widget.SwipeRefreshLayout", "androidx.swiperefreshlayout.widget.SwipeRefreshLayout");
    }

    private static boolean instanceOfSupportViewPager(Object view) {
        return ReflectUtil.isInstance(view, "android.support.v4.view.ViewPager");
    }

    private static boolean instanceOfAndroidXViewPager(Object view) {
        return ReflectUtil.isInstance(view, "androidx.viewpager.widget.ViewPager");
    }

    public static boolean instanceOfWebView(Object view) {
        return view instanceof WebView || ViewUtil.instanceOfX5WebView(view) || ViewUtil.instanceOfUCWebView(view);
    }

    public static boolean instanceOfX5WebView(Object view) {
        return ReflectUtil.isInstance(view, "com.tencent.smtt.sdk.WebView");
    }

    private static boolean instanceOfUCWebView(Object view) {
        return ReflectUtil.isInstance(view, "com.alipay.mobile.nebulauc.impl.UCWebView$WebViewEx");
    }

    public static boolean instanceOfRecyclerView(Object view) {
        boolean result = ReflectUtil.isInstance(view, "android.support.v7.widget.RecyclerView", "androidx.recyclerview.widget.RecyclerView");
        if (!result) {
            result = sHaveCustomRecyclerView && view != null && sRecyclerViewClass != null && sRecyclerViewClass.isAssignableFrom(view.getClass());
        }
        return result;
    }

    public static boolean instanceOfFlutterActivity(Object activity) {
        return ReflectUtil.isInstance(activity, "io.flutter.embedding.android.FlutterActivity");
    }

    public static boolean instanceOfFlutterSurfaceView(Object view) {
        return ReflectUtil.isInstance(view, "io.flutter.embedding.android.FlutterSurfaceView");
    }

    private static String getCanonicalAndCheckCustomView(Class<?> clazz) {
        String name = SnapCache.getInstance().getCanonicalName(clazz);
        if (name != null) {
            ViewUtil.checkCustomRecyclerView(clazz, name);
        }
        return name;
    }

    private static Object instanceOfFragmentRootView(View parentView, View childView) {
        Object parentFragment = SAFragmentUtils.getFragmentFromView(parentView);
        Object childFragment = SAFragmentUtils.getFragmentFromView(childView);
        if (parentFragment == null && childFragment != null) {
            return childFragment;
        }
        return null;
    }

    private static int getChildAdapterPositionInRecyclerView(View childView, ViewGroup parentView) {
        if (ViewUtil.instanceOfRecyclerView(parentView)) {
            try {
                sRecyclerViewGetChildAdapterPositionMethod = parentView.getClass().getMethod("getChildAdapterPosition", View.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (sRecyclerViewGetChildAdapterPositionMethod == null) {
                try {
                    sRecyclerViewGetChildAdapterPositionMethod = parentView.getClass().getMethod("getChildPosition", View.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            try {
                Object object;
                if (sRecyclerViewGetChildAdapterPositionMethod != null && (object = sRecyclerViewGetChildAdapterPositionMethod.invoke((Object)parentView, childView)) != null) {
                    return (Integer)object;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else if (sHaveCustomRecyclerView) {
            return ViewUtil.invokeCRVGetChildAdapterPositionMethod((View)parentView, childView);
        }
        return -1;
    }

    private static int getCurrentItem(View view) {
        try {
            Method method = view.getClass().getMethod("getCurrentItem", new Class[0]);
            Object object = method.invoke((Object)view, new Object[0]);
            if (object != null) {
                return (Integer)object;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return -1;
    }

    private static boolean haveRecyclerView() {
        try {
            Class.forName("android.support.v7.widget.RecyclerView");
            return true;
        }
        catch (ClassNotFoundException th) {
            try {
                Class.forName("androidx.recyclerview.widget.RecyclerView");
                return true;
            }
            catch (ClassNotFoundException e2) {
                return false;
            }
        }
    }

    private static void checkCustomRecyclerView(Class<?> viewClass, String viewName) {
        if (!sHaveRecyclerView && !sHaveCustomRecyclerView && viewName != null && viewName.contains("RecyclerView")) {
            try {
                if (ViewUtil.findRecyclerInSuper(viewClass) != null && sRecyclerViewGetChildAdapterPositionMethod != null) {
                    sRecyclerViewClass = viewClass;
                    sHaveCustomRecyclerView = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Class<?> findRecyclerInSuper(Class<?> viewClass) {
        while (viewClass != null && !viewClass.equals(ViewGroup.class)) {
            try {
                sRecyclerViewGetChildAdapterPositionMethod = viewClass.getMethod("getChildAdapterPosition", View.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (sRecyclerViewGetChildAdapterPositionMethod == null) {
                try {
                    sRecyclerViewGetChildAdapterPositionMethod = viewClass.getMethod("getChildPosition", View.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (sRecyclerViewGetChildAdapterPositionMethod != null) {
                return viewClass;
            }
            viewClass = viewClass.getSuperclass();
        }
        return null;
    }

    private static int invokeCRVGetChildAdapterPositionMethod(View customRecyclerView, View childView) {
        try {
            if (customRecyclerView.getClass() == sRecyclerViewClass) {
                return (Integer)sRecyclerViewGetChildAdapterPositionMethod.invoke((Object)customRecyclerView, childView);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return -1;
    }

    private static boolean isListView(View view) {
        return view instanceof AdapterView || ViewUtil.instanceOfRecyclerView(view) || ViewUtil.instanceOfAndroidXViewPager(view) || ViewUtil.instanceOfSupportViewPager(view);
    }

    public static boolean viewVisibilityInParents(View view) {
        if (view == null) {
            return false;
        }
        if (!SAViewUtils.isViewSelfVisible(view)) {
            return false;
        }
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof View) {
            if (!SAViewUtils.isViewSelfVisible((View)viewParent)) {
                return false;
            }
            if ((viewParent = viewParent.getParent()) != null) continue;
            return false;
        }
        return true;
    }

    public static void invalidateLayerTypeView(View[] views) {
        if (Build.VERSION.SDK_INT >= 11) {
            for (View view : views) {
                if (!ViewUtil.viewVisibilityInParents(view) || !view.isHardwareAccelerated()) continue;
                ViewUtil.checkAndInvalidate(view);
                if (!(view instanceof ViewGroup)) continue;
                ViewUtil.invalidateViewGroup((ViewGroup)view);
            }
        }
    }

    private static void checkAndInvalidate(View view) {
        if (Build.VERSION.SDK_INT >= 11 && view.getLayerType() != 0) {
            view.invalidate();
        }
    }

    private static void invalidateViewGroup(ViewGroup viewGroup) {
        for (int index = 0; index < viewGroup.getChildCount(); ++index) {
            View child = viewGroup.getChildAt(index);
            if (!SAViewUtils.isViewSelfVisible(child)) continue;
            ViewUtil.checkAndInvalidate(child);
            if (!(child instanceof ViewGroup)) continue;
            ViewUtil.invalidateViewGroup((ViewGroup)child);
        }
    }

    public static int getMainWindowCount(View[] windowRootViews) {
        int mainWindowCount = 0;
        WindowHelper.init();
        for (View windowRootView : windowRootViews) {
            if (windowRootView == null) continue;
            mainWindowCount += WindowHelper.getWindowPrefix(windowRootView).equals(WindowHelper.getMainWindowPrefix()) ? 1 : 0;
        }
        return mainWindowCount;
    }

    public static boolean isWindowNeedTraverse(View root, String prefix, boolean skipOtherActivity) {
        if (root.hashCode() == AppStateTools.getInstance().getCurrentRootWindowsHashCode()) {
            return true;
        }
        if (root instanceof ViewGroup) {
            if (!skipOtherActivity) {
                return true;
            }
            if (root.getWindowVisibility() != 8 && root.getVisibility() == 0 && !TextUtils.equals((CharSequence)prefix, (CharSequence)WindowHelper.getMainWindowPrefix()) && root.getWidth() != 0 && root.getHeight() != 0) {
                return true;
            }
        }
        return (root.getWindowVisibility() == 0 || root.getVisibility() == 0) && WindowHelper.isCustomWindow(root);
    }

    public static ViewNode getViewPathAndPosition(View clickView, boolean fromVisual) {
        ArrayList<Object> arrayList = new ArrayList<Object>(8);
        arrayList.add(clickView);
        ViewParent parent = clickView.getParent();
        while (parent instanceof ViewGroup) {
            arrayList.add((ViewGroup)parent);
            parent = parent.getParent();
        }
        int endIndex = arrayList.size() - 1;
        View rootView = (View)arrayList.get(endIndex);
        String listPosition = null;
        String elementContent = null;
        StringBuilder opx = new StringBuilder();
        StringBuilder px = new StringBuilder();
        if (rootView instanceof ViewGroup) {
            ViewGroup parentView = (ViewGroup)rootView;
            for (int i = endIndex - 1; i >= 0; --i) {
                int viewPosition;
                View childView = (View)arrayList.get(i);
                ViewNode viewNode = ViewUtil.getViewNode(childView, viewPosition = parentView.indexOfChild(childView), fromVisual);
                if (viewNode != null) {
                    int replacePosition;
                    if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPath()) && viewNode.getViewPath().contains("-") && !TextUtils.isEmpty(listPosition) && (replacePosition = px.indexOf("-")) != -1) {
                        px.replace(replacePosition, replacePosition + 1, String.valueOf(listPosition));
                    }
                    opx.append(viewNode.getViewOriginalPath());
                    px.append(viewNode.getViewPath());
                    listPosition = viewNode.getViewPosition();
                    elementContent = viewNode.getViewContent();
                }
                if (!(childView instanceof ViewGroup)) break;
                parentView = (ViewGroup)childView;
            }
            return new ViewNode(clickView, listPosition, opx.toString(), px.toString(), elementContent);
        }
        return null;
    }

    private static int getViewPosition(View view, int viewIndex) {
        int idx = viewIndex;
        if (view.getParent() != null && view.getParent() instanceof ViewGroup) {
            int adapterPosition;
            ViewGroup parent = (ViewGroup)view.getParent();
            if (ViewUtil.instanceOfAndroidXViewPager(parent) || ViewUtil.instanceOfSupportViewPager(parent)) {
                idx = ViewUtil.getCurrentItem((View)parent);
            } else if (parent instanceof AdapterView) {
                idx += ((AdapterView)parent).getFirstVisiblePosition();
            } else if (ViewUtil.instanceOfRecyclerView(parent) && (adapterPosition = ViewUtil.getChildAdapterPositionInRecyclerView(view, parent)) >= 0) {
                idx = adapterPosition;
            }
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewNode getViewNode(View view, int viewIndex, boolean fromVisual) {
        int viewPosition = ViewUtil.getViewPosition(view, viewIndex);
        ViewParent parentObject = view.getParent();
        if (parentObject == null) {
            return null;
        }
        if ((!WindowHelper.isDecorView(view.getClass()) || parentObject instanceof View) && parentObject instanceof View) {
            View parentView = (View)parentObject;
            StringBuilder opx = new StringBuilder();
            StringBuilder px = new StringBuilder();
            String viewName = ViewUtil.getCanonicalAndCheckCustomView(view.getClass());
            Object fragment = null;
            String listPos = null;
            boolean isListView = false;
            ViewParent parent = parentView.getParent();
            if (parent instanceof View) {
                View listParentView = (View)parent;
                SparseArray<String> sparseArray = sViewCache;
                synchronized (sparseArray) {
                    String parentPos = (String)sViewCache.get(listParentView.hashCode());
                    if (!TextUtils.isEmpty((CharSequence)parentPos)) {
                        listPos = parentPos;
                    }
                }
            }
            if (parentView instanceof ExpandableListView) {
                ExpandableListView listParent = (ExpandableListView)parentView;
                long elp = listParent.getExpandableListPosition(viewPosition);
                if (ExpandableListView.getPackedPositionType((long)elp) != 2) {
                    isListView = true;
                    int groupIdx = ExpandableListView.getPackedPositionGroup((long)elp);
                    int childIdx = ExpandableListView.getPackedPositionChild((long)elp);
                    if (childIdx != -1) {
                        listPos = String.format(TimeUtils.SDK_LOCALE, "%d:%d", groupIdx, childIdx);
                        px.append((CharSequence)opx).append("/ELVG[").append(groupIdx).append("]/ELVC[-]/").append(viewName).append("[0]");
                        opx.append("/ELVG[").append(groupIdx).append("]/ELVC[").append(childIdx).append("]/").append(viewName).append("[0]");
                    } else {
                        listPos = String.format(TimeUtils.SDK_LOCALE, "%d", groupIdx);
                        px.append((CharSequence)opx).append("/ELVG[-]/").append(viewName).append("[0]");
                        opx.append("/ELVG[").append(groupIdx).append("]/").append(viewName).append("[0]");
                    }
                } else if (viewPosition < listParent.getHeaderViewsCount()) {
                    opx.append("/ELH[").append(viewPosition).append("]/").append(viewName).append("[0]");
                    px.append("/ELH[").append(viewPosition).append("]/").append(viewName).append("[0]");
                } else {
                    int footerIndex = viewPosition - (listParent.getCount() - listParent.getFooterViewsCount());
                    opx.append("/ELF[").append(footerIndex).append("]/").append(viewName).append("[0]");
                    px.append("/ELF[").append(footerIndex).append("]/").append(viewName).append("[0]");
                }
            } else if (ViewUtil.isListView(parentView)) {
                isListView = true;
                listPos = String.format(TimeUtils.SDK_LOCALE, "%d", viewPosition);
                px.append((CharSequence)opx).append("/").append(viewName).append("[-]");
                opx.append("/").append(viewName).append("[").append(listPos).append("]");
            } else if (ViewUtil.instanceOfSupportSwipeRefreshLayout(parentView)) {
                opx.append("/").append(viewName).append("[0]");
                px.append("/").append(viewName).append("[0]");
            } else {
                fragment = ViewUtil.instanceOfFragmentRootView(parentView, view);
                if (fragment != null) {
                    viewName = ViewUtil.getCanonicalAndCheckCustomView(fragment.getClass());
                    opx.append("/").append(viewName).append("[0]");
                    px.append("/").append(viewName).append("[0]");
                } else {
                    viewPosition = SAViewUtils.getChildIndex(parentObject, view);
                    opx.append("/").append(viewName).append("[").append(viewPosition).append("]");
                    px.append("/").append(viewName).append("[").append(viewPosition).append("]");
                }
            }
            if (WindowHelper.isDecorView(parentView.getClass())) {
                if (opx.length() > 0) {
                    opx.deleteCharAt(0);
                }
                if (px.length() > 0) {
                    px.deleteCharAt(0);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)listPos)) {
                SparseArray<String> sparseArray = sViewCache;
                synchronized (sparseArray) {
                    sViewCache.put(parentView.hashCode(), (Object)listPos);
                }
            }
            return new ViewNode(view, listPos, opx.toString(), px.toString(), SAViewUtils.getViewContent(view, fromVisual), SAViewUtils.getViewType(view), isListView);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        SparseArray<String> sparseArray = sViewCache;
        synchronized (sparseArray) {
            sViewCache.clear();
        }
    }

    static {
        sViewCache = new SparseArray();
    }
}

