/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import com.sensorsdata.analytics.android.sdk.SALog;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadUtils {
    private static final String TAG = "SA.ThreadUtils";
    private static final Map<Integer, Map<Integer, ExecutorService>> TYPE_PRIORITY_POOLS = new HashMap<Integer, Map<Integer, ExecutorService>>();
    private static final byte TYPE_SINGLE = -1;

    public static ExecutorService getSinglePool() {
        return ThreadUtils.getPoolByTypeAndPriority(-1);
    }

    public static ExecutorService getSinglePool(int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-1, priority);
    }

    private static ExecutorService getPoolByTypeAndPriority(int type) {
        return ThreadUtils.getPoolByTypeAndPriority(type, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getPoolByTypeAndPriority(int type, int priority) {
        Map<Integer, Map<Integer, ExecutorService>> map = TYPE_PRIORITY_POOLS;
        synchronized (map) {
            ExecutorService pool;
            Map<Integer, ExecutorService> priorityPools = TYPE_PRIORITY_POOLS.get(type);
            if (priorityPools == null) {
                priorityPools = new ConcurrentHashMap<Integer, ExecutorService>();
                pool = ThreadPoolExecutorUtil.createPool(type, priority);
                priorityPools.put(priority, pool);
                TYPE_PRIORITY_POOLS.put(type, priorityPools);
            } else {
                pool = priorityPools.get(priority);
                if (pool == null) {
                    pool = ThreadPoolExecutorUtil.createPool(type, priority);
                    priorityPools.put(priority, pool);
                }
            }
            return pool;
        }
    }

    static final class UtilsThreadFactory
    extends AtomicLong
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;
        private final boolean isDaemon;

        UtilsThreadFactory(String prefix, int priority) {
            this(prefix, priority, false);
        }

        UtilsThreadFactory(String prefix, int priority, boolean isDaemon) {
            this.namePrefix = prefix + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
            this.isDaemon = isDaemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.getAndIncrement()){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable t) {
                        SALog.i("ThreadUtils", "Request threw uncaught throwable");
                    }
                }
            };
            t.setDaemon(this.isDaemon);
            t.setPriority(this.priority);
            return t;
        }
    }

    private static final class LinkedBlockingQueueUtil
    extends LinkedBlockingQueue<Runnable> {
        private volatile ThreadPoolExecutorUtil mPool;
        private int mCapacity = Integer.MAX_VALUE;

        LinkedBlockingQueueUtil() {
        }

        LinkedBlockingQueueUtil(boolean isAddSubThreadFirstThenAddQueue) {
            if (isAddSubThreadFirstThenAddQueue) {
                this.mCapacity = 0;
            }
        }

        LinkedBlockingQueueUtil(int capacity) {
            this.mCapacity = capacity;
        }

        @Override
        public boolean offer(Runnable runnable) {
            if (this.mCapacity <= this.size() && this.mPool != null && this.mPool.getPoolSize() < this.mPool.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(runnable);
        }
    }

    static final class ThreadPoolExecutorUtil
    extends ThreadPoolExecutor {
        private final AtomicInteger mSubmittedCount = new AtomicInteger();
        private LinkedBlockingQueueUtil mWorkQueue;

        private static ExecutorService createPool(int type, int priority) {
            switch (type) {
                case -1: {
                    return new ThreadPoolExecutorUtil(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueueUtil(), (ThreadFactory)new UtilsThreadFactory("single", priority));
                }
            }
            return new ThreadPoolExecutorUtil(type, type, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueueUtil(), (ThreadFactory)new UtilsThreadFactory("fixed(" + type + ")", priority));
        }

        ThreadPoolExecutorUtil(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, LinkedBlockingQueueUtil workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)workQueue, threadFactory);
            workQueue.mPool = this;
            this.mWorkQueue = workQueue;
        }

        private int getSubmittedCount() {
            return this.mSubmittedCount.get();
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.mSubmittedCount.decrementAndGet();
            super.afterExecute(r, t);
        }

        @Override
        public void execute(Runnable command) {
            if (this.isShutdown()) {
                return;
            }
            this.mSubmittedCount.incrementAndGet();
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException ignore) {
                SALog.i(ThreadUtils.TAG, "This will not happen!");
                this.mWorkQueue.offer(command);
            }
            catch (Throwable t) {
                this.mSubmittedCount.decrementAndGet();
            }
        }
    }
}

