/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.ScreenAutoTracker;
import com.sensorsdata.analytics.android.sdk.SensorsDataFragmentTitle;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import org.json.JSONObject;

public class SAPageInfoUtils {
    public static final String SCREEN_NAME = "$screen_name";
    public static final String TITLE = "$title";

    public static JSONObject getFragmentPageInfo(Activity activity, Object fragment) {
        JSONObject properties = new JSONObject();
        try {
            SensorsDataFragmentTitle sensorsDataFragmentTitle;
            ScreenAutoTracker screenAutoTracker;
            JSONObject trackProperties;
            String screenName = null;
            String title = null;
            if (fragment instanceof ScreenAutoTracker && (trackProperties = (screenAutoTracker = (ScreenAutoTracker)fragment).getTrackProperties()) != null) {
                if (trackProperties.has(SCREEN_NAME)) {
                    screenName = trackProperties.optString(SCREEN_NAME);
                }
                if (trackProperties.has(TITLE)) {
                    title = trackProperties.optString(TITLE);
                }
                JSONUtils.mergeJSONObject(trackProperties, properties);
            }
            boolean isTitleNull = TextUtils.isEmpty(title);
            boolean isScreenNameNull = TextUtils.isEmpty(screenName);
            if (isTitleNull && fragment.getClass().isAnnotationPresent(SensorsDataFragmentTitle.class) && (sensorsDataFragmentTitle = fragment.getClass().getAnnotation(SensorsDataFragmentTitle.class)) != null) {
                title = sensorsDataFragmentTitle.title();
            }
            if ((isTitleNull = TextUtils.isEmpty(title)) || isScreenNameNull) {
                if (activity == null) {
                    activity = SAFragmentUtils.getActivityFromFragment(fragment);
                }
                if (activity != null) {
                    if (isTitleNull) {
                        title = SensorsDataUtils.getActivityTitle(activity);
                    }
                    if (isScreenNameNull) {
                        screenName = fragment.getClass().getCanonicalName();
                        screenName = String.format(TimeUtils.SDK_LOCALE, "%s|%s", activity.getClass().getCanonicalName(), screenName);
                    }
                }
            }
            if (!TextUtils.isEmpty(title)) {
                properties.put(TITLE, (Object)title);
            }
            if (TextUtils.isEmpty((CharSequence)screenName)) {
                screenName = fragment.getClass().getCanonicalName();
            }
            properties.put(SCREEN_NAME, (Object)screenName);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return properties;
    }

    public static JSONObject getActivityPageInfo(Activity activity) {
        JSONObject propertyJSON = new JSONObject();
        try {
            propertyJSON.put(SCREEN_NAME, (Object)activity.getClass().getCanonicalName());
            String activityTitle = SensorsDataUtils.getActivityTitle(activity);
            if (!TextUtils.isEmpty((CharSequence)activityTitle)) {
                propertyJSON.put(TITLE, (Object)activityTitle);
            }
            if (activity instanceof ScreenAutoTracker) {
                ScreenAutoTracker screenAutoTracker = (ScreenAutoTracker)activity;
                JSONUtils.mergeJSONObject(screenAutoTracker.getTrackProperties(), propertyJSON);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return new JSONObject();
        }
        return propertyJSON;
    }

    public static JSONObject getRNPageInfo() {
        return SAPageInfoUtils.getRNPageInfo(null);
    }

    public static JSONObject getRNPageInfo(View view) {
        try {
            Class<?> rnViewUtils = ReflectUtil.getCurrentClass(new String[]{"com.sensorsdata.analytics.utils.RNViewUtils"});
            String properties = (String)ReflectUtil.callStaticMethod(rnViewUtils, "getVisualizeProperties", new Object[0]);
            if (!TextUtils.isEmpty((CharSequence)properties)) {
                Object isRNView;
                JSONObject object = new JSONObject(properties);
                if (view != null && object.optBoolean("isSetRNViewTag", false) && ((isRNView = view.getTag(R.id.sensors_analytics_tag_view_rn_key)) == null || !((Boolean)isRNView).booleanValue())) {
                    return null;
                }
                String rnScreenName = object.optString(SCREEN_NAME);
                String rnActivityTitle = object.optString(TITLE);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(SCREEN_NAME, (Object)rnScreenName);
                jsonObject.put(TITLE, (Object)rnActivityTitle);
                return jsonObject;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }
}

