/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.content.Context;
import android.os.Build;
import com.sensorsdata.analytics.android.sdk.SALog;
import java.util.HashSet;
import java.util.Set;

public class PermissionUtils {
    private static final String TAG = "SA.PermissionUtils";
    private static final Set<String> mPermissionGrantedSet = new HashSet<String>();
    private static final Set<String> mPermissionGrantedOnceSet = new HashSet<String>(){
        {
            this.add("android.permission.ACCESS_WIFI_STATE");
            this.add("android.permission.ACCESS_NETWORK_STATE");
        }
    };

    public static boolean checkSelfPermission(Context context, String permission2) {
        if (Build.VERSION.SDK_INT >= 23) {
            boolean isGranted;
            if (mPermissionGrantedSet.contains(permission2)) {
                return true;
            }
            boolean bl = isGranted = context.checkSelfPermission(permission2) == 0;
            if (isGranted && mPermissionGrantedOnceSet.contains(permission2)) {
                mPermissionGrantedSet.add(permission2);
            }
            return isGranted;
        }
        try {
            boolean isGranted;
            boolean bl = isGranted = context.getPackageManager().checkPermission(permission2, context.getPackageName()) == 0;
            if (isGranted) {
                mPermissionGrantedSet.add(permission2);
            }
            return isGranted;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    public static boolean hasReadPhoneStatePermission(Context context) {
        if (Build.VERSION.SDK_INT > 28) {
            if (!PermissionUtils.checkSelfPermission(context, "android.permission.READ_PRECISE_PHONE_STATE")) {
                SALog.i(TAG, "Don't have permission android.permission.READ_PRECISE_PHONE_STATE,getDeviceID failed");
                return false;
            }
        } else if (!PermissionUtils.checkSelfPermission(context, "android.permission.READ_PHONE_STATE")) {
            SALog.i(TAG, "Don't have permission android.permission.READ_PHONE_STATE,getDeviceID failed");
            return false;
        }
        return true;
    }
}

