/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.sensorsdata.analytics.android.sdk.SALog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class DeviceUtils {
    public static String getOS() {
        return Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE;
    }

    public static String getManufacturer() {
        try {
            String manufacturer = Build.MANUFACTURER;
            if (manufacturer != null) {
                return manufacturer.trim().toUpperCase();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return "UNKNOWN";
    }

    public static String getBrand() {
        try {
            String brand = Build.BRAND;
            if (brand != null) {
                return brand.trim().toUpperCase();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return "UNKNOWN";
    }

    public static String getModel() {
        return TextUtils.isEmpty((CharSequence)Build.MODEL) ? "UNKNOWN" : Build.MODEL.trim();
    }

    public static int[] getDeviceSize(Context context) {
        int[] size;
        block6: {
            size = new int[2];
            try {
                int screenHeight;
                int screenWidth;
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                int rotation = display.getRotation();
                Point point = new Point();
                if (Build.VERSION.SDK_INT >= 17) {
                    display.getRealSize(point);
                    screenWidth = point.x;
                    screenHeight = point.y;
                } else if (Build.VERSION.SDK_INT >= 13) {
                    display.getSize(point);
                    screenWidth = point.x;
                    screenHeight = point.y;
                } else {
                    screenWidth = display.getWidth();
                    screenHeight = display.getHeight();
                }
                size[0] = DeviceUtils.getNaturalWidth(rotation, screenWidth, screenHeight);
                size[1] = DeviceUtils.getNaturalHeight(rotation, screenWidth, screenHeight);
            }
            catch (Exception e) {
                if (context.getResources() == null) break block6;
                DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
                size[0] = displayMetrics.widthPixels;
                size[1] = displayMetrics.heightPixels;
            }
        }
        return size;
    }

    private static int getNaturalWidth(int rotation, int width, int height) {
        return rotation == 0 || rotation == 2 ? width : height;
    }

    private static int getNaturalHeight(int rotation, int width, int height) {
        return rotation == 0 || rotation == 2 ? height : width;
    }

    public static String getHarmonyOSVersion() {
        String version = null;
        if (DeviceUtils.isHarmonyOs() && TextUtils.isEmpty((CharSequence)(version = DeviceUtils.getProp("hw_sc.build.platform.version", "")))) {
            version = DeviceUtils.exec("getprop hw_sc.build.platform.version");
        }
        return version;
    }

    private static boolean isHarmonyOs() {
        try {
            Class<?> buildExClass = Class.forName("com.huawei.system.BuildEx");
            Object osBrand = buildExClass.getMethod("getOsBrand", new Class[0]).invoke(buildExClass, new Object[0]);
            if (osBrand == null) {
                return false;
            }
            return "harmony".equalsIgnoreCase(osBrand.toString());
        }
        catch (Throwable e) {
            SALog.i("SA.HasHarmonyOS", e.getMessage());
            return false;
        }
    }

    private static String getProp(String property, String defaultValue) {
        try {
            Class<?> spClz = Class.forName("android.os.SystemProperties");
            Method method = spClz.getDeclaredMethod("get", String.class);
            String value = (String)method.invoke(spClz, property);
            if (TextUtils.isEmpty((CharSequence)value)) {
                return defaultValue;
            }
            return value;
        }
        catch (Throwable throwable) {
            SALog.i("SA.SystemProperties", throwable.getMessage());
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exec(String command) {
        InputStreamReader ir = null;
        BufferedReader input = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            ir = new InputStreamReader(process.getInputStream());
            input = new BufferedReader(ir);
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = input.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (Throwable e) {
            SALog.i("SA.Exec", e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable e) {
                    SALog.i("SA.Exec", e.getMessage());
                }
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException e) {
                    SALog.i("SA.Exec", e.getMessage());
                }
            }
        }
        return null;
    }
}

