/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AppStateTools
implements SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks {
    private static final String TAG = "AppStateTools";
    private WeakReference<Activity> mForeGroundActivity = new WeakReference<Object>(null);
    private String mCurrentFragmentName = null;
    private int mCurrentRootWindowsHashCode = -1;
    private int mActivityCount = 0;
    private final List<AppState> mAppStateList = new ArrayList<AppState>();

    public static AppStateTools getInstance() {
        return SingleHolder.mSingleInstance;
    }

    @Override
    public void onNewIntent(Intent intent) {
    }

    private AppStateTools() {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        try {
            this.setForegroundActivity(activity);
            if (!activity.isChild()) {
                this.mCurrentRootWindowsHashCode = -1;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        try {
            if (!SensorsDataDialogUtils.isSchemeActivity((Context)activity)) {
                SensorsDataUtils.handleSchemeUrl(activity, activity.getIntent());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.mActivityCount++ == 0) {
            for (AppState appState : this.mAppStateList) {
                try {
                    appState.onForeground();
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        this.setForegroundActivity(activity);
        View decorView = null;
        try {
            Window window = activity.getWindow();
            if (window != null) {
                decorView = window.getDecorView();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        if (!activity.isChild() && decorView != null) {
            this.mCurrentRootWindowsHashCode = decorView.hashCode();
        }
    }

    public void onActivityPaused(Activity activity) {
        if (!activity.isChild()) {
            this.mCurrentRootWindowsHashCode = -1;
        }
    }

    public void onActivityStopped(Activity activity) {
        --this.mActivityCount;
        if (this.mActivityCount == 0) {
            for (AppState appState : this.mAppStateList) {
                try {
                    appState.onBackground();
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void delayInit(Context context) {
        try {
            if (context instanceof Activity) {
                this.onActivityStarted((Activity)context);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public Activity getForegroundActivity() {
        return (Activity)this.mForeGroundActivity.get();
    }

    private void setForegroundActivity(Activity activity) {
        this.mForeGroundActivity = new WeakReference<Activity>(activity);
    }

    public void setFragmentScreenName(Object fragment, String fragmentScreenName) {
        try {
            Method getParentFragmentMethod = fragment.getClass().getMethod("getParentFragment", new Class[0]);
            Object parentFragment = getParentFragmentMethod.invoke(fragment, new Object[0]);
            if (parentFragment == null) {
                this.mCurrentFragmentName = fragmentScreenName;
                SALog.i(TAG, "setFragmentScreenName | " + fragmentScreenName + " is not nested fragment and set");
            } else {
                SALog.i(TAG, "setFragmentScreenName | " + fragmentScreenName + " is nested fragment and ignored");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addAppStateListener(AppState appState) {
        this.mAppStateList.add(appState);
    }

    public boolean isAppOnForeground() {
        return this.mActivityCount != 0;
    }

    public String getFragmentScreenName() {
        return this.mCurrentFragmentName;
    }

    public int getCurrentRootWindowsHashCode() {
        Window window;
        Activity activity;
        if (this.mCurrentRootWindowsHashCode == -1 && this.mForeGroundActivity != null && this.mForeGroundActivity.get() != null && (activity = (Activity)this.mForeGroundActivity.get()) != null && (window = activity.getWindow()) != null && window.isActive()) {
            this.mCurrentRootWindowsHashCode = window.getDecorView().hashCode();
        }
        return this.mCurrentRootWindowsHashCode;
    }

    public static interface AppState {
        public void onForeground();

        public void onBackground();
    }

    private static class SingleHolder {
        private static final AppStateTools mSingleInstance = new AppStateTools();

        private SingleHolder() {
        }
    }
}

