/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;

public class AppInfoUtils {
    private static String mAppVersionName;
    private static Bundle mConfigBundle;

    public static CharSequence getAppName(Context context) {
        if (context == null) {
            return "";
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            return appInfo.loadLabel(packageManager);
        }
        catch (Throwable e) {
            SALog.i("SA.AppInfoUtils", e.getMessage());
            return "";
        }
    }

    public static String getProcessName(Context context) {
        if (context == null) {
            return "";
        }
        try {
            return context.getApplicationInfo().processName;
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return "";
        }
    }

    public static String getAppVersionName(Context context) {
        if (context == null) {
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)mAppVersionName)) {
            return mAppVersionName;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            mAppVersionName = packageInfo.versionName;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return mAppVersionName;
    }

    public static String getMainProcessName(Context context) {
        if (context == null) {
            return "";
        }
        try {
            return context.getApplicationContext().getApplicationInfo().processName;
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return "";
        }
    }

    public static boolean isMainProcess(Context context, Bundle bundle) {
        if (context == null) {
            return false;
        }
        String mainProcessName = AppInfoUtils.getMainProcessName(context);
        if (TextUtils.isEmpty((CharSequence)mainProcessName) && bundle != null) {
            mainProcessName = bundle.getString("com.sensorsdata.analytics.android.MainProcessName");
        }
        if (TextUtils.isEmpty((CharSequence)mainProcessName)) {
            return true;
        }
        String currentProcess = AppInfoUtils.getCurrentProcessName();
        return TextUtils.isEmpty((CharSequence)currentProcess) || mainProcessName.equals(currentProcess);
    }

    public static boolean isTaskExecuteThread() {
        return TextUtils.equals((CharSequence)"SA.TaskExecuteThread", (CharSequence)Thread.currentThread().getName());
    }

    public static Bundle getAppInfoBundle(Context context) {
        if (mConfigBundle == null) {
            try {
                ApplicationInfo appInfo = context.getApplicationContext().getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                if (appInfo != null) {
                    mConfigBundle = appInfo.metaData;
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
        if (mConfigBundle == null) {
            return new Bundle();
        }
        return mConfigBundle;
    }

    private static String getCurrentProcessName() {
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                return Application.getProcessName();
            }
            String currentProcess = AppInfoUtils.getCurrentProcessNameByCmd();
            if (TextUtils.isEmpty((CharSequence)currentProcess)) {
                currentProcess = AppInfoUtils.getCurrentProcessNameByAT();
            }
            return currentProcess;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    private static String getCurrentProcessNameByAT() {
        String processName = null;
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader());
            Method declaredMethod = activityThread.getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object processInvoke = declaredMethod.invoke(null, new Object[0]);
            if (processInvoke instanceof String) {
                processName = (String)processInvoke;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentProcessNameByCmd() {
        FileInputStream in = null;
        try {
            int b;
            String fn = "/proc/self/cmdline";
            in = new FileInputStream(fn);
            byte[] buffer = new byte[256];
            int len = 0;
            while ((b = in.read()) > 0 && len < buffer.length) {
                buffer[len++] = (byte)b;
            }
            if (len > 0) {
                String string2 = new String(buffer, 0, len, "UTF-8");
                return string2;
            }
        }
        catch (Throwable e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    SALog.printStackTrace(e);
                }
            }
        }
        return null;
    }
}

