/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.plugin.property.impl;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataGPSLocation;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertiesFetcher;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertyFilter;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;

public class RealTimePropertyPlugin
extends SAPropertyPlugin {
    SAContextManager mContextManager;
    Context mContext;

    public RealTimePropertyPlugin(SAContextManager saContextManager) {
        this.mContext = saContextManager.getContext();
        this.mContextManager = saContextManager;
    }

    @Override
    public boolean isMatchedWithFilter(SAPropertyFilter filter) {
        return filter.getType().isTrack() && "Android".equals(filter.getEventJson("lib").optString("$lib"));
    }

    @Override
    public void properties(SAPropertiesFetcher fetcher) {
        try {
            String networkType = NetworkUtils.networkType(this.mContext);
            fetcher.getProperties().put("$wifi", "WIFI".equals(networkType));
            fetcher.getProperties().put("$network_type", (Object)networkType);
            SensorsDataGPSLocation location = this.mContextManager.getInternalConfigs().gpsLocation;
            if (location != null) {
                location.toJSON(fetcher.getProperties());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        try {
            String screenOrientation = SensorsDataAPI.sharedInstance().getScreenOrientation();
            if (!TextUtils.isEmpty((CharSequence)screenOrientation)) {
                fetcher.getProperties().put("$screen_orientation", (Object)screenOrientation);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }
}

