/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.plugin.encrypt;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.LruCache;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.DefaultStorePlugin;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.StorePlugin;
import com.sensorsdata.analytics.android.sdk.util.SASpUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractStoreManager {
    private final List<StorePlugin> mStorePluginList = new ArrayList<StorePlugin>();
    private final Set<String> mStoreTypes;
    private final LruCacheData mLruCacheSPData = new LruCacheData(10);
    private StorePlugin mMaxPriorityPlugin;
    private String mMaxPluginType;
    private final Lock mLock = new ReentrantLock(true);
    protected boolean mDefaultState = true;
    private static final String TAG = "SA.AbstractStoreManager";

    protected AbstractStoreManager() {
        this.mStoreTypes = new HashSet<String>();
    }

    public void registerPlugin(StorePlugin plugin) {
        if (plugin == null) {
            return;
        }
        String pluginType = plugin.type();
        if (TextUtils.isEmpty((CharSequence)pluginType)) {
            SALog.i(TAG, "PluginType is null");
            return;
        }
        if (!this.mStoreTypes.contains(pluginType)) {
            this.mStoreTypes.add(pluginType);
        } else {
            for (StorePlugin storePlugin : this.mStorePluginList) {
                if (!TextUtils.equals((CharSequence)pluginType, (CharSequence)storePlugin.type())) continue;
                this.mStorePluginList.remove(storePlugin);
                break;
            }
        }
        this.mStorePluginList.add(0, plugin);
        this.mMaxPriorityPlugin = plugin;
        this.mMaxPluginType = plugin.type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String key, String value) {
        this.mLock.lock();
        try {
            if (this.mDefaultState) {
                this.storeKeys(key, value, "String");
                return;
            }
            if (value == null) {
                for (StorePlugin plugin : this.mStorePluginList) {
                    plugin.remove(plugin.type() + key);
                }
                this.mLruCacheSPData.remove(key);
            } else {
                this.removeUselessValue(key);
                this.mMaxPriorityPlugin.setString(this.mMaxPluginType + key, value);
                this.mLruCacheSPData.put(key, value);
            }
        }
        catch (Exception e) {
            SALog.i(TAG, "save data failed,key = " + key + "value = " + value, e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBool(String key, boolean value) {
        this.mLock.lock();
        try {
            if (this.mDefaultState) {
                this.storeKeys(key, value, "Bool");
                return;
            }
            this.removeUselessValue(key);
            this.mMaxPriorityPlugin.setBool(this.mMaxPluginType + key, value);
            this.mLruCacheSPData.put(key, value);
        }
        catch (Exception e) {
            SALog.i(TAG, "save data failed,key = " + key + "value = " + value, e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInteger(String key, int value) {
        this.mLock.lock();
        try {
            if (this.mDefaultState) {
                this.storeKeys(key, value, "Integer");
                return;
            }
            this.removeUselessValue(key);
            this.mMaxPriorityPlugin.setInteger(this.mMaxPluginType + key, value);
            this.mLruCacheSPData.put(key, value);
        }
        catch (Exception e) {
            SALog.i(TAG, "save data failed,key = " + key + "value = " + value, e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(String key, float value) {
        this.mLock.lock();
        try {
            if (this.mDefaultState) {
                this.storeKeys(key, Float.valueOf(value), "Float");
                return;
            }
            this.removeUselessValue(key);
            this.mMaxPriorityPlugin.setFloat(this.mMaxPluginType + key, value);
            this.mLruCacheSPData.put(key, Float.valueOf(value));
        }
        catch (Exception e) {
            SALog.i(TAG, "save data failed,key = " + key + "value = " + value, e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(String key, long value) {
        this.mLock.lock();
        try {
            if (this.mDefaultState) {
                this.storeKeys(key, value, "Long");
                return;
            }
            this.removeUselessValue(key);
            this.mMaxPriorityPlugin.setLong(this.mMaxPluginType + key, value);
            this.mLruCacheSPData.put(key, value);
        }
        catch (Exception e) {
            SALog.i(TAG, "save data failed,key = " + key + "value = " + value, e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defaultValue) {
        this.mLock.lock();
        try {
            String value = (String)this.mLruCacheSPData.get(key);
            if (value != null) {
                String string2 = value;
                return string2;
            }
            if (this.mDefaultState) {
                String string3 = this.getValue(key, "String", defaultValue);
                return string3;
            }
            for (StorePlugin plugin : this.mStorePluginList) {
                value = plugin.getString(plugin.type() + key);
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                if (plugin != this.mMaxPriorityPlugin) {
                    plugin.remove(plugin.type() + key);
                    this.mMaxPriorityPlugin.setString(this.mMaxPluginType + key, value);
                }
                this.mLruCacheSPData.put(key, value);
                break;
            }
            String string4 = value == null ? defaultValue : value;
            return string4;
        }
        catch (Exception e) {
            SALog.i(TAG, "get data failed,key = " + key, e);
        }
        finally {
            this.mLock.unlock();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBool(String key, boolean defaultValue) {
        this.mLock.lock();
        try {
            Boolean value = (Boolean)this.mLruCacheSPData.get(key);
            if (value != null) {
                boolean bl = value;
                return bl;
            }
            if (this.mDefaultState) {
                boolean bl = this.getValue(key, "Bool", defaultValue);
                return bl;
            }
            for (StorePlugin plugin : this.mStorePluginList) {
                value = plugin.getBool(plugin.type() + key);
                if (value == null) continue;
                if (plugin != this.mMaxPriorityPlugin) {
                    plugin.remove(plugin.type() + key);
                    this.mMaxPriorityPlugin.setBool(this.mMaxPluginType + key, value);
                }
                this.mLruCacheSPData.put(key, value);
                break;
            }
            boolean bl = value == null ? defaultValue : value;
            return bl;
        }
        catch (Exception e) {
            SALog.i(TAG, "get data failed,key = " + key, e);
        }
        finally {
            this.mLock.unlock();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInteger(String key, int defaultValue) {
        this.mLock.lock();
        try {
            Integer value = (Integer)this.mLruCacheSPData.get(key);
            if (value != null) {
                int n = value;
                return n;
            }
            if (this.mDefaultState) {
                int n = this.getValue(key, "Integer", defaultValue);
                return n;
            }
            for (StorePlugin plugin : this.mStorePluginList) {
                value = plugin.getInteger(plugin.type() + key);
                if (value == null) continue;
                if (plugin != this.mMaxPriorityPlugin) {
                    plugin.remove(plugin.type() + key);
                    this.mMaxPriorityPlugin.setInteger(this.mMaxPluginType + key, value);
                }
                this.mLruCacheSPData.put(key, value);
                break;
            }
            int n = value == null ? defaultValue : value;
            return n;
        }
        catch (Exception e) {
            SALog.i(TAG, "get data failed,key = " + key, e);
        }
        finally {
            this.mLock.unlock();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defaultValue) {
        this.mLock.lock();
        try {
            Float value = (Float)this.mLruCacheSPData.get(key);
            if (value != null) {
                float f = value.floatValue();
                return f;
            }
            if (this.mDefaultState) {
                float f = this.getValue(key, "Float", Float.valueOf(defaultValue)).floatValue();
                return f;
            }
            for (StorePlugin plugin : this.mStorePluginList) {
                value = plugin.getFloat(plugin.type() + key);
                if (value == null) continue;
                if (plugin != this.mMaxPriorityPlugin) {
                    plugin.remove(plugin.type() + key);
                    this.mMaxPriorityPlugin.setFloat(this.mMaxPluginType + key, value.floatValue());
                }
                this.mLruCacheSPData.put(key, value);
                break;
            }
            float f = value == null ? defaultValue : value.floatValue();
            return f;
        }
        catch (Exception e) {
            SALog.i(TAG, "get data failed,key = " + key, e);
        }
        finally {
            this.mLock.unlock();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLong(String key, long defaultValue) {
        this.mLock.lock();
        try {
            Long value = (Long)this.mLruCacheSPData.get(key);
            if (value != null) {
                Long l = value;
                return l;
            }
            if (this.mDefaultState) {
                Long l = this.getValue(key, "Long", defaultValue);
                return l;
            }
            for (StorePlugin plugin : this.mStorePluginList) {
                value = plugin.getLong(plugin.type() + key);
                if (value == null) continue;
                if (plugin != this.mMaxPriorityPlugin) {
                    plugin.remove(plugin.type() + key);
                    this.mMaxPriorityPlugin.setLong(this.mMaxPluginType + key, value);
                }
                this.mLruCacheSPData.put(key, value);
                break;
            }
            Long l = value == null ? defaultValue : value;
            return l;
        }
        catch (Exception e) {
            SALog.i(TAG, "get data failed,key = " + key, e);
        }
        finally {
            this.mLock.unlock();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        this.mLock.lock();
        try {
            if (this.mDefaultState) {
                StorePlugin tempPlugin = this.mMaxPriorityPlugin;
                for (StorePlugin plugin : this.mStorePluginList) {
                    if (!(plugin instanceof DefaultStorePlugin) || ((DefaultStorePlugin)plugin).storeKeys() == null || !((DefaultStorePlugin)plugin).storeKeys().contains(key)) continue;
                    tempPlugin = plugin;
                    break;
                }
                tempPlugin.remove(tempPlugin.type() + key);
            } else {
                for (StorePlugin plugin : this.mStorePluginList) {
                    plugin.remove(plugin.type() + key);
                }
            }
            this.mLruCacheSPData.remove(key);
        }
        catch (Exception e) {
            SALog.i(TAG, "remove failed,key = " + key, e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() {
        this.mLock.lock();
        try {
            int size = this.mStorePluginList.size();
            for (int i = size - 1; i >= 0; --i) {
                StorePlugin storePlugin = this.mStorePluginList.get(i);
                StorePlugin previousPlugin = null;
                int previousIndex = i - 1;
                if (previousIndex >= 0) {
                    previousPlugin = this.mStorePluginList.get(previousIndex);
                }
                if (previousPlugin == null) continue;
                previousPlugin.upgrade(storePlugin);
            }
        }
        catch (Exception e) {
            SALog.i(TAG, "upgrade failed", e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExists(String key) {
        this.mLock.lock();
        try {
            if (TextUtils.isEmpty((CharSequence)key)) {
                boolean bl = false;
                return bl;
            }
            for (StorePlugin plugin : this.mStorePluginList) {
                if (!plugin.isExists(plugin.type() + key)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            SALog.i(TAG, "isExists failed,key = " + key, e);
        }
        finally {
            this.mLock.unlock();
        }
        return false;
    }

    protected boolean isRegisterPlugin(Context context, String name) {
        try {
            File SPFile = new File("data/data/" + context.getPackageName() + "/shared_prefs", name + ".xml");
            if (!SPFile.exists()) {
                return false;
            }
            SharedPreferences storeSp = SASpUtils.getSharedPreferences(context, name, 0);
            Map stringMap = storeSp.getAll();
            if (stringMap.size() == 0) {
                SALog.i(TAG, "delete sp: " + name);
                return !SPFile.delete();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return true;
    }

    private void removeUselessValue(String key) {
        for (StorePlugin plugin : this.mStorePluginList) {
            if (plugin == this.mMaxPriorityPlugin) continue;
            plugin.remove(plugin.type() + key);
        }
    }

    private void storeKeys(String key, Object value, String type) {
        StorePlugin tempPlugin = this.mMaxPriorityPlugin;
        for (StorePlugin plugin : this.mStorePluginList) {
            if (!(plugin instanceof DefaultStorePlugin) || ((DefaultStorePlugin)plugin).storeKeys() == null || !((DefaultStorePlugin)plugin).storeKeys().contains(key)) continue;
            tempPlugin = plugin;
            break;
        }
        switch (type) {
            case "String": {
                tempPlugin.setString(tempPlugin.type() + key, (String)value);
                break;
            }
            case "Integer": {
                tempPlugin.setInteger(tempPlugin.type() + key, (Integer)value);
                break;
            }
            case "Float": {
                tempPlugin.setFloat(tempPlugin.type() + key, ((Float)value).floatValue());
                break;
            }
            case "Long": {
                tempPlugin.setLong(tempPlugin.type() + key, (Long)value);
                break;
            }
            case "Bool": {
                tempPlugin.setBool(tempPlugin.type() + key, (Boolean)value);
            }
        }
    }

    private <T> T getValue(String key, String type, T defaultValue) {
        StorePlugin tempPlugin = this.mMaxPriorityPlugin;
        for (StorePlugin plugin : this.mStorePluginList) {
            if (!(plugin instanceof DefaultStorePlugin) || ((DefaultStorePlugin)plugin).storeKeys() == null || !((DefaultStorePlugin)plugin).storeKeys().contains(key)) continue;
            tempPlugin = plugin;
            break;
        }
        Object value = null;
        switch (type) {
            case "String": {
                value = tempPlugin.getString(tempPlugin.type() + key);
                break;
            }
            case "Integer": {
                value = tempPlugin.getInteger(tempPlugin.type() + key);
                break;
            }
            case "Float": {
                value = tempPlugin.getFloat(tempPlugin.type() + key);
                break;
            }
            case "Long": {
                value = tempPlugin.getLong(tempPlugin.type() + key);
                break;
            }
            case "Bool": {
                value = tempPlugin.getBool(tempPlugin.type() + key);
            }
        }
        return (T)(value == null ? defaultValue : value);
    }

    private class LruCacheData {
        private LruCache<String, Object> mCacheSPData;

        public LruCacheData(int maxSize) {
            if (Build.VERSION.SDK_INT >= 12) {
                this.mCacheSPData = new LruCache(maxSize);
            }
        }

        Object get(String key) {
            if (Build.VERSION.SDK_INT >= 12) {
                return this.mCacheSPData.get((Object)(AbstractStoreManager.this.mMaxPluginType + key));
            }
            return null;
        }

        void put(String key, Object value) {
            if (Build.VERSION.SDK_INT >= 12) {
                this.mCacheSPData.put((Object)(AbstractStoreManager.this.mMaxPluginType + key), value);
            }
        }

        void remove(String key) {
            if (Build.VERSION.SDK_INT >= 12) {
                this.mCacheSPData.remove((Object)(AbstractStoreManager.this.mMaxPluginType + key));
            }
        }
    }
}

