/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.jsbridge;

import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPIEmptyImplementation;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.listener.SAJSListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class H5Helper {
    private static CopyOnWriteArrayList<SAJSListener> mSAJSListeners;

    public static void addJavascriptInterface(View webView, Object obj, String interfaceName) {
        try {
            Class<?> clazz = webView.getClass();
            try {
                Method getSettingsMethod = clazz.getMethod("getSettings", new Class[0]);
                Object settings = getSettingsMethod.invoke((Object)webView, new Object[0]);
                if (settings != null) {
                    Method setJavaScriptEnabledMethod = settings.getClass().getMethod("setJavaScriptEnabled", Boolean.TYPE);
                    setJavaScriptEnabledMethod.invoke(settings, true);
                }
            }
            catch (Exception getSettingsMethod) {
                // empty catch block
            }
            Method addJSMethod = clazz.getMethod("addJavascriptInterface", Object.class, String.class);
            addJSMethod.invoke((Object)webView, obj, interfaceName);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static boolean verifyEventFromH5(String eventInfo) {
        try {
            SALog.i("SA.AppWebViewInterface", "verifyEventFromH5 h5 eventInfo = " + eventInfo);
            if (TextUtils.isEmpty((CharSequence)eventInfo)) {
                return false;
            }
            JSONObject eventObject = new JSONObject(eventInfo);
            String serverUrl = eventObject.optString("server_url");
            SALog.i("SA.AppWebViewInterface", "verifyEventFromH5 h5 serverUrl = " + serverUrl);
            if (!TextUtils.isEmpty((CharSequence)serverUrl)) {
                if (!new ServerUrl(serverUrl).check(new ServerUrl(SensorsDataAPI.getConfigOptions().getServerUrl()))) {
                    return false;
                }
                H5Helper.trackEvent(eventInfo);
                return true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    public static void trackEventFromH5(String eventInfo, boolean enableVerify) {
        try {
            if (TextUtils.isEmpty((CharSequence)eventInfo)) {
                return;
            }
            JSONObject eventObject = new JSONObject(eventInfo);
            SALog.i("SA.AppWebViewInterface", "trackEventFromH5 h5 enableVerify = " + enableVerify);
            if (enableVerify) {
                String serverUrl = eventObject.optString("server_url");
                SALog.i("SA.AppWebViewInterface", "trackEventFromH5 h5 serverUrl = " + serverUrl);
                if (!TextUtils.isEmpty((CharSequence)serverUrl)) {
                    if (!new ServerUrl(serverUrl).check(new ServerUrl(SensorsDataAPI.getConfigOptions().getServerUrl()))) {
                        return;
                    }
                } else {
                    return;
                }
            }
            H5Helper.trackEvent(eventInfo);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void addSAJSListener(SAJSListener listener) {
        try {
            if (mSAJSListeners == null) {
                mSAJSListeners = new CopyOnWriteArrayList();
            }
            if (!mSAJSListeners.contains(listener)) {
                mSAJSListeners.add(listener);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void removeSAJSListener(SAJSListener listener) {
        try {
            if (mSAJSListeners != null && mSAJSListeners.contains(listener)) {
                mSAJSListeners.remove(listener);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void handleJsMessage(WeakReference<View> view, String message) {
        if (mSAJSListeners != null && mSAJSListeners.size() > 0) {
            for (SAJSListener listener : mSAJSListeners) {
                try {
                    if (listener == null) continue;
                    listener.onReceiveJSMessage(view, message);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        }
    }

    private static void trackEvent(final String eventInfo) {
        if (SensorsDataAPI.sharedInstance() instanceof SensorsDataAPIEmptyImplementation) {
            SALog.i("SA.AppWebViewInterface", "trackEvent SensorsDataAPIEmptyImplementation");
            return;
        }
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                SACoreHelper.getInstance().trackEvent(new InputData().setExtras(eventInfo));
            }
        });
    }
}

