/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.internal.beans;

import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;

public class ServerUrl {
    private String url;
    private String host;
    private String project;
    private String token;
    private String baseUrl;

    private ServerUrl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerUrl(String url) {
        this.url = url;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.baseUrl = this.getBaseUrl(url);
            Uri uri = Uri.parse((String)url);
            try {
                this.host = uri.getHost();
                this.token = uri.getQueryParameter("token");
                this.project = uri.getQueryParameter("project");
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
            finally {
                if (TextUtils.isEmpty((CharSequence)this.host)) {
                    this.host = "";
                }
                if (TextUtils.isEmpty((CharSequence)this.project)) {
                    this.project = "default";
                }
                if (TextUtils.isEmpty((CharSequence)this.token)) {
                    this.token = "";
                }
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public String getProject() {
        return this.project;
    }

    public String getToken() {
        return this.token;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String toString() {
        return "url=" + this.url + ",baseUrl" + this.baseUrl + ",host=" + this.host + ",project=" + this.project + ",token=" + this.token;
    }

    public boolean check(ServerUrl serverUrl) {
        try {
            if (serverUrl != null && this.getHost().equals(serverUrl.getHost()) && this.getProject().equals(serverUrl.getProject())) {
                return true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    public String getBaseUrl(String url) {
        int pathPrefix;
        if (!TextUtils.isEmpty((CharSequence)url) && (pathPrefix = url.lastIndexOf("/")) != -1) {
            return url.substring(0, pathPrefix);
        }
        return "";
    }
}

