/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exceptions;

import android.os.Process;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.json.JSONObject;

public class SensorsDataExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final int SLEEP_TIMEOUT_MS = 400;
    private static final ArrayList<SAExceptionListener> sExceptionListeners = new ArrayList();
    private static SensorsDataExceptionHandler sInstance;
    private Thread.UncaughtExceptionHandler mDefaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    private static boolean isTrackCrash;

    private SensorsDataExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public static synchronized void init() {
        if (sInstance == null) {
            sInstance = new SensorsDataExceptionHandler();
        }
    }

    public static void addExceptionListener(SAExceptionListener listener) {
        if (listener != null && !sExceptionListeners.contains(listener)) {
            sExceptionListeners.add(listener);
        }
    }

    public static void removeExceptionListener(SAExceptionListener listener) {
        if (listener != null && sExceptionListeners.contains(listener)) {
            sExceptionListeners.remove(listener);
        }
    }

    public static void enableAppCrash() {
        isTrackCrash = true;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            if (isTrackCrash) {
                try {
                    final JSONObject messageProp = new JSONObject();
                    try {
                        StringWriter writer = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(writer);
                        e.printStackTrace(printWriter);
                        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                            cause.printStackTrace(printWriter);
                        }
                        printWriter.close();
                        String result = ((Object)writer).toString();
                        messageProp.put("app_crashed_reason", (Object)result);
                    }
                    catch (Exception ex) {
                        SALog.printStackTrace(ex);
                    }
                    SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                        @Override
                        public void run() {
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventName("AppCrashed").setProperties(messageProp).setEventType(EventType.TRACK));
                        }
                    });
                    SensorsDataAPI.sharedInstance().flush();
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException e1) {
                        SALog.printStackTrace(e1);
                    }
                }
                catch (Exception ex) {
                    SALog.printStackTrace(ex);
                }
            }
            for (SAExceptionListener exceptionListener : sExceptionListeners) {
                try {
                    exceptionListener.uncaughtException(t, e);
                }
                catch (Exception e1) {
                    SALog.printStackTrace(e1);
                }
            }
            if (this.mDefaultExceptionHandler != null) {
                this.mDefaultExceptionHandler.uncaughtException(t, e);
            } else {
                this.killProcessAndExit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void killProcessAndExit() {
        try {
            Process.killProcess((int)Process.myPid());
            System.exit(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        isTrackCrash = false;
    }

    public static interface SAExceptionListener {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

