/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;

public class SensorsDataLoadingDialog
extends Dialog {
    private RelativeLayout mLoadingLayout;

    public SensorsDataLoadingDialog(Context context) {
        super(context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.sensors_analytics_dialog_loading);
        Window window = this.getWindow();
        this.setCancelable(false);
        if (window != null) {
            WindowManager.LayoutParams p = window.getAttributes();
            p.height = SADisplayUtil.dip2px(this.getContext(), 98.0f);
            p.width = SADisplayUtil.dip2px(this.getContext(), 88.0f);
            window.setAttributes(p);
            GradientDrawable bg = new GradientDrawable();
            bg.setShape(0);
            bg.setColor(-1);
            bg.setCornerRadius((float)SADisplayUtil.dip2px(this.getContext(), 7.0f));
            window.setBackgroundDrawable((Drawable)bg);
        }
        this.initView();
    }

    private void initView() {
        this.mLoadingLayout = (RelativeLayout)this.findViewById(R.id.sensors_analytics_rotate_layout);
        ImageView imageView1 = (ImageView)this.findViewById(R.id.sensorsdata_analytics_loading_image1);
        ImageView imageView2 = (ImageView)this.findViewById(R.id.sensorsdata_analytics_loading_image2);
        ImageView imageView3 = (ImageView)this.findViewById(R.id.sensorsdata_analytics_loading_image3);
        ImageView imageView4 = (ImageView)this.findViewById(R.id.sensorsdata_analytics_loading_image4);
        this.setCircleBackground((View)imageView1, "#00C48E");
        this.setCircleBackground((View)imageView2, "#33D0A5");
        this.setCircleBackground((View)imageView3, "#CCF3E8");
        this.setCircleBackground((View)imageView4, "#80E1C6");
        this.initAnim();
    }

    private void setCircleBackground(View view, String color) {
        OvalShape ovalShape = new OvalShape();
        ShapeDrawable drawable = new ShapeDrawable((Shape)ovalShape);
        drawable.getPaint().setColor(Color.parseColor((String)color));
        drawable.getPaint().setStyle(Paint.Style.FILL_AND_STROKE);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)drawable);
        } else {
            view.setBackgroundDrawable((Drawable)drawable);
        }
    }

    private void initAnim() {
        RotateAnimation mAnimation = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        mAnimation.setRepeatCount(-1);
        mAnimation.setDuration(1200L);
        mAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mLoadingLayout.setAnimation((Animation)mAnimation);
    }
}

