/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.data.SAProviderHelper;

public class SensorsDataContentProvider
extends ContentProvider {
    private static final UriMatcher uriMatcher = new UriMatcher(-1);
    private SAProviderHelper mProviderHelper;

    public boolean onCreate() {
        block4: {
            try {
                String packageName;
                Context context = this.getContext();
                if (context == null) break block4;
                try {
                    packageName = context.getApplicationContext().getPackageName();
                }
                catch (UnsupportedOperationException e) {
                    packageName = "com.sensorsdata.analytics.android.sdk.test";
                }
                this.mProviderHelper = SAProviderHelper.getInstance(context);
                this.mProviderHelper.appendUri(uriMatcher, packageName + ".SensorsDataContentProvider");
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
        return true;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int deletedCounts = 0;
        try {
            int code = uriMatcher.match(uri);
            if (1 == code) {
                return this.mProviderHelper.deleteEvents(selection, selectionArgs);
            }
            if (code == 15) {
                return this.mProviderHelper.removeSP(uri.getQueryParameter("remove_key"));
            }
            if (code == 16) {
                return this.mProviderHelper.deleteEventsCache(selection, selectionArgs);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return deletedCounts;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        if (values == null || values.size() == 0) {
            return uri;
        }
        try {
            int code = uriMatcher.match(uri);
            if (code == 1) {
                return this.mProviderHelper.insertEvent(uri, values);
            }
            if (code == 16) {
                return this.mProviderHelper.insertEventsCache(uri, values);
            }
            if (code == 8) {
                return this.mProviderHelper.insertChannelPersistent(uri, values);
            }
            this.mProviderHelper.insertPersistent(code, uri, values);
            return uri;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return uri;
        }
    }

    public int bulkInsert(Uri uri, ContentValues[] values) {
        try {
            return this.mProviderHelper.bulkInsert(uri, values);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return 0;
        }
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor = null;
        try {
            int code = uriMatcher.match(uri);
            cursor = code == 1 ? this.mProviderHelper.queryByTable("events", projection, selection, selectionArgs, sortOrder) : (code == 16 ? this.mProviderHelper.queryByTable("events_cache", projection, selection, selectionArgs, sortOrder) : (code == 8 ? this.mProviderHelper.queryByTable("t_channel", projection, selection, selectionArgs, sortOrder) : this.mProviderHelper.queryPersistent(code, uri)));
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return cursor;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }
}

