/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.eventbus;

import com.sensorsdata.analytics.android.sdk.core.eventbus.Subscription;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SAEventBus {
    private static SAEventBus sSAEventBus;
    private final Map<String, CopyOnWriteArrayList<Subscription>> mSubscriberMap = new ConcurrentHashMap<String, CopyOnWriteArrayList<Subscription>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SAEventBus getInstance() {
        if (sSAEventBus != null) return sSAEventBus;
        Class<SAEventBus> clazz = SAEventBus.class;
        synchronized (SAEventBus.class) {
            if (sSAEventBus != null) return sSAEventBus;
            sSAEventBus = new SAEventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sSAEventBus;
        }
    }

    public void register(String tag, Subscription subscription) {
        if (subscription == null) {
            return;
        }
        subscription.eventTag = tag;
        if (this.mSubscriberMap.containsKey(tag)) {
            this.mSubscriberMap.get(tag).add(subscription);
        } else {
            CopyOnWriteArrayList<Subscription> list = new CopyOnWriteArrayList<Subscription>();
            list.add(subscription);
            this.mSubscriberMap.put(tag, list);
        }
    }

    public void clear() {
        this.mSubscriberMap.clear();
    }

    public void unRegister(Subscription subscription) {
        if (subscription == null) {
            return;
        }
        if (this.mSubscriberMap.containsKey(subscription.eventTag)) {
            this.mSubscriberMap.get(subscription.eventTag).remove(subscription);
        }
    }

    public void post(String eventBusTag, Object result) {
        if (this.mSubscriberMap.containsKey(eventBusTag)) {
            CopyOnWriteArrayList<Subscription> list = this.mSubscriberMap.get(eventBusTag);
            for (Subscription subscription : list) {
                if (!this.checkType(subscription, result)) continue;
                subscription.notify(result);
            }
        }
    }

    private boolean checkType(Subscription subscription, Object result) {
        try {
            subscription.getClass().getDeclaredMethod("notify", result.getClass());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

