/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.event.imp;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.event.Event;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.event.TrackEvent;
import com.sensorsdata.analytics.android.sdk.core.event.imp.BaseEventAssemble;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.exceptions.InvalidDataException;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import org.json.JSONException;
import org.json.JSONObject;

class ItemEventAssemble
extends BaseEventAssemble {
    private static final String TAG = "SA.ItemEventAssemble";

    public ItemEventAssemble(SAContextManager saContextManager) {
        super(saContextManager);
    }

    @Override
    public Event assembleData(InputData input) {
        try {
            if (this.isEventIgnore(input)) {
                return null;
            }
            TrackEvent trackEvent = new TrackEvent();
            this.appendDefaultProperty(input, trackEvent);
            this.appendLibProperty(trackEvent);
            this.handlePropertyProtocols(trackEvent);
            if (SALog.isLogEnabled()) {
                SALog.i(TAG, "track item event:\n" + JSONUtils.formatJson(trackEvent.toJSONObject().toString()));
            }
            return trackEvent;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    private boolean isEventIgnore(InputData inputData) {
        try {
            SADataHelper.assertPropertyTypes(inputData.getProperties());
            SADataHelper.assertItemId(inputData.getItemId());
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return true;
        }
        return false;
    }

    private void appendDefaultProperty(InputData inputData, TrackEvent trackEvent) {
        if (SADataHelper.assertPropertyKey(inputData.getItemType())) {
            trackEvent.setItemType(inputData.getItemType());
        }
        trackEvent.setItemId(inputData.getItemId());
        trackEvent.setType(inputData.getEventType().getEventType());
        trackEvent.setTime(inputData.getTime());
        try {
            trackEvent.setProperties(TimeUtils.formatDate(JSONUtils.cloneJsonObject(inputData.getProperties())));
        }
        catch (InvalidDataException e) {
            SALog.printStackTrace(e);
        }
    }

    private void appendLibProperty(TrackEvent trackEvent) throws JSONException {
        StackTraceElement traceElement;
        String libDetail;
        StackTraceElement[] trace;
        SensorsDataAPI sensorsDataAPI = SensorsDataAPI.sharedInstance();
        JSONObject libProperties = new JSONObject();
        libProperties.put("$lib", (Object)"Android");
        libProperties.put("$lib_version", (Object)sensorsDataAPI.getSDKVersion());
        libProperties.put("$lib_method", (Object)"code");
        libProperties.put("$app_version", (Object)AppInfoUtils.getAppVersionName(sensorsDataAPI.getSAContextManager().getContext()));
        JSONObject superProperties = (JSONObject)PersistentLoader.getInstance().getSuperPropertiesPst().get();
        if (superProperties != null && superProperties.has("$app_version")) {
            libProperties.put("$app_version", superProperties.get("$app_version"));
        }
        if ((trace = new Exception().getStackTrace()).length > 1 && !TextUtils.isEmpty((CharSequence)(libDetail = String.format("%s##%s##%s##%s", (traceElement = trace[0]).getClassName(), traceElement.getMethodName(), traceElement.getFileName(), traceElement.getLineNumber())))) {
            libProperties.put("$lib_detail", (Object)libDetail);
        }
        trackEvent.setLib(libProperties);
    }
}

