/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.event.imp;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.event.Event;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.event.TrackEvent;
import com.sensorsdata.analytics.android.sdk.core.event.imp.BaseEventAssemble;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertiesFetcher;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertyFilter;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import java.security.SecureRandom;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class H5TrackAssemble
extends BaseEventAssemble {
    private static final String TAG = "SA.H5TrackAssemble";

    public H5TrackAssemble(SAContextManager saContextManager) {
        super(saContextManager);
    }

    @Override
    public Event assembleData(InputData input) {
        try {
            if (TextUtils.isEmpty((CharSequence)input.getExtras())) {
                return null;
            }
            TrackEvent trackEvent = new TrackEvent();
            trackEvent.setExtras(new JSONObject(input.getExtras()));
            String eventName = trackEvent.getExtras().optString("event");
            SADataHelper.assertEventName(eventName);
            trackEvent.setEventName(eventName);
            JSONObject propertiesObject = trackEvent.getExtras().optJSONObject("properties");
            SADataHelper.assertPropertyTypes(propertiesObject);
            if (propertiesObject == null) {
                propertiesObject = new JSONObject();
            }
            trackEvent.setProperties(propertiesObject);
            String type = trackEvent.getExtras().getString("type");
            EventType eventType = EventType.valueOf(type.toUpperCase(Locale.getDefault()));
            SensorsDataAPI sensorsDataAPI = SensorsDataAPI.sharedInstance();
            SAContextManager contextManager = sensorsDataAPI.getSAContextManager();
            this.appendDefaultProperty(trackEvent);
            this.overrideH5Ids(eventType, trackEvent, sensorsDataAPI);
            this.appendNativeProperty(eventType, trackEvent, contextManager);
            this.appendPropertyPlugin(eventType, trackEvent, sensorsDataAPI);
            this.appendSessionId(eventType, trackEvent);
            this.handlePropertyProtocols(trackEvent);
            if (!this.handleEventCallback(eventType, trackEvent)) {
                return null;
            }
            this.appendPluginVersion(eventType, trackEvent);
            this.removeH5Property(trackEvent);
            this.overrideDeviceId(eventType, trackEvent, contextManager);
            if (this.updateIdentities(eventType, trackEvent, sensorsDataAPI, contextManager)) {
                SADataHelper.assertPropertyTypes(trackEvent.getProperties());
                trackEvent.getExtras().put("properties", (Object)trackEvent.getProperties());
                trackEvent.getExtras().put("lib", (Object)trackEvent.getLib());
                this.checkIDConsistent(eventType, trackEvent, sensorsDataAPI);
                if (SALog.isLogEnabled()) {
                    SALog.i(TAG, "track event from H5:\n" + JSONUtils.formatJson(trackEvent.getExtras().toString()));
                }
                return trackEvent;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    private void overrideH5Ids(EventType eventType, TrackEvent trackEvent, SensorsDataAPI sensorsDataAPI) throws JSONException {
        String distinctIdKey = "distinct_id";
        if (eventType == EventType.TRACK_SIGNUP) {
            trackEvent.getExtras().put("original_id", (Object)sensorsDataAPI.getAnonymousId());
        } else if (!TextUtils.isEmpty((CharSequence)sensorsDataAPI.getLoginId())) {
            trackEvent.getExtras().put(distinctIdKey, (Object)sensorsDataAPI.getLoginId());
        } else {
            trackEvent.getExtras().put(distinctIdKey, (Object)sensorsDataAPI.getAnonymousId());
        }
    }

    private void appendDefaultProperty(TrackEvent trackEvent) {
        try {
            trackEvent.getExtras().put("_hybrid_h5", true);
            if (!trackEvent.getExtras().has("time")) {
                trackEvent.getExtras().put("time", System.currentTimeMillis());
            }
            SecureRandom secureRandom = new SecureRandom();
            trackEvent.getExtras().put("_track_id", secureRandom.nextInt());
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private void appendNativeProperty(EventType eventType, TrackEvent trackEvent, SAContextManager contextManager) throws JSONException {
        JSONObject libObject = trackEvent.getExtras().optJSONObject("lib");
        if (libObject != null) {
            libObject.put("$app_version", (Object)AppInfoUtils.getAppVersionName(contextManager.getContext()));
            JSONObject superProperties = (JSONObject)PersistentLoader.getInstance().getSuperPropertiesPst().get();
            if (superProperties != null && superProperties.has("$app_version")) {
                libObject.put("$app_version", superProperties.get("$app_version"));
            }
            trackEvent.setLib(libObject);
        }
        if (eventType.isTrack()) {
            trackEvent.getProperties().put("$is_first_day", contextManager.isFirstDay(trackEvent.getExtras().optLong("time")));
        }
    }

    private void appendPropertyPlugin(EventType eventType, TrackEvent trackEvent, SensorsDataAPI sensorsDataAPI) {
        SAPropertyFilter filter = new SAPropertyFilter();
        filter.setEvent(trackEvent.getEventName());
        filter.setEventJson("lib", trackEvent.getExtras().optJSONObject("lib"));
        filter.setProperties(trackEvent.getProperties());
        filter.setType(eventType);
        SAPropertiesFetcher propertiesFetcher = sensorsDataAPI.getSAContextManager().getPluginManager().propertiesHandler(filter);
        if (propertiesFetcher != null) {
            trackEvent.setProperties(propertiesFetcher.getProperties());
            trackEvent.setLib(propertiesFetcher.getEventJson("lib"));
        }
    }

    private void removeH5Property(TrackEvent trackEvent) {
        if (trackEvent.getExtras().has("_nocache")) {
            trackEvent.getExtras().remove("_nocache");
        }
        if (trackEvent.getExtras().has("server_url")) {
            trackEvent.getExtras().remove("server_url");
        }
        if (trackEvent.getExtras().has("_flush_time")) {
            trackEvent.getExtras().remove("_flush_time");
        }
    }

    private boolean updateIdentities(EventType eventType, TrackEvent trackEvent, SensorsDataAPI sensorsDataAPI, SAContextManager contextManager) {
        try {
            if (EventType.TRACK_ID_UNBIND.getEventType().equals(eventType.getEventType())) {
                return true;
            }
            if (contextManager.getUserIdentityAPI().mergeH5Identities(eventType, trackEvent.getExtras())) {
                return true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    private void checkIDConsistent(EventType eventType, TrackEvent trackEvent, SensorsDataAPI sensorsDataAPI) {
        try {
            JSONObject identitiesJson = trackEvent.getExtras().optJSONObject("identities");
            if (identitiesJson != null) {
                if (EventType.TRACK_ID_UNBIND.getEventType().equals(eventType.getEventType())) {
                    trackEvent.getExtras().remove("anonymous_id");
                    return;
                }
                String anonymousId = sensorsDataAPI.getAnonymousId();
                if (!TextUtils.isEmpty((CharSequence)anonymousId)) {
                    identitiesJson.put("$identity_anonymous_id", (Object)anonymousId);
                    trackEvent.getExtras().put("anonymous_id", (Object)anonymousId);
                } else {
                    trackEvent.getExtras().put("anonymous_id", (Object)identitiesJson.optString("$identity_anonymous_id"));
                }
                String loginId = sensorsDataAPI.getLoginId();
                if (!TextUtils.isEmpty((CharSequence)loginId)) {
                    String loginKey = sensorsDataAPI.getSAContextManager().getUserIdentityAPI().getIdentitiesInstance().getLoginIDKey();
                    if ("$identity_login_id".equals(loginKey)) {
                        identitiesJson.put(loginKey, (Object)loginId);
                    }
                } else {
                    loginId = identitiesJson.optString(sensorsDataAPI.getSAContextManager().getUserIdentityAPI().getIdentitiesInstance().getLoginIDKey());
                }
                if (eventType != EventType.TRACK_SIGNUP && !TextUtils.isEmpty((CharSequence)sensorsDataAPI.getLoginId())) {
                    trackEvent.getExtras().put("login_id", (Object)loginId);
                }
                trackEvent.getExtras().put("identities", (Object)identitiesJson);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }
}

