/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.business.visual;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;

public class SAVisualTools {
    public static void showOpenHeatMapDialog(Activity activity, String featureCode, String postUrl) {
        if (SAVisualTools.checkProjectIsValid(postUrl)) {
            if (!SAModuleManager.getInstance().hasModuleByName("sensors_analytics_module_visual")) {
                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_heatmap_sdk_fail));
                return;
            }
            if (!SensorsDataAPI.sharedInstance().isNetworkRequestEnable()) {
                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_heatmap_network_fail));
                return;
            }
            if (!SensorsDataAPI.sharedInstance().isHeatMapEnabled()) {
                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_heatmap_sdk_fail));
                return;
            }
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "showOpenHeatMapDialog", activity, featureCode, postUrl);
        } else {
            SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_visual_dialog_error));
        }
    }

    public static void showOpenVisualizedAutoTrackDialog(Activity activity, String featureCode, String postUrl) {
        if (SAVisualTools.checkProjectIsValid(postUrl)) {
            if (!SAModuleManager.getInstance().hasModuleByName("sensors_analytics_module_visual")) {
                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_visual_sdk_fail));
                return;
            }
            if (!SensorsDataAPI.sharedInstance().isNetworkRequestEnable()) {
                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_visual_network_fail));
                return;
            }
            if (!SensorsDataAPI.sharedInstance().isVisualizedAutoTrackEnabled()) {
                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_visual_sdk_fail));
                return;
            }
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "showOpenVisualizedAutoTrackDialog", activity, featureCode, postUrl);
        } else {
            SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_visual_dialog_error));
        }
    }

    public static void showPairingCodeInputDialog(Context context) {
        if (SAModuleManager.getInstance().hasModuleByName("sensors_analytics_module_visual")) {
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "showPairingCodeInputDialog", context);
        } else {
            SensorsDataDialogUtils.showDialog(context, SADisplayUtil.getStringResource(context, R.string.sensors_analytics_visual_heatmap_sdk_fail));
        }
    }

    private static boolean checkProjectIsValid(String url) {
        Uri serverUri;
        Uri schemeUri;
        String serverUrl = SensorsDataAPI.sharedInstance().getServerUrl();
        String sdkProject = null;
        String serverProject = null;
        if (!TextUtils.isEmpty((CharSequence)url) && (schemeUri = Uri.parse((String)url)) != null) {
            sdkProject = schemeUri.getQueryParameter("project");
        }
        if (!TextUtils.isEmpty((CharSequence)serverUrl) && (serverUri = Uri.parse((String)serverUrl)) != null) {
            serverProject = serverUri.getQueryParameter("project");
        }
        return !TextUtils.isEmpty(sdkProject) && !TextUtils.isEmpty(serverProject) && TextUtils.equals((CharSequence)sdkProject, (CharSequence)serverProject);
    }
}

