/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.business.instantevent;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import java.util.List;
import org.json.JSONObject;

public class InstantEventUtils {
    public static boolean isInstantEvent(InputData inputData) {
        try {
            if (inputData == null) {
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)inputData.getExtras())) {
                List listInstantEvents = SensorsDataAPI.getConfigOptions().getInstantEvents();
                if (inputData.getEventType() == null) {
                    return false;
                }
                if (inputData.getEventType().isTrack() && !TextUtils.isEmpty((CharSequence)inputData.getEventName()) && listInstantEvents != null && listInstantEvents.contains(inputData.getEventName())) {
                    return true;
                }
            } else {
                JSONObject jsonObject = new JSONObject(inputData.getExtras());
                String type = jsonObject.optString("type", "");
                boolean is_instant_event = jsonObject.optBoolean("is_instant_event", false);
                if (InstantEventUtils.instanceEventType(type) && is_instant_event) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    public static int isInstantEvent(JSONObject jsonObject) {
        int instant_event = 0;
        try {
            boolean _hybrid_h5 = jsonObject.optBoolean("_hybrid_h5", false);
            if (_hybrid_h5) {
                boolean is_instant_event = jsonObject.optBoolean("is_instant_event", false);
                String type = jsonObject.optString("type", "");
                jsonObject.remove("is_instant_event");
                if (InstantEventUtils.instanceEventType(type) && is_instant_event) {
                    instant_event = 1;
                }
            } else {
                String type = jsonObject.optString("type", "");
                String event = jsonObject.optString("event", "");
                List listInstantEvents = SensorsDataAPI.getConfigOptions().getInstantEvents();
                if (InstantEventUtils.instanceEventType(type) && !TextUtils.isEmpty((CharSequence)event) && listInstantEvents != null && listInstantEvents.contains(event)) {
                    instant_event = 1;
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return instant_event;
    }

    private static boolean instanceEventType(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        return type.equals(EventType.TRACK.getEventType()) || type.equals(EventType.TRACK_SIGNUP.getEventType()) || type.equals(EventType.TRACK_ID_BIND.getEventType()) || type.equals(EventType.TRACK_ID_UNBIND.getEventType());
    }
}

