/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk;

import android.util.Log;

public class SALog {
    private static boolean debug;
    private static boolean enableLog;
    private static boolean disableSDK;
    private static final int CHUNK_SIZE = 4000;

    public static void d(String tag, String msg) {
        if (debug && !disableSDK) {
            SALog.info(tag, msg, null);
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (debug && !disableSDK) {
            SALog.info(tag, msg, tr);
        }
    }

    public static void i(String tag, String msg) {
        if (enableLog && !disableSDK) {
            SALog.info(tag, msg, null);
        }
    }

    public static void i(String tag, Throwable tr) {
        if (enableLog && !disableSDK) {
            SALog.info(tag, "", tr);
        }
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (enableLog && !disableSDK) {
            SALog.info(tag, msg, tr);
        }
    }

    public static void i(String tag, String msg, Object ... object) {
        if (enableLog && !disableSDK) {
            SALog.info(tag, String.format(msg, object), null);
        }
    }

    public static void info(String tag, String msg, Throwable tr) {
        try {
            if (msg != null) {
                byte[] bytes = msg.getBytes();
                int length = bytes.length;
                if (length <= 4000) {
                    Log.i((String)tag, (String)msg, (Throwable)tr);
                } else {
                    int index = 0;
                    int lastIndexOfLF = 0;
                    while (index < length - 4000) {
                        lastIndexOfLF = SALog.lastIndexOfLF(bytes, index);
                        int chunkLength = lastIndexOfLF - index;
                        Log.i((String)tag, (String)new String(bytes, index, chunkLength), null);
                        if (chunkLength < 4000) {
                            index = lastIndexOfLF + 1;
                            continue;
                        }
                        index = lastIndexOfLF;
                    }
                    if (length > index) {
                        Log.i((String)tag, (String)new String(bytes, index, length - index), (Throwable)tr);
                    }
                }
            } else {
                Log.i((String)tag, null, (Throwable)tr);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private static int lastIndexOfLF(byte[] bytes, int fromIndex) {
        int index;
        for (int i = index = Math.min(fromIndex + 4000, bytes.length - 1); i > index - 4000; --i) {
            if (bytes[i] != 10) continue;
            return i;
        }
        return index;
    }

    public static void printStackTrace(Exception e) {
        if (enableLog && !disableSDK && e != null) {
            Log.e((String)"SA.Exception", (String)"", (Throwable)e);
        }
    }

    static void setDebug(boolean isDebug) {
        debug = isDebug;
    }

    public static void setEnableLog(boolean isEnableLog) {
        enableLog = isEnableLog;
    }

    public static void setDisableSDK(boolean configDisableSDK) {
        disableSDK = configDisableSDK;
    }

    public static boolean isLogEnabled() {
        return enableLog;
    }

    public static boolean isDebug() {
        return debug;
    }
}

