/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Build;
import android.os.Bundle;
import com.sensorsdata.analytics.android.sdk.ISensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataDynamicSuperProperties;
import com.sensorsdata.analytics.android.sdk.TrackTaskManager;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.business.DefaultAppState;
import com.sensorsdata.analytics.android.sdk.core.business.SAPropertyManager;
import com.sensorsdata.analytics.android.sdk.core.rpc.SensorsDataContentObserver;
import com.sensorsdata.analytics.android.sdk.core.tasks.TrackTaskManagerThread;
import com.sensorsdata.analytics.android.sdk.data.SAProviderHelper;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbParams;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.exceptions.SensorsDataExceptionHandler;
import com.sensorsdata.analytics.android.sdk.internal.beans.InternalConfigOptions;
import com.sensorsdata.analytics.android.sdk.jsbridge.H5Helper;
import com.sensorsdata.analytics.android.sdk.listener.SAEventListener;
import com.sensorsdata.analytics.android.sdk.listener.SAFunctionListener;
import com.sensorsdata.analytics.android.sdk.listener.SAJSListener;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataLifecycleMonitorManager;
import com.sensorsdata.analytics.android.sdk.monitor.TrackMonitor;
import com.sensorsdata.analytics.android.sdk.remote.SensorsDataRemoteManager;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

abstract class AbstractSensorsDataAPI
implements ISensorsDataAPI {
    protected static final String TAG = "SA.SensorsDataAPI";
    static final String VERSION = "6.8.8";
    protected static final Map<Context, SensorsDataAPI> sInstanceMap = new ConcurrentHashMap<Context, SensorsDataAPI>();
    protected static SAConfigOptions mSAConfigOptions;
    protected InternalConfigOptions mInternalConfigs;
    protected SAContextManager mSAContextManager;
    protected final Object mLoginIdLock = new Object();
    protected String mServerUrl;
    protected String mOriginServerUrl;
    protected boolean mSDKConfigInit;
    protected List<Integer> mHeatMapActivities;
    protected List<Integer> mVisualizedAutoTrackActivities;
    protected TrackTaskManager mTrackTaskManager;
    protected TrackTaskManagerThread mTrackTaskManagerThread;
    protected SensorsDataDynamicSuperProperties mDynamicSuperPropertiesCallBack;

    public AbstractSensorsDataAPI(Context context, SAConfigOptions configOptions, SensorsDataAPI.DebugMode debugMode) {
        this.mInternalConfigs = new InternalConfigOptions();
        this.mInternalConfigs.context = context;
        this.setDebugMode(debugMode);
        this.mHeatMapActivities = new ArrayList<Integer>();
        this.mVisualizedAutoTrackActivities = new ArrayList<Integer>();
        try {
            mSAConfigOptions = configOptions.clone();
            PersistentLoader.preInit(context);
            this.mTrackTaskManager = TrackTaskManager.getInstance();
            this.mTrackTaskManagerThread = new TrackTaskManagerThread();
            new Thread((Runnable)this.mTrackTaskManagerThread, "SA.TaskQueueThread").start();
            SensorsDataExceptionHandler.init();
            this.initSAConfig(AbstractSensorsDataAPI.mSAConfigOptions.mServerUrl);
            this.mSAContextManager = new SAContextManager((SensorsDataAPI)this, this.mInternalConfigs);
            this.registerLifecycleCallbacks((SensorsDataAPI)this, context);
            this.delayInitTask(context.getApplicationContext());
            SAProviderHelper.getInstance(context).migratingDB(context.getApplicationContext());
            this.enableTrackScreenOrientation(AbstractSensorsDataAPI.mSAConfigOptions.mTrackScreenOrientationEnabled);
            if (SALog.isLogEnabled()) {
                SALog.i(TAG, String.format(TimeUtils.SDK_LOCALE, "Initialized the instance of Sensors Analytics SDK with server url '%s', flush interval %d ms, debugMode: %s", new Object[]{this.mServerUrl, AbstractSensorsDataAPI.mSAConfigOptions.mFlushInterval, debugMode}));
            }
            SensorsDataUtils.initUniAppStatus();
        }
        catch (Throwable ex) {
            SALog.i(TAG, ex.getMessage());
        }
    }

    protected AbstractSensorsDataAPI() {
    }

    private static boolean isSDKDisabledByRemote() {
        try {
            boolean isSDKDisabled = SensorsDataRemoteManager.isSDKDisabledByRemote();
            if (isSDKDisabled) {
                SALog.i(TAG, "remote config: SDK is disabled");
            }
            return isSDKDisabled;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    private static boolean isSDKDisableByLocal() {
        if (mSAConfigOptions == null) {
            SALog.i(TAG, "SAConfigOptions is null");
            return true;
        }
        return AbstractSensorsDataAPI.mSAConfigOptions.isDisableSDK;
    }

    public static boolean isSDKDisabled() {
        return AbstractSensorsDataAPI.isSDKDisableByLocal() || AbstractSensorsDataAPI.isSDKDisabledByRemote();
    }

    public void addEventListener(SAEventListener eventListener) {
        this.mSAContextManager.addEventListener(eventListener);
    }

    public void removeEventListener(SAEventListener eventListener) {
        this.mSAContextManager.removeEventListener(eventListener);
    }

    public void addSAJSListener(SAJSListener listener) {
        H5Helper.addSAJSListener(listener);
    }

    public void removeSAJSListener(SAJSListener listener) {
        H5Helper.removeSAJSListener(listener);
    }

    public void addFunctionListener(final SAFunctionListener functionListener) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                TrackMonitor.getInstance().addFunctionListener(functionListener);
            }
        });
    }

    public void removeFunctionListener(final SAFunctionListener functionListener) {
        try {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    TrackMonitor.getInstance().removeFunctionListener(functionListener);
                }
            });
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public static SAConfigOptions getConfigOptions() {
        return mSAConfigOptions;
    }

    public SensorsDataAPI.DebugMode getDebugMode() {
        return this.mInternalConfigs.debugMode;
    }

    public void setDebugMode(SensorsDataAPI.DebugMode debugMode) {
        this.mInternalConfigs.debugMode = debugMode;
        if (debugMode == SensorsDataAPI.DebugMode.DEBUG_OFF) {
            this.enableLog(false);
            SALog.setDebug(false);
            this.mServerUrl = this.mOriginServerUrl;
        } else {
            this.enableLog(true);
            SALog.setDebug(true);
            this.setServerUrl(this.mOriginServerUrl);
        }
    }

    public boolean isDisableDefaultRemoteConfig() {
        return this.mInternalConfigs.isDefaultRemoteConfigEnable;
    }

    public SAContextManager getSAContextManager() {
        return this.mSAContextManager;
    }

    void registerNetworkListener(final Context context) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                NetworkUtils.registerNetworkListener(context);
            }
        });
    }

    void unregisterNetworkListener(final Context context) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                NetworkUtils.unregisterNetworkListener(context);
            }
        });
    }

    protected void initSAConfig(String serverURL) {
        Bundle configBundle = AppInfoUtils.getAppInfoBundle(this.mInternalConfigs.context);
        if (mSAConfigOptions == null) {
            this.mSDKConfigInit = false;
            mSAConfigOptions = new SAConfigOptions(serverURL);
        } else {
            this.mSDKConfigInit = true;
        }
        if (AbstractSensorsDataAPI.mSAConfigOptions.mInvokeLog) {
            this.enableLog(AbstractSensorsDataAPI.mSAConfigOptions.mLogEnabled);
        } else {
            this.enableLog(configBundle.getBoolean("com.sensorsdata.analytics.android.EnableLogging", this.mInternalConfigs.debugMode != SensorsDataAPI.DebugMode.DEBUG_OFF));
        }
        SALog.setDisableSDK(AbstractSensorsDataAPI.mSAConfigOptions.isDisableSDK);
        this.setServerUrl(serverURL);
        if (AbstractSensorsDataAPI.mSAConfigOptions.mEnableTrackAppCrash) {
            SensorsDataExceptionHandler.enableAppCrash();
        }
        if (AbstractSensorsDataAPI.mSAConfigOptions.mFlushInterval == 0) {
            mSAConfigOptions.setFlushInterval(configBundle.getInt("com.sensorsdata.analytics.android.FlushInterval", 15000));
        }
        if (AbstractSensorsDataAPI.mSAConfigOptions.mFlushBulkSize == 0) {
            mSAConfigOptions.setFlushBulkSize(configBundle.getInt("com.sensorsdata.analytics.android.FlushBulkSize", 100));
        }
        if (AbstractSensorsDataAPI.mSAConfigOptions.mMaxCacheSize == 0L) {
            mSAConfigOptions.setMaxCacheSize(0x2000000L);
        }
        if (!AbstractSensorsDataAPI.mSAConfigOptions.mInvokeHeatMapEnabled) {
            AbstractSensorsDataAPI.mSAConfigOptions.mHeatMapEnabled = configBundle.getBoolean("com.sensorsdata.analytics.android.HeatMap", false);
        }
        if (!AbstractSensorsDataAPI.mSAConfigOptions.mInvokeVisualizedEnabled) {
            AbstractSensorsDataAPI.mSAConfigOptions.mVisualizedEnabled = configBundle.getBoolean("com.sensorsdata.analytics.android.VisualizedAutoTrack", false);
        }
        this.mInternalConfigs.saConfigOptions = mSAConfigOptions;
        this.mInternalConfigs.isShowDebugView = configBundle.getBoolean("com.sensorsdata.analytics.android.ShowDebugInfoView", true);
        this.mInternalConfigs.isDefaultRemoteConfigEnable = configBundle.getBoolean("com.sensorsdata.analytics.android.DisableDefaultRemoteConfig", false);
        this.mInternalConfigs.isMainProcess = AppInfoUtils.isMainProcess(this.mInternalConfigs.context, configBundle);
        this.mInternalConfigs.isTrackDeviceId = configBundle.getBoolean("com.sensorsdata.analytics.android.DisableTrackDeviceId", false);
        if (mSAConfigOptions.getLimitKeys() != null) {
            SAPropertyManager.getInstance().registerLimitKeys(mSAConfigOptions.getLimitKeys());
        }
    }

    protected void applySAConfigOptions() {
        if (AbstractSensorsDataAPI.mSAConfigOptions.mEnableTrackAppCrash) {
            SensorsDataExceptionHandler.enableAppCrash();
        }
        if (AbstractSensorsDataAPI.mSAConfigOptions.mInvokeLog) {
            this.enableLog(AbstractSensorsDataAPI.mSAConfigOptions.mLogEnabled);
        }
        this.enableTrackScreenOrientation(AbstractSensorsDataAPI.mSAConfigOptions.mTrackScreenOrientationEnabled);
        if (!AbstractSensorsDataAPI.mSAConfigOptions.mVisualizedEnabled && AbstractSensorsDataAPI.mSAConfigOptions.mVisualizedPropertiesEnabled) {
            SALog.i(TAG, "The VisualizedProperties is enabled, and visualizedEnable is false");
            mSAConfigOptions.enableVisualizedAutoTrack(true);
        }
    }

    public JSONObject getDynamicProperty() {
        JSONObject dynamicProperty = null;
        try {
            if (this.mDynamicSuperPropertiesCallBack != null) {
                dynamicProperty = this.mDynamicSuperPropertiesCallBack.getDynamicSuperProperties();
                SADataHelper.assertPropertyTypes(dynamicProperty);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return dynamicProperty;
    }

    private void registerLifecycleCallbacks(SensorsDataAPI sensorsDataAPI, Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 14) {
                Application app = (Application)context.getApplicationContext();
                SensorsDataLifecycleMonitorManager.getInstance().addActivityLifeCallback(AppStateTools.getInstance());
                AppStateTools.getInstance().addAppStateListener(new DefaultAppState(sensorsDataAPI));
                AppStateTools.getInstance().delayInit(context);
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)SensorsDataLifecycleMonitorManager.getInstance().getCallback());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private void registerObserver(Context context) {
        SensorsDataContentObserver contentObserver = new SensorsDataContentObserver();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.registerContentObserver(DbParams.getInstance().getSessionTimeUri(), false, (ContentObserver)contentObserver);
        contentResolver.registerContentObserver(DbParams.getInstance().getLoginIdUri(), false, (ContentObserver)contentObserver);
        contentResolver.registerContentObserver(DbParams.getInstance().getDisableSDKUri(), false, (ContentObserver)contentObserver);
        contentResolver.registerContentObserver(DbParams.getInstance().getEnableSDKUri(), false, (ContentObserver)contentObserver);
        contentResolver.registerContentObserver(DbParams.getInstance().getUserIdentities(), false, (ContentObserver)contentObserver);
    }

    protected void delayInitTask(final Context context) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSensorsDataAPI.this.registerObserver(context);
                    AbstractSensorsDataAPI.this.registerNetworkListener(context);
                }
                catch (Exception ex) {
                    SALog.printStackTrace(ex);
                }
            }
        });
    }
}

