/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.TabHost;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class WindowHelper {
    private static Object sWindowManger;
    private static Field viewsField;
    private static Class sPhoneWindowClazz;
    private static Class sPopupWindowClazz;
    private static Class<?> sListMenuItemViewClazz;
    private static Method sItemViewGetDataMethod;
    private static boolean sIsInitialized;
    private static boolean sArrayListWindowViews;
    private static boolean sViewArrayWindowViews;
    private static final String sMainWindowPrefix = "/MainWindow";
    private static final String sDialogWindowPrefix = "/DialogWindow";
    private static final String sPopupWindowPrefix = "/PopupWindow";
    private static final String sCustomWindowPrefix = "/CustomWindow";
    private static Comparator<View> sViewSizeComparator;

    public static void init() {
        if (!sIsInitialized) {
            String windowManagerClassName = Build.VERSION.SDK_INT >= 17 ? "android.view.WindowManagerGlobal" : "android.view.WindowManagerImpl";
            Class<?> windowManager = null;
            try {
                windowManager = Class.forName(windowManagerClassName);
                String windowManagerString = Build.VERSION.SDK_INT >= 17 ? "sDefaultWindowManager" : (Build.VERSION.SDK_INT >= 13 ? "sWindowManager" : "mWindowManager");
                viewsField = windowManager.getDeclaredField("mViews");
                Field instanceField = windowManager.getDeclaredField(windowManagerString);
                viewsField.setAccessible(true);
                if (viewsField.getType() == ArrayList.class) {
                    sArrayListWindowViews = true;
                } else if (viewsField.getType() == View[].class) {
                    sViewArrayWindowViews = true;
                }
                instanceField.setAccessible(true);
                sWindowManger = instanceField.get(null);
            }
            catch (NoSuchFieldException windowManagerString) {
            }
            catch (IllegalAccessException windowManagerString) {
            }
            catch (ClassNotFoundException windowManagerString) {
                // empty catch block
            }
            try {
                sListMenuItemViewClazz = Class.forName("com.android.internal.view.menu.ListMenuItemView");
                Class<?> itemViewInterface = Class.forName("com.android.internal.view.menu.MenuView$ItemView");
                sItemViewGetDataMethod = itemViewInterface.getDeclaredMethod("getItemData", new Class[0]);
            }
            catch (ClassNotFoundException itemViewInterface) {
            }
            catch (NoSuchMethodException itemViewInterface) {
                // empty catch block
            }
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    try {
                        sPhoneWindowClazz = Class.forName("com.android.internal.policy.PhoneWindow$DecorView");
                    }
                    catch (ClassNotFoundException var5) {
                        sPhoneWindowClazz = Class.forName("com.android.internal.policy.DecorView");
                    }
                } else {
                    sPhoneWindowClazz = Class.forName("com.android.internal.policy.impl.PhoneWindow$DecorView");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                sPopupWindowClazz = Build.VERSION.SDK_INT >= 23 ? Class.forName("android.widget.PopupWindow$PopupDecorView") : Class.forName("android.widget.PopupWindow$PopupViewContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            sIsInitialized = true;
        }
    }

    private static View[] getWindowViews() {
        View[] result = new View[]{};
        if (sWindowManger == null) {
            View[] viewArray;
            Window window;
            Activity current = AppStateTools.getInstance().getForegroundActivity();
            View decorView = null;
            if (current != null && (window = current.getWindow()).isActive()) {
                decorView = window.getDecorView();
            }
            if (current != null) {
                View[] viewArray2 = new View[1];
                viewArray = viewArray2;
                viewArray2[0] = decorView;
            } else {
                viewArray = result;
            }
            return viewArray;
        }
        try {
            View[] views = null;
            if (sArrayListWindowViews) {
                views = ((ArrayList)viewsField.get(sWindowManger)).toArray(result);
            } else if (sViewArrayWindowViews) {
                views = (View[])viewsField.get(sWindowManger);
            }
            if (views != null) {
                result = views;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return WindowHelper.filterNullAndDismissToastView(result);
    }

    public static View[] getSortedWindowViews() {
        View[] views = WindowHelper.getWindowViews();
        if (views.length > 1) {
            views = Arrays.copyOf(views, views.length);
            Arrays.sort(views, sViewSizeComparator);
        }
        return views;
    }

    private static View[] filterNullAndDismissToastView(View[] array) {
        ArrayList<View> list = new ArrayList<View>(array.length);
        long currentTime = System.currentTimeMillis();
        View[] result = array;
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            View view = result[i];
            if (view == null) continue;
            list.add(view);
        }
        result = new View[list.size()];
        list.toArray(result);
        return result;
    }

    public static boolean isDecorView(Class rootClass) {
        if (!sIsInitialized) {
            WindowHelper.init();
        }
        return rootClass == sPhoneWindowClazz || rootClass == sPopupWindowClazz;
    }

    @SuppressLint(value={"RestrictedApi"})
    private static Object getMenuItemData(View view) throws InvocationTargetException, IllegalAccessException {
        if (view.getClass() == sListMenuItemViewClazz) {
            return sItemViewGetDataMethod.invoke((Object)view, new Object[0]);
        }
        if (SAViewUtils.instanceOfAndroidXListMenuItemView(view) || SAViewUtils.instanceOfSupportListMenuItemView(view) || SAViewUtils.instanceOfBottomNavigationItemView(view)) {
            return SAViewUtils.getMenuItemData(view);
        }
        return null;
    }

    private static View findMenuItemView(View view, MenuItem item) throws InvocationTargetException, IllegalAccessException {
        View navButtonView;
        if (SAViewUtils.instanceOfActionMenuItem(item) && item.getItemId() == 16908332 && SAViewUtils.instanceOfToolbar(view.getParent()) && view instanceof ImageButton && (navButtonView = (View)ReflectUtil.findField(new String[]{"androidx.appcompat.widget.Toolbar", "android.support.v7.widget.Toolbar", "android.widget.Toolbar"}, (Object)view.getParent(), "mNavButtonView")) != null && navButtonView == view) {
            return view;
        }
        if (WindowHelper.getMenuItemData(view) == item) {
            return view;
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                View menuView = WindowHelper.findMenuItemView(((ViewGroup)view).getChildAt(i), item);
                if (menuView == null) continue;
                return menuView;
            }
        }
        return null;
    }

    public static View getClickView(MenuItem menuItem) {
        int i = 0;
        if (menuItem == null) {
            return null;
        }
        WindowHelper.init();
        View[] windows = WindowHelper.getWindowViews();
        try {
            View menuView;
            for (View window2 : windows) {
                if (window2.getClass() != sPopupWindowClazz || (menuView = WindowHelper.findMenuItemView(window2, menuItem)) == null) continue;
                return menuView;
            }
            int length = windows.length;
            while (i < length) {
                View window = windows[i];
                if (window.getClass() != sPopupWindowClazz && (menuView = WindowHelper.findMenuItemView(window, menuItem)) != null) {
                    return menuView;
                }
                ++i;
            }
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (IllegalAccessException e2) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static View getClickView(String tabHostTag) {
        if (TextUtils.isEmpty((CharSequence)tabHostTag)) {
            return null;
        }
        WindowHelper.init();
        View[] windows = WindowHelper.getWindowViews();
        try {
            for (int i = 0; i < windows.length; ++i) {
                View tabHostView;
                View window = windows[i];
                if (window.getClass() == sPopupWindowClazz || (tabHostView = WindowHelper.findTabView(window, tabHostTag)) == null) continue;
                return tabHostView;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static View findTabView(View view, String tabHostTag) {
        if (TextUtils.equals((CharSequence)tabHostTag, (CharSequence)WindowHelper.getTabHostTag(view))) {
            return (View)ReflectUtil.callMethod(view, "getCurrentTabView", new Object[0]);
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                View tabHostView = WindowHelper.findTabView(((ViewGroup)view).getChildAt(i), tabHostTag);
                if (tabHostView == null) continue;
                return tabHostView;
            }
        }
        return null;
    }

    private static String getTabHostTag(View view) {
        if (view instanceof TabHost) {
            return (String)ReflectUtil.callMethod(view, "getCurrentTabTag", new Object[0]);
        }
        return null;
    }

    public static String getWindowPrefix(View root) {
        if (root.hashCode() == AppStateTools.getInstance().getCurrentRootWindowsHashCode()) {
            return WindowHelper.getMainWindowPrefix();
        }
        return WindowHelper.getSubWindowPrefix(root);
    }

    public static String getMainWindowPrefix() {
        return sMainWindowPrefix;
    }

    private static String getSubWindowPrefix(View root) {
        Class<?> rootClazz;
        ViewGroup.LayoutParams params = root.getLayoutParams();
        if (params != null && params instanceof WindowManager.LayoutParams) {
            int type = ((WindowManager.LayoutParams)params).type;
            if (type == 1) {
                return sMainWindowPrefix;
            }
            if (type < 99 && root.getClass() == sPhoneWindowClazz) {
                return sDialogWindowPrefix;
            }
            if (type < 1999 && root.getClass() == sPopupWindowClazz) {
                return sPopupWindowPrefix;
            }
            if (type < 2999) {
                return sCustomWindowPrefix;
            }
        }
        if ((rootClazz = root.getClass()) == sPhoneWindowClazz) {
            return sDialogWindowPrefix;
        }
        if (rootClazz == sPopupWindowClazz) {
            return sPopupWindowPrefix;
        }
        return sCustomWindowPrefix;
    }

    public static boolean isMainWindow(View root) {
        ViewGroup.LayoutParams params = root.getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            return ((WindowManager.LayoutParams)params).type == 1;
        }
        return false;
    }

    public static boolean isDialogOrPopupWindow(View root) {
        String prefix = WindowHelper.getSubWindowPrefix(root);
        return TextUtils.equals((CharSequence)sDialogWindowPrefix, (CharSequence)prefix) || TextUtils.equals((CharSequence)sPopupWindowPrefix, (CharSequence)prefix);
    }

    public static boolean isCustomWindow(View root) {
        String prefix = WindowHelper.getSubWindowPrefix(root);
        return TextUtils.equals((CharSequence)sCustomWindowPrefix, (CharSequence)prefix);
    }

    static {
        sIsInitialized = false;
        sArrayListWindowViews = false;
        sViewArrayWindowViews = false;
        sViewSizeComparator = new Comparator<View>(){

            @Override
            public int compare(View lhs, View rhs) {
                int lhsHashCode = lhs.hashCode();
                int rhsHashCode = rhs.hashCode();
                int currentHashCode = AppStateTools.getInstance().getCurrentRootWindowsHashCode();
                if (lhsHashCode == currentHashCode) {
                    return -1;
                }
                return rhsHashCode == currentHashCode ? 1 : rhs.getWidth() * rhs.getHeight() - lhs.getWidth() * lhs.getHeight();
            }
        };
    }
}

