/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.DeviceUtils;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import java.lang.reflect.Field;

public class ToastUtil {
    private static final String TAG = ToastUtil.class.getSimpleName();
    private static final Handler mToastMainHandler = new Handler(Looper.getMainLooper());

    public static void showShort(Context context, String message) {
        if (context == null) {
            SALog.i(TAG, "context is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        ToastUtil.showToastToMain(context.getApplicationContext(), message, 0);
    }

    public static void showLong(Context context, String message) {
        if (context == null) {
            SALog.i(TAG, "context is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        ToastUtil.showToastToMain(context.getApplicationContext(), message, 1);
    }

    private static void showToastToMain(final Context context, final String message, final int lengthLong) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            ToastUtil.showToast(context, message, lengthLong);
        } else {
            mToastMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    ToastUtil.showToast(context, message, lengthLong);
                }
            });
        }
    }

    private static void showToast(Context context, String message, int lengthLong) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)message, (int)lengthLong);
        ToastUtil.hookToast(toast);
        toast.show();
    }

    private static void hookToast(Toast toast) {
        if (26 > Build.VERSION.SDK_INT || ToastUtil.isHuaWei() && 26 == Build.VERSION.SDK_INT) {
            try {
                Field mHandler;
                Object mTn = ReflectUtil.findFieldRecur(toast, "mTN");
                if (mTn != null && (mHandler = ReflectUtil.findFieldObj(mTn.getClass(), "mHandler")) != null) {
                    mHandler.setAccessible(true);
                    mHandler.set(mTn, (Object)new HandlerProxy((Handler)mHandler.get(mTn)));
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
    }

    private static boolean isHuaWei() {
        String manufacturer = DeviceUtils.getManufacturer();
        if (manufacturer == null) {
            return false;
        }
        return manufacturer.equalsIgnoreCase("honor") || manufacturer.equalsIgnoreCase("huawei");
    }

    private static class HandlerProxy
    extends Handler {
        private Handler mHandler;

        public HandlerProxy(Handler handler) {
            this.mHandler = handler;
        }

        public void handleMessage(Message msg) {
            try {
                this.mHandler.handleMessage(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

