/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.useridentity.h5identity;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.useridentity.UserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.useridentity.h5identity.H5UserIdentityAPI;
import java.util.Iterator;

public class SignUpH5UserIdentityAPI
extends H5UserIdentityAPI {
    private final UserIdentityAPI mUserIdentityApi;
    private final EventType eventType;

    public SignUpH5UserIdentityAPI(UserIdentityAPI userIdentityAPI, EventType eventType) {
        this.mUserIdentityApi = userIdentityAPI;
        this.eventType = eventType;
    }

    @Override
    public boolean updateIdentities() {
        try {
            String new_loginId;
            String h5login_id;
            String h5_identities = this.mEventObject.optString("identities");
            if (TextUtils.isEmpty((CharSequence)h5_identities)) {
                h5login_id = this.mEventObject.optString("distinct_id");
                if (!this.mUserIdentityApi.loginWithKeyBack("$identity_login_id", h5login_id)) {
                    return false;
                }
            } else if (this.mIdentityJson.has(this.mUserIdentityApi.getIdentitiesInstance().getLoginIDKey())) {
                String login_id = this.mIdentityJson.optString(this.mUserIdentityApi.getIdentitiesInstance().getLoginIDKey());
                if (!this.mUserIdentityApi.loginWithKeyBack(this.mUserIdentityApi.getIdentitiesInstance().getLoginIDKey(), login_id)) {
                    return false;
                }
            } else {
                h5login_id = this.mEventObject.optString("login_id");
                if (!TextUtils.isEmpty((CharSequence)h5login_id)) {
                    String[] keyAndValue = h5login_id.split("\\+");
                    if (keyAndValue.length == 2) {
                        String key = keyAndValue[0];
                        String value = keyAndValue[1];
                        String h5_value = this.mIdentityJson.optString(key);
                        if (this.mIdentityJson.has(key) && !TextUtils.isEmpty((CharSequence)h5_value) && h5_value.equals(value) && !this.mUserIdentityApi.loginWithKeyBack(key, value)) {
                            return false;
                        }
                    } else if (!this.traversalSearch(h5login_id)) {
                        return false;
                    }
                }
            }
            if (TextUtils.isEmpty((CharSequence)(new_loginId = this.mUserIdentityApi.getIdentitiesInstance().getLoginId()))) {
                this.mEventObject.put("login_id", (Object)new_loginId);
            }
            this.mergeIdentities(this.mUserIdentityApi.getIdentities(this.eventType));
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
        return true;
    }

    private boolean traversalSearch(String h5login_id) {
        String loginKey = "";
        int count = 0;
        Iterator iterator = this.mIdentityJson.keys();
        while (iterator.hasNext()) {
            String tmp_value;
            String tmp_key = (String)iterator.next();
            if (TextUtils.isEmpty((CharSequence)tmp_key) || TextUtils.isEmpty((CharSequence)(tmp_value = this.mIdentityJson.optString(tmp_key))) || !tmp_value.equals(h5login_id)) continue;
            loginKey = tmp_key;
            ++count;
        }
        if (count == 1) {
            return this.mUserIdentityApi.loginWithKeyBack(loginKey, h5login_id);
        }
        return false;
    }
}

