/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.useridentity.h5identity;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.useridentity.UserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.useridentity.h5identity.BindIDH5UserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.useridentity.h5identity.CommonUserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.useridentity.h5identity.H5UserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.useridentity.h5identity.SignUpH5UserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.useridentity.h5identity.UnbindIDH5UserIdentityAPI;
import org.json.JSONObject;

public class H5UserIdentityStrategy {
    private final UserIdentityAPI userIdentityAPI;

    public H5UserIdentityStrategy(UserIdentityAPI userIdentityAPI) {
        this.userIdentityAPI = userIdentityAPI;
    }

    public boolean processH5UserIdentity(EventType eventType, JSONObject eventObject) {
        try {
            H5UserIdentityAPI h5UserIdentityAPI;
            String identities = eventObject.optString("identities");
            JSONObject identityJson = !TextUtils.isEmpty((CharSequence)identities) ? new JSONObject(identities) : new JSONObject();
            if (EventType.TRACK_SIGNUP == eventType) {
                this.specialIDProcess(identityJson);
                h5UserIdentityAPI = new SignUpH5UserIdentityAPI(this.userIdentityAPI, eventType);
            } else if (EventType.TRACK_ID_BIND == eventType) {
                this.specialIDProcess(identityJson);
                h5UserIdentityAPI = new BindIDH5UserIdentityAPI(this.userIdentityAPI);
            } else if (EventType.TRACK_ID_UNBIND == eventType) {
                h5UserIdentityAPI = new UnbindIDH5UserIdentityAPI(this.userIdentityAPI);
            } else {
                this.specialIDProcess(identityJson);
                h5UserIdentityAPI = new CommonUserIdentityAPI(this.userIdentityAPI);
            }
            return h5UserIdentityAPI.process(identityJson, eventObject);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return false;
        }
    }

    private void specialIDProcess(JSONObject identityJson) {
        identityJson.remove("$identity_android_id");
        identityJson.remove("$identity_anonymous_id");
        identityJson.remove("$identity_android_uuid");
    }
}

