/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.useridentity;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.rpc.SensorsDataContentObserver;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentDistinctId;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.listener.SAEventListener;
import com.sensorsdata.analytics.android.sdk.monitor.TrackMonitor;
import com.sensorsdata.analytics.android.sdk.useridentity.IUserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.useridentity.Identities;
import com.sensorsdata.analytics.android.sdk.useridentity.LoginIDAndKey;
import com.sensorsdata.analytics.android.sdk.useridentity.h5identity.H5UserIdentityStrategy;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import java.util.UUID;
import org.json.JSONObject;

public final class UserIdentityAPI
implements IUserIdentityAPI {
    private static final String TAG = "SA.UserIdentityAPI";
    private final SAContextManager mSAContextManager;
    private final PersistentDistinctId mAnonymousId;
    private String mLoginIdValue = "";
    private final Identities mIdentitiesInstance;
    private H5UserIdentityStrategy mH5UserIdentityStrategy;

    public UserIdentityAPI(SAContextManager contextManager) {
        this.mSAContextManager = contextManager;
        this.mAnonymousId = PersistentLoader.getInstance().getAnonymousIdPst();
        this.mIdentitiesInstance = new Identities();
        try {
            this.mIdentitiesInstance.init(SensorsDataUtils.getIdentifier(contextManager.getContext()), (String)this.mAnonymousId.get());
            this.mLoginIdValue = this.mIdentitiesInstance.getJointLoginID();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public String getDistinctId() {
        try {
            String loginId = this.getLoginId();
            if (!TextUtils.isEmpty((CharSequence)loginId)) {
                return loginId;
            }
            return this.getAnonymousId();
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAnonymousId() {
        try {
            PersistentDistinctId persistentDistinctId = this.mAnonymousId;
            synchronized (persistentDistinctId) {
                return (String)this.mAnonymousId.get();
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAnonymousId() {
        try {
            PersistentDistinctId persistentDistinctId = this.mAnonymousId;
            synchronized (persistentDistinctId) {
                SALog.i(TAG, "resetAnonymousId is called");
                String androidId = SensorsDataUtils.getIdentifier(this.mSAContextManager.getContext());
                if (androidId.equals(this.mAnonymousId.get())) {
                    SALog.i(TAG, "DistinctId not change");
                    return;
                }
                String newDistinctId = SensorsDataUtils.isValidAndroidId(androidId) ? androidId : UUID.randomUUID().toString();
                this.mAnonymousId.commit(newDistinctId);
                if (this.mIdentitiesInstance.getIdentities(Identities.State.DEFAULT).has("$identity_anonymous_id")) {
                    this.mIdentitiesInstance.updateSpecialIDKeyAndValue(Identities.SpecialID.ANONYMOUS_ID, (String)this.mAnonymousId.get());
                }
                if (this.mSAContextManager.getEventListenerList() != null) {
                    for (SAEventListener eventListener : this.mSAContextManager.getEventListenerList()) {
                        try {
                            eventListener.resetAnonymousId();
                        }
                        catch (Exception e) {
                            SALog.printStackTrace(e);
                        }
                    }
                }
                TrackMonitor.getInstance().callResetAnonymousId(newDistinctId);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public void updateLoginId(String loginIDKey, String loginId) {
        this.mLoginIdValue = LoginIDAndKey.jointLoginID(loginIDKey, loginId);
    }

    @Override
    public String getLoginId() {
        try {
            if (AppInfoUtils.isTaskExecuteThread()) {
                String loginId = this.mIdentitiesInstance.getJointLoginID();
                if (TextUtils.isEmpty((CharSequence)loginId)) {
                    String loginIdKey = this.mIdentitiesInstance.getLoginIDKey();
                    loginIdKey = TextUtils.isEmpty((CharSequence)loginId) ? "$identity_login_id" : loginIdKey;
                    JSONObject jsonObject = this.mIdentitiesInstance.getIdentities(Identities.State.LOGIN_KEY);
                    loginId = jsonObject == null ? "" : jsonObject.optString(loginIdKey);
                }
                return loginId;
            }
            if (this.mLoginIdValue == null) {
                this.mLoginIdValue = "";
            }
            return this.mLoginIdValue;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void identify(String distinctId) {
        try {
            SALog.i(TAG, "identify is called");
            PersistentDistinctId persistentDistinctId = this.mAnonymousId;
            synchronized (persistentDistinctId) {
                if (!distinctId.equals(this.mAnonymousId.get())) {
                    this.mAnonymousId.commit(distinctId);
                    this.mIdentitiesInstance.updateSpecialIDKeyAndValue(Identities.SpecialID.ANONYMOUS_ID, distinctId);
                    if (this.mSAContextManager.getEventListenerList() != null) {
                        for (SAEventListener eventListener : this.mSAContextManager.getEventListenerList()) {
                            try {
                                eventListener.identify();
                            }
                            catch (Exception e) {
                                SALog.printStackTrace(e);
                            }
                        }
                    }
                    TrackMonitor.getInstance().callIdentify(distinctId);
                }
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    @Override
    public void login(String loginId) {
        this.loginWithKeyBack("$identity_login_id", loginId);
    }

    @Override
    public void login(String loginId, JSONObject properties) {
        this.loginWithKeyBack("$identity_login_id", loginId);
    }

    @Override
    public void loginWithKey(String loginIDKey, String loginID) {
        this.loginWithKeyBack(loginIDKey, loginID);
    }

    @Override
    public void loginWithKey(String loginIDKey, String loginID, JSONObject properties) {
        this.loginWithKeyBack(loginIDKey, loginID);
    }

    public boolean loginWithKeyBack(String loginIDKey, String loginID) {
        boolean flag;
        try {
            flag = this.mIdentitiesInstance.updateLoginKeyAndID(loginIDKey, loginID, this.getAnonymousId());
            if (flag) {
                if (this.mSAContextManager.getEventListenerList() != null) {
                    for (SAEventListener eventListener : this.mSAContextManager.getEventListenerList()) {
                        try {
                            eventListener.login();
                        }
                        catch (Exception e) {
                            SALog.printStackTrace(e);
                        }
                    }
                }
                TrackMonitor.getInstance().callLogin(this.mIdentitiesInstance.getJointLoginID());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            flag = false;
        }
        return flag;
    }

    @Override
    public void logout() {
        try {
            boolean isLogin;
            SensorsDataContentObserver.State.LOGOUT.isDid = true;
            SensorsDataContentObserver.State.LOGIN.isDid = false;
            JSONObject identities = this.mIdentitiesInstance.getIdentities(Identities.State.DEFAULT);
            boolean bl = isLogin = !TextUtils.isEmpty((CharSequence)this.mIdentitiesInstance.getLoginId());
            if (!isLogin && (identities == null || identities.length() == 1 && (identities.has("$identity_android_id") || identities.has("$identity_android_uuid")))) {
                return;
            }
            SALog.i(TAG, "logout is called");
            this.mIdentitiesInstance.removeLoginKeyAndID();
            if (isLogin) {
                if (this.mSAContextManager.getEventListenerList() != null) {
                    for (SAEventListener eventListener : this.mSAContextManager.getEventListenerList()) {
                        try {
                            eventListener.logout();
                        }
                        catch (Exception e) {
                            SALog.printStackTrace(e);
                        }
                    }
                }
                TrackMonitor.getInstance().callLogout();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        SALog.i(TAG, "Clean loginId");
    }

    @Override
    public void bind(String key, String value) {
        this.bindBack(key, value);
    }

    public boolean bindBack(String key, String value) {
        boolean flag;
        try {
            flag = this.mIdentitiesInstance.update(key, value);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
        return flag;
    }

    @Override
    public void unbind(String key, String value) {
        this.unbindBack(key, value);
    }

    @Override
    public void resetAnonymousIdentity(String anonymousId) {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mLoginIdValue)) {
                SALog.i(TAG, "resetAnonymousIdentity \u9700\u9000\u51fa\u767b\u5f55\u540e\u8c03\u7528");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)anonymousId)) {
                anonymousId = UUID.randomUUID().toString();
            }
            this.mAnonymousId.commit(anonymousId);
            this.mIdentitiesInstance.updateIDKeyAndValue(anonymousId);
            if (this.mSAContextManager.getEventListenerList() != null) {
                for (SAEventListener eventListener : this.mSAContextManager.getEventListenerList()) {
                    try {
                        eventListener.resetAnonymousId();
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            }
            TrackMonitor.getInstance().callResetAnonymousId(anonymousId);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public boolean unbindBack(String key, String value) {
        boolean flag;
        try {
            flag = this.mIdentitiesInstance.remove(key, value);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
        return flag;
    }

    public JSONObject getIdentities(EventType eventType) {
        if (EventType.TRACK_SIGNUP == eventType) {
            return this.mIdentitiesInstance.getIdentities(Identities.State.LOGIN_KEY);
        }
        if (EventType.TRACK_ID_UNBIND == eventType) {
            return this.mIdentitiesInstance.getIdentities(Identities.State.REMOVE_KEYID);
        }
        return this.mIdentitiesInstance.getIdentities(Identities.State.DEFAULT);
    }

    @Override
    public JSONObject getIdentities() {
        return this.mIdentitiesInstance.getIdentities(Identities.State.DEFAULT);
    }

    public Identities getIdentitiesInstance() {
        return this.mIdentitiesInstance;
    }

    public boolean mergeH5Identities(EventType eventType, JSONObject eventObject) {
        if (this.mH5UserIdentityStrategy == null) {
            this.mH5UserIdentityStrategy = new H5UserIdentityStrategy(this);
        }
        return this.mH5UserIdentityStrategy.processH5UserIdentity(eventType, eventObject);
    }

    public void trackH5Notify(JSONObject eventObject) {
        try {
            if (this.mSAContextManager.getEventListenerList() != null) {
                for (SAEventListener eventListener : this.mSAContextManager.getEventListenerList()) {
                    try {
                        eventListener.trackEvent(eventObject);
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        TrackMonitor.getInstance().callTrack(eventObject);
    }
}

