/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.plugin.encrypt;

import android.content.Context;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbParams;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.AbstractStoreManager;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.DefaultStorePlugin;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.StorePlugin;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class SAStoreManager
extends AbstractStoreManager {
    public static final String SECRET_KEY = "sa_sp_encrypt_secret_key";
    private static final String TAG = "SA.SAStoreManager";
    private static final String SP_SENSORS_DATA_API = "com.sensorsdata.analytics.android.sdk.SensorsDataAPI";
    private static final String SP_SENSORS_DATA = "sensorsdata";
    private static final String SP_SENSORS_DATA_EXIT = "sensorsdata.exit";
    private final ArrayList<String> mAPIStoreKeys = new ArrayList();

    private SAStoreManager() {
    }

    public static SAStoreManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void registerPlugins(List<StorePlugin> configPlugins, Context context) {
        if (configPlugins == null || configPlugins.isEmpty()) {
            this.mDefaultState = true;
            this.registerExitPlugin(context);
            this.registerAPIPlugin(context);
            this.registerSensorsDataPlugin(context);
        } else {
            this.mDefaultState = false;
            if (this.isRegisterPlugin(context, SP_SENSORS_DATA_EXIT)) {
                this.registerExitPlugin(context);
            }
            if (this.isRegisterPlugin(context, SP_SENSORS_DATA_API)) {
                this.registerAPIPlugin(context);
            }
            if (this.isRegisterPlugin(context, SP_SENSORS_DATA)) {
                this.registerSensorsDataPlugin(context);
            }
            for (StorePlugin plugin : configPlugins) {
                this.registerPlugin(plugin);
            }
        }
    }

    private void registerExitPlugin(Context context) {
        final ArrayList<String> exitKeys = new ArrayList<String>();
        exitKeys.add("app_exit_data");
        this.registerPlugin(new DefaultStorePlugin(context, SP_SENSORS_DATA_EXIT){

            @Override
            public List<String> storeKeys() {
                return exitKeys;
            }
        });
    }

    private void registerAPIPlugin(Context context) {
        this.registerPlugin(new DefaultStorePlugin(context, SP_SENSORS_DATA_API){

            @Override
            public List<String> storeKeys() {
                if (SAStoreManager.this.mAPIStoreKeys.isEmpty()) {
                    SAStoreManager.this.initAPIKeys();
                }
                return SAStoreManager.this.mAPIStoreKeys;
            }
        });
    }

    private void registerSensorsDataPlugin(Context context) {
        this.registerPlugin(new DefaultStorePlugin(context, SP_SENSORS_DATA){

            @Override
            public List<String> storeKeys() {
                return null;
            }
        });
    }

    private void initAPIKeys() {
        try {
            Field[] fields;
            for (Field field : fields = DbParams.PersistentName.class.getDeclaredFields()) {
                this.mAPIStoreKeys.add((String)field.get(null));
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private static class SingletonHolder {
        private static final SAStoreManager INSTANCE = new SAStoreManager();

        private SingletonHolder() {
        }
    }
}

