/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.plugin.encrypt;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.StorePlugin;
import com.sensorsdata.analytics.android.sdk.util.SASpUtils;

public class SAEncryptStorePlugin
implements StorePlugin {
    private final SharedPreferences mStoreSp;
    private final String mFileName;

    public SAEncryptStorePlugin(Context context) {
        this(context, "com.sensorsdata.analytics.android.sdk");
    }

    public SAEncryptStorePlugin(Context context, String fileName) {
        this.mStoreSp = SASpUtils.getSharedPreferences(context, fileName, 0);
        this.mFileName = fileName;
    }

    @Override
    public void setString(String key, String value) {
        this.mStoreSp.edit().putString(this.encryptValue(key), this.encryptValue(value)).apply();
    }

    @Override
    public void setBool(String key, boolean value) {
        this.mStoreSp.edit().putString(this.encryptValue(key), this.encryptValue(String.valueOf(value))).apply();
    }

    @Override
    public void setInteger(String key, int value) {
        this.mStoreSp.edit().putString(this.encryptValue(key), this.encryptValue(String.valueOf(value))).apply();
    }

    @Override
    public void setFloat(String key, float value) {
        this.mStoreSp.edit().putString(this.encryptValue(key), this.encryptValue(String.valueOf(value))).apply();
    }

    @Override
    public void setLong(String key, long value) {
        this.mStoreSp.edit().putString(this.encryptValue(key), this.encryptValue(String.valueOf(value))).apply();
    }

    @Override
    public String getString(String key) {
        String value = this.mStoreSp.getString(this.encryptValue(key), null);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return this.decryptValue(value);
        }
        return null;
    }

    @Override
    public Boolean getBool(String key) {
        String value = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public Integer getInteger(String key) {
        String value = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    @Override
    public Float getFloat(String key) {
        String value = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        return null;
    }

    @Override
    public Long getLong(String key) {
        String value = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return Long.parseLong(value);
        }
        return null;
    }

    @Override
    public void remove(String key) {
        this.mStoreSp.edit().remove(this.encryptValue(key)).apply();
    }

    @Override
    public boolean isExists(String key) {
        return this.mStoreSp.contains(this.encryptValue(key));
    }

    @Override
    public String type() {
        return this.mFileName;
    }

    @Override
    public void upgrade(StorePlugin oldPlugin) {
    }

    private String decryptValue(String value) {
        String decryptValue = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "decryptAES", value);
        return TextUtils.isEmpty((CharSequence)decryptValue) ? value : decryptValue;
    }

    private String encryptValue(String value) {
        String encryptValue = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptAES", value);
        return TextUtils.isEmpty((CharSequence)encryptValue) ? value : encryptValue;
    }
}

