/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentValues;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DataOperation;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbParams;
import com.sensorsdata.analytics.android.sdk.data.adapter.EncryptDataOperation;
import com.sensorsdata.analytics.android.sdk.data.adapter.EventDataOperation;
import com.sensorsdata.analytics.android.sdk.data.adapter.PersistentDataOperation;
import com.sensorsdata.analytics.android.sdk.data.adapter.TransportEncryption;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentRemoteSDKConfig;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DbAdapter {
    private static DbAdapter instance;
    private final DbParams mDbParams;
    private DataOperation mTrackEventOperation;
    private DataOperation mPersistentOperation;

    private DbAdapter(SAContextManager saContextManager) {
        this.mDbParams = DbParams.getInstance(saContextManager.getContext().getPackageName());
        SAConfigOptions saConfigOptions = saContextManager.getInternalConfigs().saConfigOptions;
        this.mTrackEventOperation = saConfigOptions.isEnableEncrypt() ? new EncryptDataOperation(saContextManager.getContext().getApplicationContext()) : (saConfigOptions.isTransportEncrypt() ? new TransportEncryption(saContextManager.getContext().getApplicationContext()) : new EventDataOperation(saContextManager.getContext().getApplicationContext()));
        this.mPersistentOperation = new PersistentDataOperation(saContextManager.getContext().getApplicationContext());
    }

    public static DbAdapter getInstance(SAContextManager saContextManager) {
        if (instance == null) {
            instance = new DbAdapter(saContextManager);
        }
        return instance;
    }

    public static DbAdapter getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The static method getInstance(SAContextManager saContextManager) should be called before calling getInstance()");
        }
        return instance;
    }

    public int addJSON(JSONObject j) {
        int code = this.mTrackEventOperation.insertData(this.mDbParams.getEventUri(), j);
        if (code == 0) {
            return this.mTrackEventOperation.queryDataCount(this.mDbParams.getEventUri(), 2);
        }
        return code;
    }

    public void deleteAllEvents() {
        this.mTrackEventOperation.deleteData(this.mDbParams.getEventUri(), "DB_DELETE_ALL");
    }

    public int cleanupEvents(JSONArray ids, boolean is_instant_event) {
        this.mTrackEventOperation.deleteData(this.mDbParams.getEventUri(), ids);
        return this.mTrackEventOperation.queryDataCount(this.mDbParams.getEventUri(), is_instant_event ? 1 : 0);
    }

    public void commitActivityCount(int activityCount) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getActivityStartCountUri(), new JSONObject().put("value", activityCount));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public int getActivityCount() {
        String[] values = this.mPersistentOperation.queryData(this.mDbParams.getActivityStartCountUri(), 1);
        if (values != null && values.length > 0) {
            return Integer.parseInt(values[0]);
        }
        return 0;
    }

    public void commitAppStartTime(long appStartTime) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getAppStartTimeUri(), new JSONObject().put("value", appStartTime));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public long getAppStartTime() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getAppStartTimeUri(), 1);
            if (values != null && values.length > 0) {
                return Long.parseLong(values[0]);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return 0L;
    }

    public void commitAppExitData(String appEndData) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getAppExitDataUri(), new JSONObject().put("value", (Object)appEndData));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public String getAppExitData() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getAppExitDataUri(), 1);
            if (values != null && values.length > 0) {
                return values[0];
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return "";
    }

    public void commitLoginId(String loginId) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getLoginIdUri(), new JSONObject().put("value", (Object)loginId));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public String getLoginId() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getLoginIdUri(), 1);
            if (values != null && values.length > 0) {
                return values[0];
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return "";
    }

    public void commitSessionIntervalTime(int sessionIntervalTime) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getSessionTimeUri(), new JSONObject().put("value", sessionIntervalTime));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public int getSessionIntervalTime() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getSessionTimeUri(), 1);
            if (values != null && values.length > 0) {
                return Integer.parseInt(values[0]);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return 0;
    }

    public boolean isFirstChannelEvent(String[] eventName) {
        try {
            return this.mTrackEventOperation.queryDataCount(this.mDbParams.getChannelPersistentUri(), null, "event_name = ? or event_name = ? ", eventName, null) <= 0;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    public void addChannelEvent(String eventName) {
        try {
            ContentValues values = new ContentValues();
            values.put("event_name", eventName);
            this.mTrackEventOperation.insertData(this.mDbParams.getChannelPersistentUri(), values);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void commitSubProcessFlushState(boolean flushState) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getSubProcessUri(), new JSONObject().put("value", flushState));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public boolean isSubProcessFlushing() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getSubProcessUri(), 1);
            if (values != null && values.length > 0) {
                return Integer.parseInt(values[0]) == 1;
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return true;
    }

    public void commitIdentities(String identities) {
        try {
            String encodeIdentities = "Base64:" + Base64Coder.encodeString(identities);
            this.mPersistentOperation.insertData(this.mDbParams.getUserIdentities(), new JSONObject().put("value", (Object)encodeIdentities));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public String getIdentities() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getUserIdentities(), 1);
            if (values != null && values.length > 0) {
                return DbAdapter.decodeIdentities(values[0]);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return null;
    }

    public static String decodeIdentities(String identities) {
        if (identities == null) {
            return null;
        }
        return Base64Coder.decodeString(identities.substring(identities.indexOf(":") + 1));
    }

    public void commitLoginIdKey(String loginIdKey) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getLoginIdKeyUri(), new JSONObject().put("value", (Object)loginIdKey));
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public String getLoginIdKey() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getLoginIdKeyUri(), 1);
            if (values != null && values.length > 0) {
                return values[0];
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return "";
    }

    public void commitRemoteConfig(String config) {
        try {
            this.mPersistentOperation.insertData(this.mDbParams.getRemoteConfigUri(), new JSONObject().put("value", (Object)config));
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public String getRemoteConfig() {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getRemoteConfigUri(), 1);
            if (values != null && values.length > 0) {
                return values[0];
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return "";
    }

    public String getRemoteConfigFromLocal() {
        try {
            PersistentRemoteSDKConfig persistentRemoteSDKConfig = PersistentLoader.getInstance().getRemoteSDKConfig();
            return persistentRemoteSDKConfig == null ? "" : (String)persistentRemoteSDKConfig.get();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    public void commitPushID(String key, String pushId) {
        try {
            JSONObject jsonObject = new JSONObject().put("push_key", (Object)key).put("push_value", (Object)pushId);
            this.mPersistentOperation.insertData(this.mDbParams.getPushIdUri(), jsonObject);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public String getPushId(String key) {
        try {
            String[] values = this.mPersistentOperation.queryData(this.mDbParams.getPushIdUri().buildUpon().appendQueryParameter("push_key", key).build(), 1);
            if (values != null && values.length > 0) {
                return values[0];
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return "";
    }

    public void removePushId(String key) {
        this.mPersistentOperation.deleteData(this.mDbParams.getPushIdUri(), key);
    }

    public String[] generateDataString(String tableName, int limit, boolean is_instant_event) {
        try {
            return this.mTrackEventOperation.queryData(this.mDbParams.getEventUri(), is_instant_event, limit);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }
}

