/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.tasks;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.TrackTaskManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TrackTaskManagerThread
implements Runnable {
    private static final int POOL_SIZE = 1;
    private TrackTaskManager mTrackTaskManager;
    private ExecutorService mPool;
    private boolean isStop = false;

    public TrackTaskManagerThread() {
        try {
            this.mTrackTaskManager = TrackTaskManager.getInstance();
            this.mPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "SA.TaskExecuteThread");
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void run() {
        try {
            Runnable downloadTask;
            while (!this.isStop) {
                downloadTask = this.mTrackTaskManager.takeTrackEventTask();
                this.mPool.execute(downloadTask);
            }
            while ((downloadTask = this.mTrackTaskManager.pollTrackEventTask()) != null) {
                this.mPool.execute(downloadTask);
            }
            this.mPool.shutdown();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void stop() {
        this.isStop = true;
        if (this.mTrackTaskManager.isEmpty()) {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    public boolean isStopped() {
        return this.isStop;
    }
}

