/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.event.imp;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.business.SAPluginVersion;
import com.sensorsdata.analytics.android.sdk.core.business.session.SessionRelatedManager;
import com.sensorsdata.analytics.android.sdk.core.event.EventProcessor;
import com.sensorsdata.analytics.android.sdk.core.event.TrackEvent;
import com.sensorsdata.analytics.android.sdk.core.event.imp.H5TrackAssemble;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.internal.beans.InternalConfigOptions;
import com.sensorsdata.analytics.android.sdk.listener.SAEventListener;
import com.sensorsdata.analytics.android.sdk.monitor.TrackMonitor;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.SAPresetPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseEventAssemble
implements EventProcessor.IAssembleData {
    private static final String TAG = "SA.BaseEventAssemble";
    protected InternalConfigOptions mInternalConfigs;

    public BaseEventAssemble(SAContextManager saContextManager) {
        this.mInternalConfigs = saContextManager.getInternalConfigs();
    }

    protected void appendSessionId(EventType eventType, TrackEvent trackEvent) {
        if (eventType.isTrack()) {
            try {
                SessionRelatedManager.getInstance().handleEventOfSession(trackEvent.getEventName(), trackEvent.getProperties(), trackEvent.getTime());
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
    }

    protected boolean handleEventCallback(EventType eventType, TrackEvent trackEvent) {
        if (!eventType.isTrack()) {
            return true;
        }
        if (!this.isEnterDb(trackEvent.getEventName(), trackEvent.getProperties())) {
            SALog.i(TAG, trackEvent.getEventName() + " event can not enter database");
            return false;
        }
        return true;
    }

    protected void appendPluginVersion(EventType eventType, TrackEvent trackEvent) {
        if (!eventType.isTrack()) {
            return;
        }
        SAPluginVersion.appendPluginVersion(trackEvent.getProperties());
    }

    protected void handleEventListener(EventType eventType, TrackEvent trackEvent, SAContextManager contextManager) {
        try {
            if (contextManager.getEventListenerList() != null && eventType.isTrack()) {
                for (SAEventListener eventListener : contextManager.getEventListenerList()) {
                    eventListener.trackEvent(trackEvent.toJSONObject());
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        try {
            if (eventType.isTrack()) {
                TrackMonitor.getInstance().callTrack(trackEvent.toJSONObject());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    protected void handlePropertyProtocols(TrackEvent trackEvent) throws JSONException {
        if (trackEvent.getProperties().has("$project")) {
            if (this instanceof H5TrackAssemble) {
                trackEvent.getExtras().put("project", (Object)trackEvent.getProperties().optString("$project"));
            } else {
                trackEvent.setProject(trackEvent.getProperties().optString("$project"));
            }
            trackEvent.getProperties().remove("$project");
        }
        if (trackEvent.getProperties().has("$token")) {
            if (this instanceof H5TrackAssemble) {
                trackEvent.getExtras().put("token", (Object)trackEvent.getProperties().optString("$token"));
            } else {
                trackEvent.setToken(trackEvent.getProperties().optString("$token"));
            }
            trackEvent.getProperties().remove("$token");
        }
        if (trackEvent.getProperties().has("$time")) {
            try {
                if (this instanceof H5TrackAssemble) {
                    long time = trackEvent.getProperties().getLong("$time");
                    if (TimeUtils.isDateValid(time)) {
                        trackEvent.getExtras().put("time", time);
                    }
                } else {
                    Object timeDate = trackEvent.getProperties().opt("$time");
                    if (timeDate instanceof Date && TimeUtils.isDateValid((Date)timeDate)) {
                        trackEvent.setTime(((Date)timeDate).getTime());
                    }
                }
            }
            catch (Exception ex) {
                SALog.printStackTrace(ex);
            }
            trackEvent.getProperties().remove("$time");
        }
    }

    protected void overrideDeviceId(EventType eventType, TrackEvent trackEvent, SAContextManager contextManager) {
        try {
            SAPropertyPlugin presetPlugin;
            if (eventType.isTrack() && trackEvent != null && (presetPlugin = contextManager.getPluginManager().getPropertyPlugin(SAPresetPropertyPlugin.class.getName())) instanceof SAPresetPropertyPlugin) {
                JSONObject properties = ((SAPresetPropertyPlugin)presetPlugin).getPresetProperties();
                trackEvent.getProperties().remove("$device_id");
                trackEvent.getProperties().remove("$anonymization_id");
                if (this.mInternalConfigs.saConfigOptions.isDisableDeviceId()) {
                    if (properties.has("$anonymization_id")) {
                        trackEvent.getProperties().put("$anonymization_id", (Object)properties.optString("$anonymization_id"));
                    }
                } else if (properties.has("$device_id")) {
                    trackEvent.getProperties().put("$device_id", (Object)properties.optString("$device_id"));
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private boolean isEnterDb(String eventName, JSONObject eventProperties) {
        boolean enterDb = true;
        if (this.mInternalConfigs.sensorsDataTrackEventCallBack != null) {
            SALog.i(TAG, "SDK have set trackEvent callBack");
            try {
                enterDb = this.mInternalConfigs.sensorsDataTrackEventCallBack.onTrackEvent(eventName, eventProperties);
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
            if (enterDb) {
                try {
                    Iterator it = eventProperties.keys();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        Object value = eventProperties.opt(key);
                        if (value instanceof Date) {
                            eventProperties.put(key, (Object)TimeUtils.formatDate((Date)value, TimeUtils.SDK_LOCALE));
                            continue;
                        }
                        eventProperties.put(key, value);
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        }
        return enterDb;
    }
}

