/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.autotrack;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.autotrack.aop.AppAopHelper;
import com.sensorsdata.analytics.android.autotrack.core.business.SAPageTools;
import com.sensorsdata.analytics.android.autotrack.utils.AopUtil;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.ScreenAutoTracker;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.business.session.SessionRelatedManager;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.eventbus.SAEventBus;
import com.sensorsdata.analytics.android.sdk.core.eventbus.Subscription;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.exceptions.SensorsDataExceptionHandler;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

public class ActivityLifecycleCallbacks
implements SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks,
SensorsDataExceptionHandler.SAExceptionListener {
    private static final String TAG = "SA.ActivityLifecycleCallbacks";
    private static final String EVENT_TIME = "event_time";
    private static final String EVENT_DURATION = "event_duration";
    private final SensorsDataAPI mSensorsDataInstance;
    private final SAContextManager mContextManager;
    private boolean resumeFromBackground = false;
    private final DbAdapter mDbAdapter;
    private JSONObject activityProperty = new JSONObject();
    private final JSONObject endDataProperty = new JSONObject();
    private JSONObject mDeepLinkProperty = new JSONObject();
    private int mStartActivityCount;
    private long mStartTime;
    private long mStartTrackTime;
    private final String APP_START_TIME = "app_start_time";
    private final String APP_START_TRACK_TIME = "app_start_track_time";
    private final String APP_END_DATA = "app_end_data";
    private final String APP_RESET_STATE = "app_reset_state";
    private final String TIME = "time";
    private final String ELAPSE_TIME = "elapse_time";
    private Handler mHandler;
    private long messageReceiveTime = 0L;
    private final int MESSAGE_CODE_APP_END = 0;
    private final int MESSAGE_CODE_START = 100;
    private final int MESSAGE_CODE_START_DELAY = 101;
    private final int MESSAGE_CODE_STOP = 200;
    private final Set<Integer> hashSet = new HashSet<Integer>();

    public ActivityLifecycleCallbacks(SAContextManager saContextManager) {
        this.mSensorsDataInstance = saContextManager.getSensorsDataAPI();
        this.mDbAdapter = DbAdapter.getInstance();
        this.mContextManager = saContextManager;
        this.initHandler();
        this.registerAdvertObserver();
        this.hookExitApp();
    }

    private void registerAdvertObserver() {
        if (SAModuleManager.getInstance().hasModuleByName("sensors_analytics_module_advertisement")) {
            SAEventBus.getInstance().register("eventbus_deeplink_launch", (Subscription)new Subscription<JSONObject>(){

                public void notify(JSONObject result) {
                    SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "removeDeepLinkInfo", new Object[]{ActivityLifecycleCallbacks.this.endDataProperty});
                    JSONUtils.mergeJSONObject((JSONObject)result, (JSONObject)ActivityLifecycleCallbacks.this.endDataProperty);
                }
            });
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
        if (!SensorsDataDialogUtils.isSchemeActivity((Context)activity) && !this.hasActivity(activity)) {
            if (this.mStartActivityCount == 0) {
                this.buildScreenProperties(activity);
            }
            this.sendActivityHandleMessage(100);
            this.addActivity(activity);
        }
    }

    public void onActivityResumed(Activity activity) {
        try {
            if (SensorsDataDialogUtils.isSchemeActivity((Context)activity)) {
                return;
            }
            this.buildScreenProperties(activity);
            if (this.mSensorsDataInstance.isAutoTrackEnabled() && !this.mSensorsDataInstance.isActivityAutoTrackAppViewScreenIgnored(activity.getClass()) && !this.mSensorsDataInstance.isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_VIEW_SCREEN)) {
                ScreenAutoTracker screenAutoTracker;
                JSONObject otherProperties;
                JSONObject properties = new JSONObject();
                JSONUtils.mergeJSONObject((JSONObject)this.activityProperty, (JSONObject)properties);
                if (activity instanceof ScreenAutoTracker && (otherProperties = (screenAutoTracker = (ScreenAutoTracker)activity).getTrackProperties()) != null) {
                    JSONUtils.mergeJSONObject((JSONObject)otherProperties, (JSONObject)properties);
                }
                JSONObject eventProperties = SADataHelper.appendLibMethodAutoTrack((JSONObject)properties);
                this.mSensorsDataInstance.trackViewScreen(SAPageTools.getScreenUrl(activity), eventProperties);
            }
        }
        catch (Throwable e) {
            SALog.i((String)TAG, (Throwable)e);
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityStopped(Activity activity) {
        if (!SensorsDataDialogUtils.isSchemeActivity((Context)activity) && this.hasActivity(activity)) {
            this.sendActivityHandleMessage(200);
            this.removeActivity(activity);
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onNewIntent(Intent intent) {
    }

    public void onDelayInitStarted(Activity activity) {
        if (!SensorsDataDialogUtils.isSchemeActivity((Context)activity) && !this.hasActivity(activity)) {
            if (this.mStartActivityCount == 0) {
                this.buildScreenProperties(activity);
            }
            this.sendActivityHandleMessage(101);
            this.addActivity(activity);
        }
    }

    private void initHandler() {
        try {
            HandlerThread handlerThread = new HandlerThread("SENSORS_DATA_THREAD");
            handlerThread.start();
            this.mHandler = new Handler(handlerThread.getLooper()){

                public void handleMessage(Message msg) {
                    int code = msg.what;
                    switch (code) {
                        case 100: 
                        case 101: {
                            ActivityLifecycleCallbacks.this.handleStartedMessage(msg);
                            break;
                        }
                        case 200: {
                            ActivityLifecycleCallbacks.this.handleStoppedMessage(msg);
                            break;
                        }
                        case 0: {
                            if (ActivityLifecycleCallbacks.this.messageReceiveTime != 0L && SystemClock.elapsedRealtime() - ActivityLifecycleCallbacks.this.messageReceiveTime < (long)ActivityLifecycleCallbacks.this.mSensorsDataInstance.getSessionIntervalTime()) {
                                SALog.i((String)ActivityLifecycleCallbacks.TAG, (String)"$AppEnd in time");
                                return;
                            }
                            ActivityLifecycleCallbacks.this.messageReceiveTime = SystemClock.elapsedRealtime();
                            Bundle bundle = msg.getData();
                            String endData = bundle.getString("app_end_data");
                            boolean resetState = bundle.getBoolean("app_reset_state");
                            ActivityLifecycleCallbacks.this.resumeFromBackground = true;
                            if (resetState) {
                                SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "commitRequestDeferredDeeplink", new Object[]{false});
                                if (DbAdapter.getInstance().getActivityCount() > 0) break;
                                ActivityLifecycleCallbacks.this.trackAppEnd(endData);
                                break;
                            }
                            ActivityLifecycleCallbacks.this.trackAppEnd(endData);
                        }
                    }
                }
            };
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    private void handleStartedMessage(Message message) {
        block10: {
            try {
                this.mStartActivityCount = this.mDbAdapter.getActivityCount();
                this.mDbAdapter.commitActivityCount(++this.mStartActivityCount);
                if (this.mStartActivityCount != 1) break block10;
                ActivityLifecycleCallbacks activityLifecycleCallbacks = this;
                if (activityLifecycleCallbacks.mSensorsDataInstance.getConfigOptions().isSaveDeepLinkInfo()) {
                    JSONObject latestJson = (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "getLatestUtmProperties", new Object[0]);
                    JSONUtils.mergeJSONObject((JSONObject)latestJson, (JSONObject)this.endDataProperty);
                }
                this.mHandler.removeMessages(0);
                boolean isSessionTimeout = this.isSessionTimeOut();
                if (!isSessionTimeout) break block10;
                DbAdapter.getInstance().commitAppStartTime(0L);
                this.mHandler.sendMessage(this.obtainAppEndMessage(false));
                boolean firstStart = (Boolean)PersistentLoader.getInstance().getFirstStartPst().get();
                Bundle bundle = message.getData();
                try {
                    boolean isAppStartEnabled;
                    boolean bl = isAppStartEnabled = this.mSensorsDataInstance.isAutoTrackEnabled() && !this.mSensorsDataInstance.isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_START);
                    if (isAppStartEnabled || message.what == 101) {
                        long eventTime;
                        this.mContextManager.checkAppStart(SAStoreManager.getInstance().getString("app_start_data", ""));
                        if (firstStart) {
                            PersistentLoader.getInstance().getFirstStartPst().commit((Object)false);
                        }
                        final JSONObject properties = new JSONObject();
                        properties.put("$resume_from_background", this.resumeFromBackground);
                        properties.put("$is_first_time", firstStart);
                        JSONUtils.mergeJSONObject((JSONObject)this.activityProperty, (JSONObject)properties);
                        if (this.mDeepLinkProperty != null) {
                            JSONUtils.mergeJSONObject((JSONObject)this.mDeepLinkProperty, (JSONObject)properties);
                            this.mDeepLinkProperty = null;
                        }
                        this.mStartTrackTime = eventTime = bundle.getLong("time");
                        properties.put(EVENT_TIME, eventTime > 0L ? eventTime : System.currentTimeMillis());
                        properties.put("$is_first_day", this.mContextManager.isFirstDay(System.currentTimeMillis()));
                        if (message.what == 101) {
                            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                                @Override
                                public void run() {
                                    SAStoreManager.getInstance().setString("app_start_data", properties.toString());
                                }
                            });
                        } else {
                            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                                @Override
                                public void run() {
                                    ActivityLifecycleCallbacks.this.mContextManager.trackEvent(new InputData().setEventName("$AppStart").setProperties(SADataHelper.appendLibMethodAutoTrack((JSONObject)properties)).setEventType(EventType.TRACK));
                                }
                            });
                        }
                        this.mSensorsDataInstance.flush();
                        this.generateAppEndData(System.currentTimeMillis(), SystemClock.elapsedRealtime());
                    }
                }
                catch (Exception e) {
                    SALog.i((String)TAG, (Throwable)e);
                }
                this.updateStartTime(bundle.getLong("elapse_time"));
                this.resumeFromBackground = true;
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
                this.updateStartTime(SystemClock.elapsedRealtime());
            }
        }
    }

    private void handleStoppedMessage(Message message) {
        try {
            this.mStartActivityCount = this.mDbAdapter.getActivityCount();
            this.mStartActivityCount = this.mStartActivityCount > 0 ? (this.mStartActivityCount = this.mStartActivityCount - 1) : 0;
            this.mDbAdapter.commitActivityCount(this.mStartActivityCount);
            if (this.mStartActivityCount <= 0) {
                this.mSensorsDataInstance.flush();
                Bundle bundle = message.getData();
                this.generateAppEndData(bundle.getLong("time"), bundle.getLong("elapse_time"));
                this.mHandler.sendMessageDelayed(this.obtainAppEndMessage(true), (long)this.mSensorsDataInstance.getSessionIntervalTime());
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    private void trackAppEnd(String jsonEndData) {
        try {
            if (this.mSensorsDataInstance.isAutoTrackEnabled() && this.isAutoTrackAppEnd() && !TextUtils.isEmpty((CharSequence)jsonEndData)) {
                final JSONObject property = new JSONObject(jsonEndData);
                if (property.has("track_timer")) {
                    property.put(EVENT_TIME, property.optLong("track_timer"));
                    property.remove("event_timer");
                    property.remove("track_timer");
                }
                property.remove("app_start_time");
                property.remove("app_start_track_time");
                if (DbAdapter.getInstance().getAppStartTime() == 0L) {
                    property.remove(EVENT_DURATION);
                }
                SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                    @Override
                    public void run() {
                        ActivityLifecycleCallbacks.this.mContextManager.trackEvent(new InputData().setEventName("$AppEnd").setProperties(SADataHelper.appendLibMethodAutoTrack((JSONObject)property)).setEventType(EventType.TRACK));
                    }
                });
                this.mDbAdapter.commitAppExitData("");
                this.mSensorsDataInstance.flush();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private void generateAppEndData(long eventTime, long endElapsedTime) {
        try {
            Float duration;
            if (this.mStartTime == 0L) {
                this.mStartTime = DbAdapter.getInstance().getAppStartTime();
            }
            if (this.mStartTrackTime == 0L) {
                try {
                    String endData = DbAdapter.getInstance().getAppExitData();
                    JSONObject jsonObject = new JSONObject(endData);
                    this.mStartTrackTime = jsonObject.optLong("app_start_track_time");
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
            if ((duration = TimeUtils.duration((long)this.mStartTime, (long)endElapsedTime)).floatValue() > 15600.0f) {
                duration = TimeUtils.duration((long)this.mStartTrackTime, (long)eventTime);
            }
            this.endDataProperty.put(EVENT_DURATION, (Object)duration);
            this.endDataProperty.put("app_start_time", this.mStartTime);
            this.endDataProperty.put("app_start_track_time", this.mStartTrackTime);
            this.endDataProperty.put(EVENT_TIME, eventTime);
            if (SensorsDataAPI.getConfigOptions().isEnableSession()) {
                SessionRelatedManager.getInstance().refreshSessionByTimer(eventTime);
                SessionRelatedManager.getInstance().getClass();
                this.endDataProperty.put("$event_session_id", (Object)SessionRelatedManager.getInstance().getSessionID());
            }
            this.endDataProperty.put("$app_version", (Object)AppInfoUtils.getAppVersionName((Context)this.mContextManager.getContext()));
            this.endDataProperty.put("$lib_version", (Object)SensorsDataAPI.sharedInstance().getSDKVersion());
            if (!this.endDataProperty.has("$is_first_day")) {
                this.endDataProperty.put("$is_first_day", this.mContextManager.isFirstDay(System.currentTimeMillis()));
            }
            this.mDbAdapter.commitAppExitData(this.endDataProperty.toString());
        }
        catch (Throwable e) {
            SALog.i((String)TAG, (String)e.getMessage());
        }
    }

    public void hookExitApp() {
        AppAopHelper.addAppListener(new AppAopHelper.AppStateListener(){

            @Override
            public void onAppExit() {
                try {
                    ActivityLifecycleCallbacks.this.generateAppEndData(System.currentTimeMillis(), SystemClock.elapsedRealtime());
                    String dataAppEnd = DbAdapter.getInstance().getAppExitData();
                    if (TextUtils.isEmpty((CharSequence)dataAppEnd)) {
                        ActivityLifecycleCallbacks.this.generateAppEndData(System.currentTimeMillis(), SystemClock.elapsedRealtime());
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        });
    }

    private boolean isSessionTimeOut() {
        long currentTime = Math.max(System.currentTimeMillis(), 946656000000L);
        long endTrackTime = 0L;
        try {
            String endData = DbAdapter.getInstance().getAppExitData();
            if (!TextUtils.isEmpty((CharSequence)endData)) {
                JSONObject endDataJsonObject = new JSONObject(endData);
                endTrackTime = endDataJsonObject.optLong(EVENT_TIME);
                if (this.mStartTime == 0L) {
                    this.updateStartTime(endDataJsonObject.optLong("app_start_time"));
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return Math.abs(currentTime - endTrackTime) > (long)this.mSensorsDataInstance.getSessionIntervalTime();
    }

    private void updateStartTime(long startElapsedTime) {
        try {
            this.mStartTime = startElapsedTime;
            this.mDbAdapter.commitAppStartTime(startElapsedTime > 0L ? startElapsedTime : SystemClock.elapsedRealtime());
        }
        catch (Exception ex) {
            try {
                this.mDbAdapter.commitAppStartTime(startElapsedTime > 0L ? startElapsedTime : SystemClock.elapsedRealtime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sendActivityHandleMessage(int type) {
        Message message = this.mHandler.obtainMessage();
        Bundle bundle = new Bundle();
        bundle.putLong("time", System.currentTimeMillis());
        bundle.putLong("elapse_time", SystemClock.elapsedRealtime());
        message.what = type;
        message.setData(bundle);
        this.mHandler.sendMessage(message);
    }

    private Message obtainAppEndMessage(boolean resetState) {
        Message message = Message.obtain((Handler)this.mHandler);
        message.what = 0;
        Bundle bundle = new Bundle();
        bundle.putString("app_end_data", DbAdapter.getInstance().getAppExitData());
        bundle.putBoolean("app_reset_state", resetState);
        message.setData(bundle);
        return message;
    }

    private boolean isAutoTrackAppEnd() {
        return !this.mSensorsDataInstance.isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_END);
    }

    private void buildScreenProperties(Activity activity) {
        this.activityProperty = AopUtil.buildTitleNoAutoTrackerProperties(activity);
        JSONUtils.mergeJSONObject((JSONObject)this.activityProperty, (JSONObject)this.endDataProperty);
    }

    public void uncaughtException(Thread t, Throwable e) {
        if (TextUtils.isEmpty((CharSequence)DbAdapter.getInstance().getAppExitData())) {
            try {
                DbAdapter.getInstance().commitAppStartTime(SystemClock.elapsedRealtime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.generateAppEndData(System.currentTimeMillis(), SystemClock.elapsedRealtime());
        if (SensorsDataAPI.getConfigOptions().isMultiProcessFlush()) {
            DbAdapter.getInstance().commitSubProcessFlushState(false);
        }
        DbAdapter.getInstance().commitActivityCount(0);
    }

    void addActivity(Activity activity) {
        if (activity != null) {
            this.hashSet.add(activity.hashCode());
        }
    }

    boolean hasActivity(Activity activity) {
        if (activity != null) {
            return this.hashSet.contains(activity.hashCode());
        }
        return false;
    }

    void removeActivity(Activity activity) {
        if (activity != null) {
            this.hashSet.remove(activity.hashCode());
        }
    }
}

