/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.aop;

import com.sensorsdata.analytics.android.sdk.SALog;
import java.util.concurrent.CopyOnWriteArraySet;

public class AppAopHelper {
    private static final CopyOnWriteArraySet<AppStateListener> APP_CALLBACKS = new CopyOnWriteArraySet();

    public static void onAppExit() {
        for (AppStateListener appStateListener : APP_CALLBACKS) {
            try {
                appStateListener.onAppExit();
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    public static void addAppListener(AppStateListener appStateListener) {
        if (appStateListener == null) {
            return;
        }
        APP_CALLBACKS.add(appStateListener);
    }

    public static void removeAppListener(AppStateListener appStateListener) {
        if (appStateListener == null) {
            return;
        }
        APP_CALLBACKS.remove(appStateListener);
    }

    public static interface AppStateListener {
        public void onAppExit();
    }
}

