/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.visitor;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BM\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\u0010\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010%\u001a\u00020\tH\u0016J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0003J\u001e\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0003R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/sensorsdata/analytics/android/plugin/visitor/SensorsAnalyticsMethodCell;", "", "name", "", "desc", "parent", "agentName", "agentDesc", "paramsStart", "", "paramsCount", "opcodes", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/util/List;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAgentDesc", "()Ljava/lang/String;", "setAgentDesc", "(Ljava/lang/String;)V", "getAgentName", "getDesc", "getName", "getOpcodes", "()Ljava/util/List;", "setOpcodes", "(Ljava/util/List;)V", "getParamsCount", "()I", "setParamsCount", "(I)V", "getParamsStart", "setParamsStart", "getParent", "setParent", "equals", "", "other", "hashCode", "visitHookMethod", "", "methodVisitor", "Lorg/objectweb/asm/MethodVisitor;", "opcode", "owner", "visitMethod", "sa-gradle-plugin"})
public final class SensorsAnalyticsMethodCell {
    @NotNull
    private final String name;
    @NotNull
    private final String desc;
    @NotNull
    private final String agentName;
    public String parent;
    public String agentDesc;
    private int paramsStart;
    private int paramsCount;
    public List<Integer> opcodes;

    public SensorsAnalyticsMethodCell(@NotNull String name, @NotNull String desc, @NotNull String agentName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        this.name = name;
        this.desc = desc;
        this.agentName = agentName;
        this.paramsStart = -1;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDesc() {
        return this.desc;
    }

    @NotNull
    public final String getAgentName() {
        return this.agentName;
    }

    @NotNull
    public final String getParent() {
        String string = this.parent;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        return null;
    }

    public final void setParent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.parent = string;
    }

    @NotNull
    public final String getAgentDesc() {
        String string = this.agentDesc;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"agentDesc");
        return null;
    }

    public final void setAgentDesc(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.agentDesc = string;
    }

    public final int getParamsStart() {
        return this.paramsStart;
    }

    public final void setParamsStart(int n) {
        this.paramsStart = n;
    }

    public final int getParamsCount() {
        return this.paramsCount;
    }

    public final void setParamsCount(int n) {
        this.paramsCount = n;
    }

    @NotNull
    public final List<Integer> getOpcodes() {
        List<Integer> list = this.opcodes;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"opcodes");
        return null;
    }

    public final void setOpcodes(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.opcodes = list;
    }

    public SensorsAnalyticsMethodCell(@NotNull String name, @NotNull String desc, @NotNull String parent, @NotNull String agentName, @NotNull String agentDesc, int paramsStart, int paramsCount, @NotNull List<Integer> opcodes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)agentDesc, (String)"agentDesc");
        Intrinsics.checkNotNullParameter(opcodes, (String)"opcodes");
        this(name, desc, agentName);
        this.setParent(parent);
        this.setAgentDesc(agentDesc);
        this.paramsStart = paramsStart;
        this.paramsCount = paramsCount;
        this.setOpcodes(opcodes);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof SensorsAnalyticsMethodCell) {
            return Intrinsics.areEqual((Object)this.name, (Object)((SensorsAnalyticsMethodCell)other).name) && Intrinsics.areEqual((Object)this.desc, (Object)((SensorsAnalyticsMethodCell)other).desc) && Intrinsics.areEqual((Object)this.getParent(), (Object)((SensorsAnalyticsMethodCell)other).getParent());
        }
        return false;
    }

    public final void visitMethod(@NotNull MethodVisitor methodVisitor, int opcode, @NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)this.paramsStart, (int)(this.paramsStart + this.paramsCount))), (int)1);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                methodVisitor.visitVarInsn(((Number)this.getOpcodes().get(i - this.paramsStart)).intValue(), i);
                if (i == n) break;
                i += n2;
            }
        }
        methodVisitor.visitMethodInsn(opcode, owner, this.name, this.desc, false);
    }

    public final void visitHookMethod(@NotNull MethodVisitor methodVisitor, int opcode, @NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)this.paramsStart, (int)(this.paramsStart + this.paramsCount))), (int)1);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                methodVisitor.visitVarInsn(((Number)this.getOpcodes().get(i - this.paramsStart)).intValue(), i);
                if (i == n) break;
                i += n2;
            }
        }
        methodVisitor.visitMethodInsn(opcode, owner, this.agentName, this.getAgentDesc(), false);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.desc.hashCode();
        result = 31 * result + this.getParent().hashCode();
        return result;
    }
}

