/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.version;

import com.google.gson.JsonObject;
import com.sensorsdata.analytics.android.plugin.utils.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionBean;", "", "sensorsDataSDKPath", "", "mMinSensorsDataSDKVersion", "mMessage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSensorsDataSDKPath", "()Ljava/lang/String;", "getSensorsDataSDKVersionMessage", "version", "isVersionValid", "", "saVersion", "requiredVersion", "toString", "Companion", "sa-gradle-plugin"})
public final class SensorsDataSDKVersionBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sensorsDataSDKPath;
    @NotNull
    private final String mMinSensorsDataSDKVersion;
    @NotNull
    private final String mMessage;

    public SensorsDataSDKVersionBean(@NotNull String sensorsDataSDKPath, @NotNull String mMinSensorsDataSDKVersion, @NotNull String mMessage) {
        Intrinsics.checkNotNullParameter((Object)sensorsDataSDKPath, (String)"sensorsDataSDKPath");
        Intrinsics.checkNotNullParameter((Object)mMinSensorsDataSDKVersion, (String)"mMinSensorsDataSDKVersion");
        Intrinsics.checkNotNullParameter((Object)mMessage, (String)"mMessage");
        this.sensorsDataSDKPath = sensorsDataSDKPath;
        this.mMinSensorsDataSDKVersion = mMinSensorsDataSDKVersion;
        this.mMessage = mMessage;
    }

    @NotNull
    public final String getSensorsDataSDKPath() {
        return this.sensorsDataSDKPath;
    }

    @NotNull
    public final String getSensorsDataSDKVersionMessage(@NotNull String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!this.isVersionValid(version, this.mMinSensorsDataSDKVersion)) {
            String string2 = TextUtil.INSTANCE.isEmpty(this.mMessage) ? "\u5f53\u524d\u795e\u7b56 Android SDK \u7248\u672c %s \u8fc7\u4f4e\uff0c\u8bf7\u5347\u7ea7\u81f3 %s \u53ca\u5176\u4ee5\u4e0a\u7248\u672c\u540e\u8fdb\u884c\u4f7f\u7528" : this.mMessage;
            Object[] objectArray = new Object[]{version, this.mMinSensorsDataSDKVersion};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else {
            string = "";
        }
        return string;
    }

    private final boolean isVersionValid(String saVersion, String requiredVersion) {
        boolean bl;
        try {
            boolean bl2;
            if (Intrinsics.areEqual((Object)saVersion, (Object)requiredVersion)) {
                bl2 = true;
            } else {
                String[] stringArray = new String[]{"."};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)saVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray22 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] saVersions = stringArray2;
                String[] $i$f$toTypedArray22 = new String[]{"."};
                Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)requiredVersion, (String[])$i$f$toTypedArray22, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
                if (stringArray3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] requiredVersions = stringArray3;
                int n = requiredVersions.length;
                for (int index = 0; index < n; ++index) {
                    int requiredVersionsNum;
                    int saVersionsNum = Integer.parseInt(saVersions[index]);
                    if (saVersionsNum == (requiredVersionsNum = Integer.parseInt(requiredVersions[index]))) continue;
                    return saVersionsNum > requiredVersionsNum;
                }
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception ex) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "\tminSensorsDataSDKVersion=" + this.mMinSensorsDataSDKVersion + "\n\tsensorsDataSDKPath=" + this.sensorsDataSDKPath + "\n\tmessage=" + this.mMessage;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionBean$Companion;", "", "()V", "createSensorDataSDKBean", "Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionBean;", "jsonObject", "Lcom/google/gson/JsonObject;", "sa-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SensorsDataSDKVersionBean createSensorDataSDKBean(@Nullable JsonObject jsonObject) {
            if (jsonObject != null) {
                try {
                    String path = jsonObject.get("SDK_VERSION_PATH").getAsString();
                    String minVersion = jsonObject.get("DEPENDENT_MIN_SDK_VERSIONS").getAsString();
                    if (!TextUtil.INSTANCE.isEmpty(path) && !TextUtil.INSTANCE.isEmpty(minVersion)) {
                        String string = path;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string2 = path;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
                            CharSequence charSequence = string2;
                            Regex regex = new Regex("\\.");
                            String string3 = "/";
                            path = regex.replace(charSequence, string3);
                        }
                        String message = jsonObject.get("ERROR_MESSAGE").getAsString();
                        String string4 = path;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path");
                        Intrinsics.checkNotNullExpressionValue((Object)minVersion, (String)"minVersion");
                        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                        return new SensorsDataSDKVersionBean(string4, minVersion, message);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

