/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.OAIDService;
import java.lang.reflect.Constructor;

public class ZTEImpl
implements IRomOAID {
    private static final String TAG = "SA.ZTEImpl";
    private static final String ZTE_MANAGER = "android.app.ZteDeviceIdentifyManager";
    private static final String ID_PACKAGE = "com.mdid.msa";
    private final Context mContext;
    private final OAIDService mService;

    ZTEImpl(Context context) {
        this.mContext = context;
        this.mService = new OAIDService();
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getOAID30(Context context) {
        try {
            Constructor<?> declaredConstructor;
            Class<?> cls = Class.forName(ZTE_MANAGER);
            if (cls != null && (declaredConstructor = cls.getDeclaredConstructor(Context.class)) != null) {
                Object newInstance = declaredConstructor.newInstance(context);
                return (String)cls.getDeclaredMethod("getOAID", Context.class).invoke(newInstance, context);
            }
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startMsaklServer(String str, Context context) {
        Intent intent = new Intent();
        intent.setClassName(ID_PACKAGE, "com.mdid.msa.service.MsaKlService");
        intent.setAction("com.bun.msa.action.start.service");
        intent.putExtra("com.bun.msa.param.pkgname", str);
        try {
            intent.putExtra("com.bun.msa.param.runinset", true);
            if (context.startService(intent) == null) return;
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getRomOAID() {
        return this.bindZTEServiceGetOAID(this.mContext);
    }

    public String bindZTEServiceGetOAID(Context context) {
        if (Build.VERSION.SDK_INT <= 29) {
            return this.getOAID29(context);
        }
        return ZTEImpl.getOAID30(context);
    }

    private String getOAID29(Context context) {
        String oaid;
        block5: {
            oaid = null;
            try {
                String packageName = context.getPackageName();
                ZTEImpl.startMsaklServer(packageName, context);
                Intent intent = new Intent();
                intent.setClassName(ID_PACKAGE, "com.mdid.msa.service.MsaIdService");
                intent.setAction("com.bun.msa.action.bindto.service");
                intent.putExtra("com.bun.msa.param.pkgname", packageName);
                if (context.bindService(intent, (ServiceConnection)this.mService, 1)) {
                    oaid = new ZTEInterface(OAIDService.BINDER_QUEUE.take()).getOAID();
                    try {
                        context.unbindService((ServiceConnection)this.mService);
                    }
                    catch (Throwable th) {
                        SALog.i((String)TAG, (Throwable)th);
                    }
                    break block5;
                }
                return oaid;
            }
            catch (Throwable t) {
                SALog.i((String)TAG, (Throwable)t);
            }
        }
        return oaid;
    }

    static class ZTEInterface
    implements IInterface {
        private final IBinder mIBinder;

        ZTEInterface(IBinder iBinder) {
            this.mIBinder = iBinder;
        }

        public IBinder asBinder() {
            return this.mIBinder;
        }

        public String getOAID() {
            String str = null;
            try {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                obtain.writeInterfaceToken("com.bun.lib.MsaIdInterface");
                this.mIBinder.transact(3, obtain, obtain2, 0);
                obtain2.readException();
                str = obtain2.readString();
                obtain.recycle();
                obtain2.recycle();
            }
            catch (Throwable th) {
                SALog.i((String)ZTEImpl.TAG, (Throwable)th);
            }
            return str;
        }
    }
}

