/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.provider.Settings;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.OAIDService;

public class HuaweiImpl
implements IRomOAID {
    private final Context mContext;
    private final OAIDService mService;
    private static final String TAG = "SA.HuaweiImpl";

    public HuaweiImpl(Context context) {
        this.mContext = context;
        this.mService = new OAIDService();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getRomOAID() {
        String[] packages;
        String oaid;
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                oaid = Settings.Global.getString((ContentResolver)this.mContext.getContentResolver(), (String)"pps_oaid");
                if (!TextUtils.isEmpty((CharSequence)oaid)) {
                    SALog.i((String)TAG, (String)"Get oaid from global settings");
                    return oaid;
                }
            }
            catch (Throwable t) {
                SALog.i((String)TAG, (Throwable)t);
            }
        }
        oaid = null;
        for (String pg : packages = new String[]{"com.huawei.hwid", "com.huawei.hwid.tv", "com.huawei.hms"}) {
            if (!TextUtils.isEmpty((CharSequence)oaid)) continue;
            oaid = this.realLoadOaid(pg);
        }
        return oaid;
    }

    private String realLoadOaid(String packageName) {
        try {
            Intent intent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
            intent.setPackage(packageName);
            if (this.mContext.bindService(intent, (ServiceConnection)this.mService, 1)) {
                HuaWeiInterface anInterface = new HuaWeiInterface(OAIDService.BINDER_QUEUE.take());
                return anInterface.getOAID();
            }
        }
        catch (Throwable t) {
            SALog.i((String)TAG, (Throwable)t);
        }
        return "";
    }

    static final class HuaWeiInterface
    implements IInterface {
        private final IBinder iBinder;

        private HuaWeiInterface(IBinder iBinder2) {
            this.iBinder = iBinder2;
        }

        public IBinder asBinder() {
            return this.iBinder;
        }

        public String getOAID() {
            String str = null;
            try {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                obtain.writeInterfaceToken("com.uodis.opendevice.aidl.OpenDeviceIdentifierService");
                this.iBinder.transact(1, obtain, obtain2, 0);
                obtain2.readException();
                str = obtain2.readString();
                obtain.recycle();
                obtain2.recycle();
            }
            catch (Throwable th) {
                SALog.i((String)HuaweiImpl.TAG, (Throwable)th);
            }
            return str;
        }
    }
}

