/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.advert.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.advert.model.SASlinkResponse;
import com.sensorsdata.analytics.android.sdk.advert.model.SATLandingPageType;
import com.sensorsdata.analytics.android.sdk.advert.monitor.SensorsDataCreateSLinkCallback;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SASlinkCreator {
    private String mTemplateID = "";
    private String mName = "";
    private String mToken = "";
    private String mChannelType = "";
    private String mChannelName = "";
    private String mUriSchemeSuffix = "";
    private String mRedirectURLOnOtherDevice = "";
    private String mCommonRedirectURI = "";
    private String mUtmSource = "";
    private String mUtmCampaign = "";
    private String mUtmMedium = "";
    private String mUtmTerm = "";
    private String mUtmContent = "";
    private SATLandingPageType mLandingPageType;
    private JSONObject mCustomParams = new JSONObject();
    private JSONObject mSystemParams = new JSONObject();
    private String mRouteParam;
    private Map<String, String> mLandingPage = new HashMap<String, String>();

    public SASlinkCreator(String templateID, String channelName, String commonRedirectURI, String accessToken) {
        this.mTemplateID = templateID;
        this.mChannelName = channelName;
        this.mCommonRedirectURI = commonRedirectURI;
        this.mToken = accessToken;
    }

    public SASlinkCreator setCustomParams(JSONObject params) {
        this.mCustomParams = params;
        return this;
    }

    public SASlinkCreator setRouteParam(String routeParam) {
        this.mRouteParam = routeParam;
        return this;
    }

    public String getRouteParam() {
        return this.mRouteParam;
    }

    public String getName() {
        return this.mName;
    }

    public SASlinkCreator setName(String name) {
        this.mName = name;
        return this;
    }

    private String getChannelType() {
        return this.mChannelType;
    }

    private SASlinkCreator setChannelType(String channelType) {
        this.mChannelType = channelType;
        return this;
    }

    public String getUriSchemeSuffix() {
        return this.mUriSchemeSuffix;
    }

    public SASlinkCreator setUriSchemeSuffix(String uriSchemeSuffix) {
        this.mUriSchemeSuffix = uriSchemeSuffix;
        return this;
    }

    public String getRedirectURLOnOtherDevice() {
        return this.mRedirectURLOnOtherDevice;
    }

    public SASlinkCreator setRedirectURLOnOtherDevice(String redirectURLOnOtherDevice) {
        this.mRedirectURLOnOtherDevice = redirectURLOnOtherDevice;
        return this;
    }

    public SATLandingPageType getLandingPageType() {
        return this.mLandingPageType;
    }

    public SASlinkCreator setLandingPageType(SATLandingPageType landingPageType) {
        this.mLandingPageType = landingPageType;
        return this;
    }

    public JSONObject getCustomParams() {
        return this.mCustomParams;
    }

    public String getUtmSource() {
        return this.mUtmSource;
    }

    public SASlinkCreator setUtmSource(String utmSource) {
        this.mUtmSource = utmSource;
        return this;
    }

    public String getUtmCampaign() {
        return this.mUtmCampaign;
    }

    public SASlinkCreator setUtmCampaign(String utmCampaign) {
        this.mUtmCampaign = utmCampaign;
        return this;
    }

    public String getUtmMedium() {
        return this.mUtmMedium;
    }

    public SASlinkCreator setUtmMedium(String utmMedium) {
        this.mUtmMedium = utmMedium;
        return this;
    }

    public String getUtmTerm() {
        return this.mUtmTerm;
    }

    public SASlinkCreator setUtmTerm(String utmTerm) {
        this.mUtmTerm = utmTerm;
        return this;
    }

    public String getUtmContent() {
        return this.mUtmContent;
    }

    public SASlinkCreator setUtmContent(String utmContent) {
        this.mUtmContent = utmContent;
        return this;
    }

    public Map<String, String> getLandingPage() {
        return this.mLandingPage;
    }

    public SASlinkCreator setLandingPage(Map<String, String> landingPage) {
        this.mLandingPage = landingPage;
        return this;
    }

    public SASlinkCreator setSystemParams(JSONObject systemParams) {
        this.mSystemParams = systemParams;
        return this;
    }

    public JSONObject getSystemParams() {
        return this.mSystemParams;
    }

    public void createSLink(final Context context, final SensorsDataCreateSLinkCallback callback) {
        String requestUrl = NetworkUtils.getRequestUrl((String)SensorsDataAPI.getConfigOptions().getCustomADChannelUrl(), (String)"slink/dynamic/links");
        try {
            if (this.checkInfo(context, callback, requestUrl)) {
                String serverUrl = SensorsDataAPI.sharedInstance().getServerUrl();
                String projectName = new ServerUrl(serverUrl).getProject();
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("token", this.mToken);
                JSONObject paramObj = new JSONObject();
                paramObj.put("project_name", (Object)projectName);
                paramObj.put("slink_template_id", (Object)this.mTemplateID);
                paramObj.put("name", (Object)this.getName());
                paramObj.put("channel_type", (Object)"app_share");
                paramObj.put("channel_name", (Object)this.mChannelName);
                paramObj.put("custom_param", (Object)this.getCustomParams());
                paramObj.put("system_param", (Object)this.getSystemParams());
                paramObj.put("route_param", (Object)this.getRouteParam());
                paramObj.put("fixed_param", (Object)new JSONObject().put("channel_utm_campaign", (Object)this.getUtmCampaign()).put("channel_utm_content", (Object)this.getUtmContent()).put("channel_utm_medium", (Object)this.getUtmMedium()).put("channel_utm_source", (Object)this.getUtmSource()).put("channel_utm_term", (Object)this.getUtmTerm()));
                paramObj.put("uri_scheme_suffix", (Object)this.getUriSchemeSuffix());
                if (this.getLandingPageType() != null) {
                    paramObj.put("landing_page_type", (Object)this.getLandingPageType().getTypeName());
                }
                paramObj.put("other_landing_page_map", (Object)new JSONObject(this.getLandingPage()));
                paramObj.put("jump_address", (Object)this.mRedirectURLOnOtherDevice);
                new RequestHelper.Builder(HttpMethod.POST, requestUrl).header(headerMap).jsonData(paramObj.toString()).callback((HttpCallback)new HttpCallback.JsonCallback(){

                    public void onFailure(int code, String errorMessage) {
                        if (code == 0) {
                            code = 10006;
                        }
                        SASlinkCreator.this.trackSlinkCreate(code, errorMessage, callback);
                    }

                    public void onResponse(JSONObject response) {
                        int responseCode = 10004;
                        String responseMsg = SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_response_data_error);
                        String slinkId = "";
                        String shareLink = "";
                        if (response != null) {
                            responseCode = response.optInt("code", 10004);
                            if (responseCode == 0) {
                                responseMsg = response.optString("msg", SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_success));
                                JSONObject dataObj = response.optJSONObject("data");
                                if (dataObj != null) {
                                    slinkId = dataObj.optString("slink_id");
                                    shareLink = dataObj.optString("short_url");
                                }
                            } else if (responseCode != 10004) {
                                responseMsg = response.optString("msg");
                            }
                        }
                        SASlinkCreator.this.trackSlinkCreate(responseCode, responseMsg, slinkId, shareLink, callback);
                    }
                }).execute();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private boolean checkInfo(Context context, SensorsDataCreateSLinkCallback callback, String requestUrl) {
        if (callback == null) {
            this.trackSlinkCreate(10005, SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_callback_missing), null);
            return false;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)context)) {
            this.trackSlinkCreate(10002, SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_no_network), callback);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)requestUrl) || !requestUrl.startsWith("http://") && !requestUrl.startsWith("https://")) {
            this.trackSlinkCreate(10003, SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_custom_url_error), callback);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mToken)) {
            this.trackSlinkCreate(10001, SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_token_missing), callback);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mTemplateID)) {
            this.trackSlinkCreate(10001, SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_template_id_missing), callback);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mChannelName)) {
            this.trackSlinkCreate(10001, SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_channel_name_missing), callback);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mCommonRedirectURI)) {
            this.trackSlinkCreate(10001, SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_ad_create_link_common_redirect_url_missing), callback);
            return false;
        }
        return true;
    }

    private void trackSlinkCreate(int responseCode, String responseMsg, SensorsDataCreateSLinkCallback callback) {
        this.trackSlinkCreate(responseCode, responseMsg, "", "", callback);
    }

    private void trackSlinkCreate(int responseCode, String responseMsg, String slinkId, String shareLink, SensorsDataCreateSLinkCallback callback) {
        SASlinkResponse response = new SASlinkResponse();
        response.slink = shareLink;
        response.statusCode = responseCode;
        response.message = responseMsg;
        response.slinkID = slinkId;
        response.commonRedirectURI = this.mCommonRedirectURI;
        JSONObject params = new JSONObject();
        try {
            params.put("$ad_dynamic_slink_channel_type", (Object)"app_share").put("$ad_dynamic_slink_source", (Object)"Android").put("$ad_dynamic_slink_channel_name", (Object)this.mChannelName).put("$ad_dynamic_slink_data", (Object)"").put("$ad_dynamic_slink_short_url", (Object)shareLink).put("$ad_dynamic_slink_status", responseCode).put("$ad_dynamic_slink_msg", (Object)(responseMsg.length() <= 200 ? responseMsg : responseMsg.substring(0, 200))).put("$ad_slink_id", (Object)slinkId).put("$ad_slink_template_id", (Object)this.mTemplateID).put("$ad_slink_type", (Object)"dynamic");
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        SensorsDataAPI.sharedInstance().track("$AdDynamicSlinkCreate", params);
        if (callback != null) {
            callback.onReceive(response);
        }
    }
}

