/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.utils;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.exceptions.ConnectErrorException;
import com.sensorsdata.analytics.android.sdk.exceptions.ResponseErrorException;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;

public class SAAdvertUtils {
    private static final String TAG = "SA.SAAdvert";

    public static boolean isFirstTrackInstallation(boolean disableCallback) {
        if (disableCallback) {
            return (Boolean)PersistentLoader.getInstance().getFirstInstallationWithCallbackPst().get();
        }
        return (Boolean)PersistentLoader.getInstance().getFirstInstallationPst().get();
    }

    public static void setTrackInstallation(boolean disableCallback) {
        if (disableCallback) {
            PersistentLoader.getInstance().getFirstInstallationWithCallbackPst().commit((Object)false);
        }
        PersistentLoader.getInstance().getFirstInstallationPst().commit((Object)false);
    }

    public static String getIdentifier(Context context) {
        return SensorsDataUtils.getIdentifier((Context)context);
    }

    public static String getInstallSource(Context context) {
        return String.format("imei=%s##imei_old=%s##imei_slot1=%s##imei_slot2=%s##imei_meid=%s", "", "", "", "", "");
    }

    public static void sendData(Context context, String path, JSONObject sendData, String rawMessage) {
        if (!SensorsDataAPI.sharedInstance().isNetworkRequestEnable()) {
            SALog.i((String)TAG, (String)"NetworkRequest is disabled");
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)context)) {
            return;
        }
        if (sendData != null && sendData.length() > 0) {
            String gzip = "1";
            try {
                JSONArray jsonArray = new JSONArray();
                jsonArray.put((Object)sendData);
                String data = jsonArray.toString();
                if (sendData.has("ekey")) {
                    gzip = "9";
                } else {
                    data = SADataHelper.gzipData((String)data);
                }
                sendData.put("_flush_time", System.currentTimeMillis());
                SAAdvertUtils.sendHttpRequest(path, String.valueOf(data.hashCode()), gzip, data, rawMessage);
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    public static boolean isInstallationTracked() {
        return SAStoreManager.getInstance().isExists("first_track_installation") || SAStoreManager.getInstance().isExists("first_track_installation_with_callback");
    }

    private static synchronized void sendHttpRequest(String path, String crc, String gzip, String data, String rawMessage) throws ConnectErrorException, ResponseErrorException {
        BufferedOutputStream bout;
        OutputStream out;
        InputStream in;
        HttpURLConnection connection;
        block12: {
            String query;
            block11: {
                block10: {
                    connection = null;
                    in = null;
                    out = null;
                    bout = null;
                    URL url = new URL(path);
                    connection = (HttpURLConnection)url.openConnection();
                    if (connection != null) break block10;
                    SALog.i((String)TAG, (String)String.format("can not connect %s, it shouldn't happen", url));
                    SADataHelper.closeStream(bout, out, in, (HttpURLConnection)connection);
                    return;
                }
                connection.setInstanceFollowRedirects(false);
                Uri.Builder builder = new Uri.Builder();
                if (!TextUtils.isEmpty((CharSequence)crc)) {
                    builder.appendQueryParameter("crc", crc);
                }
                builder.appendQueryParameter("gzip", gzip);
                builder.appendQueryParameter("data_list", data);
                builder.appendQueryParameter("sink_name", "mirror");
                query = builder.build().getEncodedQuery();
                if (!TextUtils.isEmpty((CharSequence)query)) break block11;
                SADataHelper.closeStream(bout, out, in, (HttpURLConnection)connection);
                return;
            }
            try {
                connection.setFixedLengthStreamingMode(query.getBytes("UTF-8").length);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                out = connection.getOutputStream();
                bout = new BufferedOutputStream(out);
                bout.write(query.getBytes("UTF-8"));
                bout.flush();
                int responseCode = connection.getResponseCode();
                SALog.i((String)TAG, (String)("responseCode: " + responseCode));
                try {
                    in = connection.getInputStream();
                }
                catch (FileNotFoundException e) {
                    in = connection.getErrorStream();
                }
                byte[] responseBody = SADataHelper.slurp((InputStream)in);
                in.close();
                in = null;
                String response = new String(responseBody, "UTF-8");
                if (!SALog.isLogEnabled()) break block12;
                String jsonMessage = JSONUtils.formatJson((String)rawMessage);
                if (responseCode >= 200 && responseCode < 300) {
                    SALog.i((String)TAG, (String)("sat valid message: \n" + jsonMessage));
                    break block12;
                }
                SALog.i((String)TAG, (String)("sat invalid message: \n" + jsonMessage));
                SALog.i((String)TAG, (String)String.format(TimeUtils.SDK_LOCALE, "ret_code: %d", responseCode));
                SALog.i((String)TAG, (String)String.format(TimeUtils.SDK_LOCALE, "ret_content: %s", response));
            }
            catch (IOException e) {
                try {
                    throw new ConnectErrorException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SADataHelper.closeStream(bout, out, in, connection);
                    throw throwable;
                }
            }
        }
        SADataHelper.closeStream((BufferedOutputStream)bout, (OutputStream)out, (InputStream)in, (HttpURLConnection)connection);
    }
}

