/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.app.Application;
import android.content.Context;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;
import com.sensorsdata.analytics.android.sdk.advert.oaid.OAIDRom;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.AsusImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.CoolpadImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.DefaultImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.HuaweiImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.LenovoImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.MeizuImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.NubiaImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.OppoImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.SamsungImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.VivoImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.XiaomiImpl;
import com.sensorsdata.analytics.android.sdk.advert.oaid.impl.ZTEImpl;

public final class OAIDFactory {
    private static IRomOAID ioaid;
    private static final String TAG = "SA.OAIDFactory";

    public static IRomOAID create(Context context) {
        if (context != null && !(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        if (ioaid != null) {
            return ioaid;
        }
        ioaid = OAIDFactory.createManufacturerImpl(context);
        if (ioaid != null && ioaid.isSupported()) {
            SALog.i((String)TAG, (String)("Manufacturer interface has been found: " + ioaid.getClass().getName()));
            return ioaid;
        }
        ioaid = new DefaultImpl();
        return ioaid;
    }

    private static IRomOAID createManufacturerImpl(Context context) {
        if (OAIDRom.isHuawei() || OAIDRom.isEmui()) {
            return new HuaweiImpl(context);
        }
        if (OAIDRom.isXiaomi() || OAIDRom.isMiui() || OAIDRom.isBlackShark()) {
            return new XiaomiImpl(context);
        }
        if (OAIDRom.isVivo()) {
            return new VivoImpl(context);
        }
        if (OAIDRom.isOppo() || OAIDRom.isOnePlus()) {
            return new OppoImpl(context);
        }
        if (OAIDRom.isMeizu()) {
            return new MeizuImpl(context);
        }
        if (OAIDRom.isSamsung()) {
            return new SamsungImpl(context);
        }
        if (OAIDRom.isNubia()) {
            return new NubiaImpl(context);
        }
        if (OAIDRom.isASUS()) {
            return new AsusImpl(context);
        }
        if (OAIDRom.isLenovo() || OAIDRom.isMotolora()) {
            return new LenovoImpl(context);
        }
        if (OAIDRom.isZTE()) {
            return new ZTEImpl(context);
        }
        if (OAIDRom.isCoolpad(context)) {
            return new CoolpadImpl(context);
        }
        return null;
    }
}

