/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.deeplink;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.AbsDeepLink;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.DeepLinkManager;
import com.sensorsdata.analytics.android.sdk.advert.utils.ChannelUtils;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class SensorsDataDeepLink
extends AbsDeepLink {
    private final String serverUrl;
    private final String project;
    private String pageParams;
    private String errorMsg;
    private boolean success;
    private final String customADChannelUrl;
    private String adSlinkId;
    private String adSlinkTemplateId;
    private String adSlinkType;
    private JSONObject customParams;

    public SensorsDataDeepLink(Intent intent, String serverUrl, String customADChannelUrl) {
        super(intent);
        this.serverUrl = serverUrl;
        this.customADChannelUrl = customADChannelUrl;
        this.project = new ServerUrl(serverUrl).getProject();
    }

    @Override
    public void parseDeepLink(Intent intent) {
        if (intent == null || intent.getData() == null) {
            return;
        }
        Uri uri = intent.getData();
        String key = uri.getLastPathSegment();
        if (!TextUtils.isEmpty((CharSequence)key)) {
            final long requestDeepLinkStartTime = System.currentTimeMillis();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("key", key);
            params.put("system_type", "ANDROID");
            params.put("project", this.project);
            new RequestHelper.Builder(HttpMethod.GET, this.isSlink(uri, NetworkUtils.getHost((String)this.customADChannelUrl)) ? this.getSlinkRequestUrl() : this.getRequestUrl()).params(params).callback((HttpCallback)new HttpCallback.JsonCallback(){

                public void onFailure(int code, String errorMessage) {
                    SensorsDataDeepLink.this.errorMsg = errorMessage;
                    SensorsDataDeepLink.this.success = false;
                }

                public void onResponse(JSONObject response) {
                    if (response != null) {
                        SensorsDataDeepLink.this.success = true;
                        JSONObject channel = response.optJSONObject("channel_params");
                        Map params = JSONUtils.json2Map((JSONObject)channel);
                        ChannelUtils.parseParams(params);
                        SensorsDataDeepLink.this.pageParams = response.optString("page_params");
                        SensorsDataDeepLink.this.errorMsg = response.optString("errorMsg");
                        if (TextUtils.isEmpty((CharSequence)SensorsDataDeepLink.this.errorMsg)) {
                            SensorsDataDeepLink.this.errorMsg = response.optString("error_msg");
                        }
                        SensorsDataDeepLink.this.adSlinkId = response.optString("ad_slink_id");
                        SensorsDataDeepLink.this.adSlinkTemplateId = response.optString("slink_template_id");
                        SensorsDataDeepLink.this.adSlinkType = response.optString("slink_type");
                        SensorsDataDeepLink.this.customParams = response.optJSONObject("custom_params");
                        if (!TextUtils.isEmpty((CharSequence)SensorsDataDeepLink.this.errorMsg)) {
                            SensorsDataDeepLink.this.success = false;
                        }
                    } else {
                        SensorsDataDeepLink.this.success = false;
                    }
                }

                public void onAfter() {
                    long duration = System.currentTimeMillis() - requestDeepLinkStartTime;
                    final JSONObject properties = new JSONObject();
                    try {
                        if (!TextUtils.isEmpty((CharSequence)SensorsDataDeepLink.this.pageParams)) {
                            properties.put("$deeplink_options", (Object)SensorsDataDeepLink.this.pageParams);
                        }
                        if (!TextUtils.isEmpty((CharSequence)SensorsDataDeepLink.this.errorMsg)) {
                            properties.put("$deeplink_match_fail_reason", (Object)SensorsDataDeepLink.this.errorMsg);
                        }
                        if (!TextUtils.isEmpty((CharSequence)SensorsDataDeepLink.this.adSlinkId)) {
                            properties.put("$ad_slink_id", (Object)SensorsDataDeepLink.this.adSlinkId);
                        }
                        properties.put("$deeplink_url", (Object)SensorsDataDeepLink.this.getDeepLinkUrl());
                        properties.put("$event_duration", (Object)TimeUtils.duration((float)duration));
                        if (!TextUtils.isEmpty((CharSequence)SensorsDataDeepLink.this.adSlinkTemplateId)) {
                            properties.put("$ad_slink_template_id", (Object)SensorsDataDeepLink.this.adSlinkTemplateId);
                        }
                        if (!TextUtils.isEmpty((CharSequence)SensorsDataDeepLink.this.adSlinkType)) {
                            properties.put("$ad_slink_type", (Object)SensorsDataDeepLink.this.adSlinkType);
                        }
                        if (SensorsDataDeepLink.this.customParams != null && SensorsDataDeepLink.this.customParams.length() > 0) {
                            properties.put("$sat_slink_custom_params", (Object)SensorsDataDeepLink.this.customParams.toString());
                        }
                    }
                    catch (JSONException e) {
                        SALog.printStackTrace((Exception)((Object)e));
                    }
                    JSONUtils.mergeJSONObject((JSONObject)ChannelUtils.getUtmProperties(), (JSONObject)properties);
                    if (SensorsDataDeepLink.this.mCallBack != null) {
                        SensorsDataDeepLink.this.mCallBack.onFinish(DeepLinkManager.DeepLinkType.SENSORSDATA, SensorsDataDeepLink.this.pageParams, SensorsDataDeepLink.this.customParams, SensorsDataDeepLink.this.success, duration);
                    }
                    SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                        @Override
                        public void run() {
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName("$AppDeeplinkMatchedResult").setProperties(properties));
                        }
                    });
                }
            }).execute();
        }
    }

    @Override
    public void mergeDeepLinkProperty(JSONObject properties) {
        try {
            properties.put("$deeplink_url", (Object)this.getDeepLinkUrl());
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public String getRequestUrl() {
        int pathPrefix;
        if (!TextUtils.isEmpty((CharSequence)this.serverUrl) && (pathPrefix = this.serverUrl.lastIndexOf("/")) != -1) {
            return this.serverUrl.substring(0, pathPrefix) + "/sdk/deeplink/param";
        }
        return "";
    }

    private boolean isSlink(Uri uri, String customADChannelUrl) {
        if (TextUtils.isEmpty((CharSequence)customADChannelUrl)) {
            return false;
        }
        List paths = uri.getPathSegments();
        if (null != paths && !paths.isEmpty() && ((String)paths.get(0)).equals("slink")) {
            String host = uri.getHost();
            return !TextUtils.isEmpty((CharSequence)host) && (NetworkUtils.compareMainDomain((String)customADChannelUrl, (String)host) || host.equals("sensorsdata"));
        }
        return false;
    }

    private String getSlinkRequestUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.customADChannelUrl)) {
            return NetworkUtils.getRequestUrl((String)this.customADChannelUrl, (String)"slink/config/query");
        }
        return "";
    }
}

