/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class UpdateWebhook {
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="events")
    private List<EventsEnum> events = null;
    @SerializedName(value="domain")
    private String domain = null;

    public UpdateWebhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", value="URL of the webhook")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UpdateWebhook description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Webhook triggered on contact hardbounce", value="Description of the webhook")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateWebhook events(List<EventsEnum> events) {
        this.events = events;
        return this;
    }

    public UpdateWebhook addEventsItem(EventsEnum eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<EventsEnum>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="- Events triggering the webhook. Possible values for **Transactional** type webhook: #### `sent` OR `request`, `delivered`, `hardBounce`, `softBounce`, `blocked`, `spam`, `invalid`, `deferred`, `click`, `opened`, `uniqueOpened` and `unsubscribed` - Possible values for **Marketing** type webhook: #### `spam`, `opened`, `click`, `hardBounce`, `softBounce`, `unsubscribed`, `listAddition` & `delivered` - Possible values for **Inbound** type webhook: #### `inboundEmailProcessed` ")
    public List<EventsEnum> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventsEnum> events) {
        this.events = events;
    }

    public UpdateWebhook domain(String domain) {
        this.domain = domain;
        return this;
    }

    @ApiModelProperty(example="example.com", value="Inbound domain of webhook, used in case of event type `inbound`")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateWebhook updateWebhook = (UpdateWebhook)o;
        return ObjectUtils.equals((Object)this.url, (Object)updateWebhook.url) && ObjectUtils.equals((Object)this.description, (Object)updateWebhook.description) && ObjectUtils.equals(this.events, updateWebhook.events) && ObjectUtils.equals((Object)this.domain, (Object)updateWebhook.domain);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.url, this.description, this.events, this.domain});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateWebhook {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventsEnum {
        SENT("sent"),
        HARDBOUNCE("hardBounce"),
        SOFTBOUNCE("softBounce"),
        BLOCKED("blocked"),
        SPAM("spam"),
        DELIVERED("delivered"),
        REQUEST("request"),
        CLICK("click"),
        INVALID("invalid"),
        DEFERRED("deferred"),
        OPENED("opened"),
        UNIQUEOPENED("uniqueOpened"),
        UNSUBSCRIBED("unsubscribed"),
        LISTADDITION("listAddition"),
        CONTACTUPDATED("contactUpdated"),
        CONTACTDELETED("contactDeleted"),
        INBOUNDEMAILPROCESSED("inboundEmailProcessed");

        private String value;

        private EventsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventsEnum fromValue(String text) {
            for (EventsEnum b : EventsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EventsEnum> {
            public void write(JsonWriter jsonWriter, EventsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

