/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Task Details")
public class Task {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="taskTypeId")
    private String taskTypeId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="contactsIds")
    private List<Integer> contactsIds = null;
    @SerializedName(value="dealsIds")
    private List<String> dealsIds = null;
    @SerializedName(value="companiesIds")
    private List<String> companiesIds = null;

    public Task id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="61a5cd07ca1347c82306ad06", value="Unique task id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Task taskTypeId(String taskTypeId) {
        this.taskTypeId = taskTypeId;
        return this;
    }

    @ApiModelProperty(example="61a5cd07ca1347c82306ad09", required=true, value="Id for type of task e.g Call / Email / Meeting etc.")
    public String getTaskTypeId() {
        return this.taskTypeId;
    }

    public void setTaskTypeId(String taskTypeId) {
        this.taskTypeId = taskTypeId;
    }

    public Task name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Task: Connect with client", required=true, value="Name of task")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Task contactsIds(List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
        return this;
    }

    public Task addContactsIdsItem(Integer contactsIdsItem) {
        if (this.contactsIds == null) {
            this.contactsIds = new ArrayList<Integer>();
        }
        this.contactsIds.add(contactsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[1,2,3]", value="Contact ids for contacts linked to this task")
    public List<Integer> getContactsIds() {
        return this.contactsIds;
    }

    public void setContactsIds(List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
    }

    public Task dealsIds(List<String> dealsIds) {
        this.dealsIds = dealsIds;
        return this;
    }

    public Task addDealsIdsItem(String dealsIdsItem) {
        if (this.dealsIds == null) {
            this.dealsIds = new ArrayList<String>();
        }
        this.dealsIds.add(dealsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Deal ids for deals a task is linked to")
    public List<String> getDealsIds() {
        return this.dealsIds;
    }

    public void setDealsIds(List<String> dealsIds) {
        this.dealsIds = dealsIds;
    }

    public Task companiesIds(List<String> companiesIds) {
        this.companiesIds = companiesIds;
        return this;
    }

    public Task addCompaniesIdsItem(String companiesIdsItem) {
        if (this.companiesIds == null) {
            this.companiesIds = new ArrayList<String>();
        }
        this.companiesIds.add(companiesIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Companies ids for companies a task is linked to")
    public List<String> getCompaniesIds() {
        return this.companiesIds;
    }

    public void setCompaniesIds(List<String> companiesIds) {
        this.companiesIds = companiesIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return ObjectUtils.equals((Object)this.id, (Object)task.id) && ObjectUtils.equals((Object)this.taskTypeId, (Object)task.taskTypeId) && ObjectUtils.equals((Object)this.name, (Object)task.name) && ObjectUtils.equals(this.contactsIds, task.contactsIds) && ObjectUtils.equals(this.dealsIds, task.dealsIds) && ObjectUtils.equals(this.companiesIds, task.companiesIds);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.taskTypeId, this.name, this.contactsIds, this.dealsIds, this.companiesIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Task {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    taskTypeId: ").append(this.toIndentedString(this.taskTypeId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    contactsIds: ").append(this.toIndentedString(this.contactsIds)).append("\n");
        sb.append("    dealsIds: ").append(this.toIndentedString(this.dealsIds)).append("\n");
        sb.append("    companiesIds: ").append(this.toIndentedString(this.companiesIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

